/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.solr.ResizeableArrayList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;

public class ArrayListCache
implements SolrCache {
    private Persistence persistence;
    private String description;
    private String name;
    private SolrCache.State state;
    private ConcurrentHashMap<Object, ResizeableArrayList<Object>> currentLists = new ConcurrentHashMap();

    public String getName() {
        return this.getClass().getName();
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return this.description;
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CACHE;
    }

    public String getSourceId() {
        return "ArrayListCache.java";
    }

    public String getSource() {
        return null;
    }

    public URL[] getDocs() {
        return null;
    }

    public NamedList<?> getStatistics() {
        return null;
    }

    public Object init(Map args, Object existingPersistence, CacheRegenerator regenerator) {
        this.state = SolrCache.State.CREATED;
        this.name = (String)args.get("name");
        this.persistence = (Persistence)existingPersistence;
        if (this.persistence == null) {
            this.persistence = new Persistence();
        }
        return this.persistence;
    }

    public String name() {
        return this.name;
    }

    public int size() {
        return this.currentLists.size();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        ResizeableArrayList<Object> result = this.currentLists.get(key);
        if (result == null) {
            result = this.persistence.borrow(key);
            if (result == null) {
                result = new ResizeableArrayList();
            }
            result.activate();
            this.currentLists.put(key, result);
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void setState(SolrCache.State state) {
        this.state = state;
    }

    public SolrCache.State getState() {
        return this.state;
    }

    public void warm(SolrIndexSearcher searcher, SolrCache old) throws IOException {
    }

    public void close() {
        for (Map.Entry<Object, ResizeableArrayList<Object>> entry : this.currentLists.entrySet()) {
            ResizeableArrayList<Object> value = entry.getValue();
            value.deactivate();
            this.persistence.returnObject(entry.getKey(), value);
        }
    }

    private static class Persistence {
        private ConcurrentHashMap<Object, ResizeableArrayList<Object>> pooledLists = new ConcurrentHashMap();

        private Persistence() {
        }

        public ResizeableArrayList<Object> borrow(Object key) {
            return this.pooledLists.remove(key);
        }

        public void returnObject(Object key, ResizeableArrayList<Object> value) {
            this.pooledLists.put(key, value);
        }
    }
}

