/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AbstractAnalyzer;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.analysis.LongAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.MLAnalayser;
import org.alfresco.repo.search.impl.lucene.analysis.PathAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.VerbatimAnalyser;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class SolrLuceneAnalyser
extends AbstractAnalyzer {
    protected static final Logger log = LoggerFactory.getLogger(SolrLuceneAnalyser.class);
    private DictionaryService dictionaryService;
    private Analyzer defaultAnalyser;
    private Map<String, Analyzer> analysers = new HashMap<String, Analyzer>();
    private MLAnalysisMode mlAlaysisMode;
    private AlfrescoSolrDataModel model;

    public SolrLuceneAnalyser(DictionaryService dictionaryService, MLAnalysisMode mlAlaysisMode, Analyzer defaultAnalyser, AlfrescoSolrDataModel model) {
        this.dictionaryService = dictionaryService;
        this.mlAlaysisMode = mlAlaysisMode;
        this.defaultAnalyser = defaultAnalyser;
        this.model = model;
    }

    public Analyzer getDefaultAnalyser() {
        return this.defaultAnalyser;
    }

    public TokenStream tokenStream(String fieldName, Reader reader, AnalysisMode analysisMode) {
        Analyzer analyser = this.analysers.get(fieldName);
        if (analyser == null) {
            analyser = this.findAnalyser(fieldName, analysisMode);
            this.analysers.put(fieldName, analyser);
        }
        return analyser.tokenStream(fieldName, reader);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return this.tokenStream(fieldName, reader, AnalysisMode.DEFAULT);
    }

    private Analyzer findAnalyser(String fieldName, AnalysisMode analysisMode) {
        if (fieldName.equals("ID")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("LID")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("DBID")) {
            return new LongAnalyser();
        }
        if (fieldName.equals("TXID")) {
            return new LongAnalyser();
        }
        if (fieldName.equals("INTXID")) {
            return new LongAnalyser();
        }
        if (fieldName.equals("ACLTXID")) {
            return new LongAnalyser();
        }
        if (fieldName.equals("INACLTXID")) {
            return new LongAnalyser();
        }
        if (fieldName.equals("TXCOMMITTIME")) {
            return new LongAnalyser();
        }
        if (fieldName.equals("ACLTXCOMMITTIME")) {
            return new LongAnalyser();
        }
        if (fieldName.equals("ACLID")) {
            return new LongAnalyser();
        }
        if (fieldName.equals("TX")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("PARENT")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("LINKASPECT")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("PATH")) {
            return new PathAnalyser();
        }
        if (fieldName.equals("ANCESTOR")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("TENANT")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("ISCONTAINER")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("READER")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("OWNER")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("ISCATEGORY")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("QNAME")) {
            return new PathAnalyser();
        }
        if (fieldName.equals("ISROOT")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("PRIMARYASSOCTYPEQNAME")) {
            return new PathAnalyser();
        }
        if (fieldName.equals("PRIMARYASSOCQNAME")) {
            return new PathAnalyser();
        }
        if (fieldName.equals("PARENTASSOCCRC")) {
            return new LongAnalyser();
        }
        if (fieldName.equals("ISNODE")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("ASSOCTYPEQNAME")) {
            return new PathAnalyser();
        }
        if (fieldName.equals("PRIMARYPARENT")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("TYPE")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("ASPECT")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("FTSSTATUS")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("EXCEPTIONMESSAGE")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.equals("EXCEPTIONSTACK")) {
            return new VerbatimAnalyser(false);
        }
        if (fieldName.startsWith("@")) {
            DataTypeDefinition dataType;
            QName testPropertyQName;
            PropertyDefinition propertyDef;
            if (fieldName.endsWith(".sort")) {
                return new VerbatimAnalyser(false);
            }
            for (String contentEnding : AlfrescoSolrDataModel.additionalContentFields.keySet()) {
                if (!fieldName.endsWith(contentEnding)) continue;
                try {
                    int end = fieldName.length() - contentEnding.length();
                    if (end <= 0 || (propertyDef = this.dictionaryService.getProperty(testPropertyQName = QName.createQName((String)fieldName.substring(1, end)))) == null || !propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) continue;
                    if (fieldName.endsWith(".size")) {
                        return new LongAnalyser();
                    }
                    if (fieldName.endsWith(".locale")) {
                        return new VerbatimAnalyser(true);
                    }
                    if (fieldName.endsWith(".mimetype")) {
                        return new VerbatimAnalyser();
                    }
                    if (fieldName.endsWith(".encoding")) {
                        return new VerbatimAnalyser();
                    }
                    if (fieldName.endsWith(".contentDocId")) {
                        return new LongAnalyser();
                    }
                    if (fieldName.endsWith(".transformationException")) {
                        return this.defaultAnalyser;
                    }
                    if (fieldName.endsWith(".transformationTime")) {
                        return new LongAnalyser();
                    }
                    if (fieldName.endsWith(".transformationStatus")) {
                        return new VerbatimAnalyser();
                    }
                    if (!fieldName.endsWith(".__")) continue;
                    return new MLAnalayser(this.dictionaryService, MLAnalysisMode.ALL_ONLY, this.defaultAnalyser);
                }
                catch (InvalidQNameException iqne) {
                }
            }
            for (String textEnding : AlfrescoSolrDataModel.additionalTextFields.keySet()) {
                if (!fieldName.endsWith(textEnding)) continue;
                try {
                    int end = fieldName.length() - textEnding.length();
                    if (end <= 0 || (propertyDef = this.dictionaryService.getProperty(testPropertyQName = QName.createQName((String)fieldName.substring(1, end)))) == null || !propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT)) continue;
                    if (fieldName.endsWith(".__")) {
                        return new MLAnalayser(this.dictionaryService, MLAnalysisMode.ALL_ONLY, this.defaultAnalyser);
                    }
                    if (fieldName.endsWith(".__.u")) {
                        return new MLAnalayser(this.dictionaryService, MLAnalysisMode.ALL_ONLY, (Analyzer)new VerbatimAnalyser(false));
                    }
                    if (fieldName.endsWith(".u")) {
                        return new MLAnalayser(this.dictionaryService, MLAnalysisMode.EXACT_LANGUAGE, (Analyzer)new VerbatimAnalyser(false));
                    }
                    if (!fieldName.endsWith(".sort")) continue;
                    return new VerbatimAnalyser(false);
                }
                catch (InvalidQNameException iqne) {
                }
            }
            for (String mlTexttEnding : AlfrescoSolrDataModel.additionalMlTextFields.keySet()) {
                if (!fieldName.endsWith(mlTexttEnding)) continue;
                try {
                    int end = fieldName.length() - mlTexttEnding.length();
                    if (end <= 0 || (propertyDef = this.dictionaryService.getProperty(testPropertyQName = QName.createQName((String)fieldName.substring(1, end)))) == null || !propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) continue;
                    if (fieldName.endsWith(".__")) {
                        return new MLAnalayser(this.dictionaryService, MLAnalysisMode.ALL_ONLY, this.defaultAnalyser);
                    }
                    if (fieldName.endsWith(".__.u")) {
                        return new MLAnalayser(this.dictionaryService, MLAnalysisMode.ALL_ONLY, (Analyzer)new VerbatimAnalyser(false));
                    }
                    if (fieldName.endsWith(".u")) {
                        return new MLAnalayser(this.dictionaryService, MLAnalysisMode.EXACT_LANGUAGE, (Analyzer)new VerbatimAnalyser(false));
                    }
                    if (!fieldName.endsWith(".sort")) continue;
                    return new VerbatimAnalyser(false);
                }
                catch (InvalidQNameException iqne) {
                }
            }
            QName propertyQName = QName.createQName((String)fieldName.substring(1));
            if (propertyQName.equals((Object)ContentModel.PROP_USER_USERNAME) || propertyQName.equals((Object)ContentModel.PROP_USERNAME) || propertyQName.equals((Object)ContentModel.PROP_AUTHORITY_NAME)) {
                return new VerbatimAnalyser(true);
            }
            PropertyDefinition propertyDef2 = this.dictionaryService.getProperty(propertyQName);
            IndexTokenisationMode tokenise = IndexTokenisationMode.TRUE;
            if (propertyDef2 != null) {
                dataType = propertyDef2.getDataType();
                tokenise = propertyDef2.getIndexTokenisationMode();
                if (tokenise == null) {
                    tokenise = IndexTokenisationMode.TRUE;
                }
                switch (tokenise) {
                    case TRUE: {
                        if (dataType.getName().equals((Object)DataTypeDefinition.CONTENT)) {
                            return new MLAnalayser(this.dictionaryService, MLAnalysisMode.EXACT_LANGUAGE);
                        }
                        if (dataType.getName().equals((Object)DataTypeDefinition.TEXT)) {
                            return new MLAnalayser(this.dictionaryService, MLAnalysisMode.EXACT_LANGUAGE);
                        }
                        if (dataType.getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                            return new MLAnalayser(this.dictionaryService, MLAnalysisMode.EXACT_LANGUAGE);
                        }
                        return this.loadAnalyzer(propertyDef2);
                    }
                    case BOTH: {
                        switch (analysisMode) {
                            case DEFAULT: 
                            case TOKENISE: {
                                if (dataType.getName().equals((Object)DataTypeDefinition.CONTENT)) {
                                    return new MLAnalayser(this.dictionaryService, MLAnalysisMode.EXACT_LANGUAGE);
                                }
                                if (dataType.getName().equals((Object)DataTypeDefinition.TEXT)) {
                                    return new MLAnalayser(this.dictionaryService, MLAnalysisMode.EXACT_LANGUAGE);
                                }
                                if (dataType.getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                                    return new MLAnalayser(this.dictionaryService, MLAnalysisMode.EXACT_LANGUAGE);
                                }
                                return this.loadAnalyzer(propertyDef2);
                            }
                            case IDENTIFIER: {
                                if (dataType.getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                                    return new MLAnalayser(this.dictionaryService, MLAnalysisMode.ALL_ONLY, (Analyzer)new VerbatimAnalyser(false));
                                }
                                return new VerbatimAnalyser(false);
                            }
                        }
                        throw new UnsupportedOperationException("TYPE must not be tokenised");
                    }
                    case FALSE: {
                        return new VerbatimAnalyser(false);
                    }
                }
                throw new UnsupportedOperationException("TYPE must not be tokenised");
            }
            switch (analysisMode) {
                case IDENTIFIER: {
                    return new VerbatimAnalyser(false);
                }
                case DEFAULT: 
                case TOKENISE: {
                    dataType = this.dictionaryService.getDataType(DataTypeDefinition.TEXT);
                    if (dataType == null) break;
                    return this.loadAnalyzer(dataType);
                }
            }
            throw new UnsupportedOperationException();
        }
        return this.defaultAnalyser;
    }

    private Analyzer loadAnalyzer(PropertyDefinition property) {
        String analyserClassName = property.resolveAnalyserClassName(I18NUtil.getLocale()).trim();
        try {
            Class<?> clazz = Class.forName(analyserClassName);
            Analyzer analyser = (Analyzer)clazz.newInstance();
            if (log.isDebugEnabled()) {
                log.debug("Loaded " + analyserClassName + " for type " + property.getName());
            }
            return analyser;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + property.getName() + " using " + analyserClassName);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + property.getName() + " using " + analyserClassName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + property.getName() + " using " + analyserClassName);
        }
    }

    private Analyzer loadAnalyzer(DataTypeDefinition dataTypeDef) {
        String analyserClassName = dataTypeDef.resolveAnalyserClassName(I18NUtil.getLocale()).trim();
        try {
            Class<?> clazz = Class.forName(analyserClassName);
            Analyzer analyser = (Analyzer)clazz.newInstance();
            if (log.isDebugEnabled()) {
                log.debug("Loaded " + analyserClassName + " for type " + dataTypeDef.getName());
            }
            return analyser;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataTypeDef.getName() + " using " + analyserClassName);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataTypeDef.getName() + " using " + analyserClassName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataTypeDef.getName() + " using " + analyserClassName);
        }
    }

    public int getPositionIncrementGap(String fieldName) {
        QName propertyQName;
        PropertyDefinition propertyDef;
        if (fieldName.startsWith("@") && !fieldName.endsWith(".mimetype") && (propertyDef = this.dictionaryService.getProperty(propertyQName = fieldName.endsWith(".__") ? QName.createQName((String)fieldName.substring(1, fieldName.length() - 3)) : QName.createQName((String)fieldName.substring(1)))) != null && propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
            return 1000;
        }
        return super.getPositionIncrementGap(fieldName);
    }
}

