/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.Pair;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class AbstractQParser
extends QParser {
    private static char[] SEPARATORS = new char[]{':', ',', '-', '!', '+', '=', ';', '~', '/'};
    protected static final Logger log = LoggerFactory.getLogger(AbstractQParser.class);
    private static final String ALFRESCO_JSON = "ALFRESCO_JSON";
    private static final String AUTHORITY_FILTER_FROM_JSON = "AUTHORITY_FILTER_FROM_JSON";
    private static final String TENANT_FILTER_FROM_JSON = "TENANT_FILTER_FROM_JSON";

    public AbstractQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    protected Pair<SearchParameters, Boolean> getSearchParameters() {
        String defaultField;
        SearchParameters searchParameters = new SearchParameters();
        Boolean isFilter = Boolean.FALSE;
        Iterable streams = this.req.getContentStreams();
        JSONObject json = (JSONObject)this.req.getContext().get(ALFRESCO_JSON);
        if (json == null && streams != null) {
            try {
                BufferedReader reader = null;
                for (ContentStream stream : streams) {
                    reader = new BufferedReader(new InputStreamReader(stream.getStream(), "UTF-8"));
                }
                if (reader != null) {
                    json = new JSONObject(new JSONTokener(reader));
                    this.req.getContext().put(ALFRESCO_JSON, json);
                }
            }
            catch (JSONException e) {
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("IO Error parsing query parameters", (Throwable)e);
            }
        }
        if (json != null) {
            try {
                int i;
                if (this.getString() != null) {
                    String tenantString;
                    JSONArray tenants;
                    ArrayList<String> tenantList;
                    if (this.getString().equals(AUTHORITY_FILTER_FROM_JSON)) {
                        isFilter = Boolean.TRUE;
                        tenantList = new ArrayList<String>(1);
                        tenants = json.getJSONArray("tenants");
                        for (int i2 = 0; i2 < tenants.length(); ++i2) {
                            tenantString = tenants.getString(i2);
                            tenantList.add(tenantString);
                        }
                        ArrayList<String> authorityList = new ArrayList<String>(1);
                        JSONArray authorities = json.getJSONArray("authorities");
                        for (i = 0; i < authorities.length(); ++i) {
                            String authorityString = authorities.getString(i);
                            authorityList.add(authorityString);
                        }
                        char separator = this.getSeparator(authorityList);
                        StringBuilder authQuery = new StringBuilder();
                        for (String tenant : tenantList) {
                            block17: for (String authority : authorityList) {
                                if (separator == '\u0000') {
                                    if (authQuery.length() > 0) {
                                        authQuery.append(" ");
                                    }
                                    switch (AuthorityType.getAuthorityType((String)authority)) {
                                        case USER: {
                                            authQuery.append("|AUTHORITY:\"").append(authority).append("\"");
                                            continue block17;
                                        }
                                        case GROUP: 
                                        case EVERYONE: 
                                        case GUEST: {
                                            if (tenant.length() == 0) {
                                                authQuery.append("|AUTHORITY:\"").append(authority).append("\"");
                                                continue block17;
                                            }
                                            authQuery.append("|AUTHORITY:\"").append(authority).append("@").append(tenant).append("\"");
                                            continue block17;
                                        }
                                    }
                                    authQuery.append("|AUTHORITY:\"").append(authority).append("\"");
                                    continue;
                                }
                                if (authQuery.length() == 0) {
                                    authQuery.append("|AUTHSET:\"");
                                }
                                switch (AuthorityType.getAuthorityType((String)authority)) {
                                    case USER: {
                                        authQuery.append(separator).append(authority);
                                        continue block17;
                                    }
                                    case GROUP: 
                                    case EVERYONE: 
                                    case GUEST: {
                                        if (tenant.length() == 0) {
                                            authQuery.append(separator).append(authority);
                                            continue block17;
                                        }
                                        authQuery.append(separator).append(authority).append("@").append(tenant);
                                        continue block17;
                                    }
                                }
                                authQuery.append(separator).append(authority);
                            }
                        }
                        if (separator != '\u0000') {
                            authQuery.append("\"");
                        }
                        if (authQuery.length() > 0) {
                            searchParameters.setQuery(authQuery.toString());
                        }
                    } else if (this.getString().equals(TENANT_FILTER_FROM_JSON)) {
                        isFilter = Boolean.TRUE;
                        tenantList = new ArrayList(1);
                        tenants = json.getJSONArray("tenants");
                        for (int i3 = 0; i3 < tenants.length(); ++i3) {
                            tenantString = tenants.getString(i3);
                            tenantList.add(tenantString);
                        }
                        StringBuilder tenantQuery = new StringBuilder();
                        for (String tenant : tenantList) {
                            if (tenantQuery.length() > 0) {
                                tenantQuery.append(" ");
                            }
                            if (tenant.length() > 0) {
                                tenantQuery.append("|TENANT:\"").append(tenant).append("\"");
                                continue;
                            }
                            tenantQuery.append("|TENANT:\"").append("_DEFAULT_").append("\"");
                        }
                        searchParameters.setQuery(tenantQuery.toString());
                    }
                } else {
                    String query = json.getString("query");
                    if (query != null) {
                        searchParameters.setQuery(query);
                    }
                }
                JSONArray locales = json.getJSONArray("locales");
                for (int i4 = 0; i4 < locales.length(); ++i4) {
                    String localeString = locales.getString(i4);
                    Locale locale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)localeString);
                    searchParameters.addLocale(locale);
                }
                JSONArray templates = json.getJSONArray("templates");
                for (int i5 = 0; i5 < templates.length(); ++i5) {
                    JSONObject template = templates.getJSONObject(i5);
                    String name = template.getString("name");
                    String queryTemplate = template.getString("template");
                    searchParameters.addQueryTemplate(name, queryTemplate);
                }
                JSONArray allAttributes = json.getJSONArray("allAttributes");
                for (int i6 = 0; i6 < allAttributes.length(); ++i6) {
                    String allAttribute = allAttributes.getString(i6);
                    searchParameters.addAllAttribute(allAttribute);
                }
                searchParameters.setDefaultFTSOperator(SearchParameters.Operator.valueOf((String)json.getString("defaultFTSOperator")));
                searchParameters.setDefaultFTSFieldConnective(SearchParameters.Operator.valueOf((String)json.getString("defaultFTSFieldOperator")));
                if (json.has("mlAnalaysisMode")) {
                    searchParameters.setMlAnalaysisMode(MLAnalysisMode.valueOf((String)json.getString("mlAnalaysisMode")));
                }
                searchParameters.setNamespace(json.getString("defaultNamespace"));
                JSONArray textAttributes = json.getJSONArray("textAttributes");
                for (i = 0; i < textAttributes.length(); ++i) {
                    String textAttribute = textAttributes.getString(i);
                    searchParameters.addAllAttribute(textAttribute);
                }
                searchParameters.setQueryConsistency(QueryConsistency.valueOf((String)json.getString("queryConsistency")));
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        if (json != null && log.isDebugEnabled()) {
            log.debug(json.toString());
        }
        if (searchParameters.getQuery() == null) {
            searchParameters.setQuery(this.getString());
        }
        if (searchParameters.getLocales().size() == 0) {
            searchParameters.addLocale(I18NUtil.getLocale());
        }
        if ((defaultField = this.getParam("df")) != null) {
            searchParameters.setDefaultFieldName(defaultField);
        }
        searchParameters.setNamespace("http://www.alfresco.org/model/content/1.0");
        return new Pair((Object)searchParameters, (Object)isFilter);
    }

    private char getSeparator(ArrayList<String> authorityList) {
        StringBuilder builder = new StringBuilder();
        for (String auth : authorityList) {
            builder.append(auth);
        }
        String test = builder.toString();
        for (int i = 0; i < SEPARATORS.length; ++i) {
            if (test.indexOf(SEPARATORS[i]) != -1) continue;
            return SEPARATORS[i];
        }
        return '\u0000';
    }
}

