/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.query.AbstractQParser;
import org.alfresco.util.Pair;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoFTSQParserPlugin
extends QParserPlugin {
    protected static final Logger log = LoggerFactory.getLogger(AlfrescoFTSQParserPlugin.class);

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new AlfrescoFTSQParser(qstr, localParams, params, req);
    }

    public void init(NamedList arg0) {
    }

    public static class AlfrescoFTSQParser
    extends AbstractQParser {
        public AlfrescoFTSQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        public Query parse() throws ParseException {
            Pair<SearchParameters, Boolean> searchParametersAndFilter = this.getSearchParameters();
            String id = this.req.getSchema().getResourceLoader().getInstanceDir();
            IndexReader indexReader = this.req.getSearcher().getIndexReader();
            Query query = AlfrescoSolrDataModel.getInstance(id).getFTSQuery(searchParametersAndFilter, indexReader);
            if (log.isDebugEnabled()) {
                log.debug("AFTS QP query as lucene:\t    " + query);
            }
            return query;
        }
    }
}

