/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.alfresco.solr.query.SolrAuthoritySetQuery;
import org.alfresco.solr.query.SolrOwnerSetQuery;
import org.alfresco.solr.query.SolrReaderSetQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrAuthoritySetScorer
extends AbstractSolrCachingScorer {
    SolrAuthoritySetScorer(Similarity similarity, DocSet in, SolrIndexReader solrIndexReader) {
        super(similarity, in, solrIndexReader);
    }

    public static SolrAuthoritySetScorer createAuthoritySetScorer(SolrIndexSearcher searcher, Similarity similarity, String authorities, SolrIndexReader reader) throws IOException {
        Properties p = searcher.getSchema().getResourceLoader().getCoreProperties();
        boolean doPermissionChecks = Boolean.parseBoolean(p.getProperty("alfresco.doPermissionChecks", "true"));
        SolrAuthoritySetQuery key = new SolrAuthoritySetQuery(authorities);
        DocSet answer = (DocSet)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_AUTHORITY_CACHE, (Object)key);
        if (answer != null) {
            return new SolrAuthoritySetScorer(similarity, answer, reader);
        }
        HashSet globalReaders = (HashSet)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_GLOBAL_READERS);
        String[] auths = authorities.substring(1).split(authorities.substring(0, 1));
        boolean hasGlobalRead = false;
        for (String auth : auths) {
            if (!globalReaders.contains(auth)) continue;
            hasGlobalRead = true;
            break;
        }
        if (hasGlobalRead || !doPermissionChecks) {
            OpenBitSet allLeafDocs = (OpenBitSet)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_ALL_LEAF_DOCS);
            return new SolrAuthoritySetScorer(similarity, (DocSet)new BitDocSet(allLeafDocs), reader);
        }
        DocSet readableDocSet = searcher.getDocSet((Query)new SolrReaderSetQuery(authorities));
        if (globalReaders.contains("ROLE_OWNER")) {
            DocSet authorityOwnedDocs = searcher.getDocSet((Query)new SolrOwnerSetQuery(authorities));
            DocSet toCache = readableDocSet.union(authorityOwnedDocs);
            searcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_AUTHORITY_CACHE, (Object)key, (Object)toCache);
            return new SolrAuthoritySetScorer(similarity, toCache, reader);
        }
        DocSet ownerReadableDocSet = searcher.getDocSet((Query)new SolrReaderSetQuery("|ROLE_OWNER"));
        DocSet authorityOwnedDocs = searcher.getDocSet((Query)new SolrOwnerSetQuery(authorities));
        DocSet docsAuthorityOwnsAndCanRead = ownerReadableDocSet.intersection(authorityOwnedDocs);
        DocSet toCache = readableDocSet.union(docsAuthorityOwnsAndCanRead);
        searcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_AUTHORITY_CACHE, (Object)key, (Object)toCache);
        return new SolrAuthoritySetScorer(similarity, toCache, reader);
    }
}

