/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashSet;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.alfresco.solr.query.SolrCachingAuthorityQuery;
import org.alfresco.solr.query.SolrCachingOwnerQuery;
import org.alfresco.solr.query.SolrCachingReaderQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrCachingAuthorityScorer
extends AbstractSolrCachingScorer {
    SolrCachingAuthorityScorer(Similarity similarity, DocSet in, SolrIndexReader solrIndexReader) {
        super(similarity, in, solrIndexReader);
    }

    public static SolrCachingAuthorityScorer createAuthorityScorer(SolrIndexSearcher searcher, Similarity similarity, String authority, SolrIndexReader reader) throws IOException {
        SolrCachingAuthorityQuery key = new SolrCachingAuthorityQuery(authority);
        DocSet answer = (DocSet)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_AUTHORITY_CACHE, (Object)key);
        if (answer != null) {
            return new SolrCachingAuthorityScorer(similarity, answer, reader);
        }
        HashSet globalReaders = (HashSet)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_GLOBAL_READERS);
        if (globalReaders.contains(authority)) {
            OpenBitSet allLeafDocs = (OpenBitSet)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_ALL_LEAF_DOCS);
            BitDocSet toCache = new BitDocSet(allLeafDocs);
            searcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_AUTHORITY_CACHE, (Object)key, (Object)toCache);
            return new SolrCachingAuthorityScorer(similarity, (DocSet)toCache, reader);
        }
        DocSet readableDocSet = searcher.getDocSet((Query)new SolrCachingReaderQuery(authority));
        if (globalReaders.contains("ROLE_OWNER")) {
            DocSet authorityOwnedDocs = searcher.getDocSet((Query)new SolrCachingOwnerQuery(authority));
            DocSet toCache = readableDocSet.union(authorityOwnedDocs);
            searcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_AUTHORITY_CACHE, (Object)key, (Object)toCache);
            return new SolrCachingAuthorityScorer(similarity, toCache, reader);
        }
        DocSet ownerReadableDocSet = searcher.getDocSet((Query)new SolrCachingReaderQuery("ROLE_OWNER"));
        DocSet authorityOwnedDocs = searcher.getDocSet((Query)new SolrCachingOwnerQuery(authority));
        DocSet docsAuthorityOwnsAndCanRead = ownerReadableDocSet.intersection(authorityOwnedDocs);
        DocSet toCache = readableDocSet.union(docsAuthorityOwnsAndCanRead);
        searcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_AUTHORITY_CACHE, (Object)key, (Object)toCache);
        return new SolrCachingAuthorityScorer(similarity, toCache, reader);
    }
}

