/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashMap;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.alfresco.solr.ResizeableArrayList;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrOwnerSetScorer
extends AbstractSolrCachingScorer {
    SolrOwnerSetScorer(Similarity similarity, DocSet in, SolrIndexReader solrIndexReader) {
        super(similarity, in, solrIndexReader);
    }

    public static SolrOwnerSetScorer createOwnerSetScorer(SolrIndexSearcher searcher, Similarity similarity, String authorities, SolrIndexReader reader) throws IOException {
        String[] auths;
        BitDocSet authorityOwnedDocs = new BitDocSet(new OpenBitSet((long)searcher.getReader().maxDoc()));
        HashMap ownerLookUp = (HashMap)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_OWNER_LOOKUP);
        for (String current : auths = authorities.substring(1).split(authorities.substring(0, 1))) {
            AlfrescoSolrEventListener.OwnerLookUp lookUp = (AlfrescoSolrEventListener.OwnerLookUp)ownerLookUp.get(current);
            if (lookUp == null) continue;
            ResizeableArrayList indexedOderedByOwnerIdThenDoc = (ResizeableArrayList)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_ARRAYLIST_CACHE, (Object)AlfrescoSolrEventListener.KEY_DBID_LEAF_PATH_BY_OWNER_ID_THEN_LEAF);
            for (int i = lookUp.getStart(); i < lookUp.getEnd(); ++i) {
                authorityOwnedDocs.addUnique(((AlfrescoSolrEventListener.CacheEntry)indexedOderedByOwnerIdThenDoc.get(i)).getLeaf());
            }
        }
        return new SolrOwnerSetScorer(similarity, (DocSet)authorityOwnedDocs, reader);
    }
}

