/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.search.impl.lucene.query.AbsoluteStructuredFieldPosition;
import org.alfresco.repo.search.impl.lucene.query.DescendantAndSelfStructuredFieldPosition;
import org.alfresco.repo.search.impl.lucene.query.RelativeStructuredFieldPosition;
import org.alfresco.repo.search.impl.lucene.query.SelfAxisStructuredFieldPosition;
import org.alfresco.repo.search.impl.lucene.query.StructuredFieldPosition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.solr.query.SolrPathScorer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexReader;

public class SolrPathQuery
extends Query {
    private static final long serialVersionUID = 3832904355660707892L;
    private String pathField = "PATH";
    private int unitSize = 2;
    private List<StructuredFieldPosition> pathStructuredFieldPositions = new ArrayList<StructuredFieldPosition>();
    private DictionaryService dictionarySertvice;
    private boolean repeats = false;

    public SolrPathQuery(DictionaryService dictionarySertvice) {
        this.dictionarySertvice = dictionarySertvice;
    }

    public void setQuery(List<StructuredFieldPosition> path) {
        this.pathStructuredFieldPositions.clear();
        if (path.size() % this.unitSize != 0) {
            throw new UnsupportedOperationException();
        }
        this.pathStructuredFieldPositions.addAll(path);
    }

    public void appendQuery(List<StructuredFieldPosition> sfps) {
        if (sfps.size() != this.unitSize) {
            throw new UnsupportedOperationException();
        }
        StructuredFieldPosition last = null;
        StructuredFieldPosition next = sfps.get(0);
        if (this.pathStructuredFieldPositions.size() > 0) {
            last = this.pathStructuredFieldPositions.get(this.pathStructuredFieldPositions.size() - 1);
        }
        if (last != null && next.linkParent() && !last.allowslinkingByParent()) {
            return;
        }
        if (last != null && next.linkSelf() && !last.allowsLinkingBySelf()) {
            return;
        }
        this.pathStructuredFieldPositions.addAll(sfps);
    }

    public String getPathField() {
        return this.pathField;
    }

    public void setPathField(String pathField) {
        this.pathField = pathField;
    }

    public Term getPathRootTerm() {
        return new Term(this.getPathField(), ";");
    }

    ArrayList<Term> getTerms() {
        ArrayList<Term> answer = new ArrayList<Term>(this.pathStructuredFieldPositions.size());
        for (StructuredFieldPosition sfp : this.pathStructuredFieldPositions) {
            if (sfp.getTermText() == null) continue;
            Term term = new Term(this.pathField, sfp.getTermText());
            answer.add(term);
        }
        return answer;
    }

    public Weight createWeight(Searcher searcher) {
        return new StructuredFieldWeight(searcher);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PATH:");
        for (int i = 0; i < this.pathStructuredFieldPositions.size(); i += 2) {
            if (this.pathStructuredFieldPositions.get(i) instanceof AbsoluteStructuredFieldPosition) {
                stringBuilder.append("/");
                if (this.pathStructuredFieldPositions.get(i).getTermText() == null && this.pathStructuredFieldPositions.get(i + 1).getTermText() == null) {
                    stringBuilder.append("*");
                    continue;
                }
                stringBuilder.append("{");
                stringBuilder.append(this.pathStructuredFieldPositions.get(i).getTermText() == null ? "*" : this.pathStructuredFieldPositions.get(i).getTermText());
                stringBuilder.append("}:");
                stringBuilder.append(this.pathStructuredFieldPositions.get(i + 1).getTermText() == null ? "*" : this.pathStructuredFieldPositions.get(i + 1).getTermText());
                continue;
            }
            if (this.pathStructuredFieldPositions.get(i) instanceof DescendantAndSelfStructuredFieldPosition) {
                stringBuilder.append("//");
                continue;
            }
            if (this.pathStructuredFieldPositions.get(i) instanceof RelativeStructuredFieldPosition) {
                stringBuilder.append("/");
                if (this.pathStructuredFieldPositions.get(i).getTermText() == null && this.pathStructuredFieldPositions.get(i + 1).getTermText() == null) {
                    stringBuilder.append("*");
                    continue;
                }
                stringBuilder.append(this.pathStructuredFieldPositions.get(i).getTermText() == null ? "*" : this.pathStructuredFieldPositions.get(i).getTermText());
                stringBuilder.append(":");
                stringBuilder.append(this.pathStructuredFieldPositions.get(i + 1).getTermText() == null ? "*" : this.pathStructuredFieldPositions.get(i + 1).getTermText());
                continue;
            }
            if (!(this.pathStructuredFieldPositions.get(i) instanceof SelfAxisStructuredFieldPosition)) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public String toString(String field) {
        return this.toString();
    }

    public void removeDescendantAndSelf() {
        while (this.getLast() != null && this.getLast().linkSelf()) {
            this.removeLast();
            this.removeLast();
        }
    }

    private StructuredFieldPosition getLast() {
        if (this.pathStructuredFieldPositions.size() > 0) {
            return this.pathStructuredFieldPositions.get(this.pathStructuredFieldPositions.size() - 1);
        }
        return null;
    }

    private void removeLast() {
        this.pathStructuredFieldPositions.remove(this.pathStructuredFieldPositions.size() - 1);
    }

    public boolean isEmpty() {
        return this.pathStructuredFieldPositions.size() == 0;
    }

    public List<StructuredFieldPosition> getPathStructuredFieldPositions() {
        return this.pathStructuredFieldPositions;
    }

    public void setRepeats(boolean repeats) {
        this.repeats = repeats;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.pathField == null ? 0 : this.pathField.hashCode());
        result = 31 * result + (this.pathStructuredFieldPositions == null ? 0 : this.pathStructuredFieldPositions.hashCode());
        result = 31 * result + (this.repeats ? 1231 : 1237);
        result = 31 * result + this.unitSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SolrPathQuery other = (SolrPathQuery)((Object)obj);
        if (this.pathField == null ? other.pathField != null : !this.pathField.equals(other.pathField)) {
            return false;
        }
        if (this.pathStructuredFieldPositions == null ? other.pathStructuredFieldPositions != null : !this.pathStructuredFieldPositions.equals(other.pathStructuredFieldPositions)) {
            return false;
        }
        if (this.repeats != other.repeats) {
            return false;
        }
        return this.unitSize == other.unitSize;
    }

    private class StructuredFieldWeight
    extends Weight {
        private static final long serialVersionUID = 3257854259645985328L;
        private Searcher searcher;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;

        public StructuredFieldWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Query getQuery() {
            return SolrPathQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.idf = SolrPathQuery.this.getSimilarity(this.searcher).idf(SolrPathQuery.this.getTerms(), this.searcher);
            this.queryWeight = this.idf * SolrPathQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public Scorer scorer(IndexReader reader, boolean arg1, boolean arg2) throws IOException {
            if (!(reader instanceof SolrIndexReader)) {
                throw new IllegalStateException("Must have a SolrIndexReader");
            }
            return SolrPathScorer.createPathScorer(SolrPathQuery.this.getSimilarity(this.searcher), SolrPathQuery.this, (SolrIndexReader)reader, this, SolrPathQuery.this.dictionarySertvice, SolrPathQuery.this.repeats);
        }
    }
}

