/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.alfresco.solr.AlfrescoSolrEventListener;
import org.alfresco.solr.ResizeableArrayList;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrReaderSetScorer
extends AbstractSolrCachingScorer {
    SolrReaderSetScorer(Similarity similarity, DocSet in, SolrIndexReader solrIndexReader) {
        super(similarity, in, solrIndexReader);
    }

    public static SolrReaderSetScorer createReaderSetScorer(SolrIndexSearcher searcher, Similarity similarity, String authorities, SolrIndexReader reader) throws IOException {
        String[] auths = authorities.substring(1).split(authorities.substring(0, 1));
        long[] aclIdByDocId = (long[])searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_ACL_ID_BY_DOC_ID);
        HashMap lookups = (HashMap)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_ACL_LOOKUP);
        ResizeableArrayList aclThenLeafOrderedEntries = (ResizeableArrayList)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_ARRAYLIST_CACHE, (Object)AlfrescoSolrEventListener.KEY_DBID_LEAF_PATH_BY_ACL_ID_THEN_LEAF);
        BitDocSet publicDocSet = (BitDocSet)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_CACHE, (Object)AlfrescoSolrEventListener.KEY_PUBLIC_DOC_SET);
        BitDocSet readableDocSet = new BitDocSet(new OpenBitSet((long)searcher.getReader().maxDoc()));
        HashSet<Long> ignoredAlcs = null;
        for (String auth : auths) {
            if (!auth.equals("GROUP_EVERYONE")) continue;
            HashSet<Long> aclIds = (HashSet<Long>)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_READER_TO_ACL_IDS_CACHE, (Object)auth);
            if (aclIds == null) {
                aclIds = SolrReaderSetScorer.buildReaderAclIds(searcher, auth, aclIdByDocId);
                searcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_READER_TO_ACL_IDS_CACHE, (Object)auth, aclIds);
            }
            ignoredAlcs = aclIds;
            break;
        }
        HashSet<Long> acls = new HashSet<Long>();
        for (String auth : auths) {
            if (auth.equals("GROUP_EVERYONE")) {
                readableDocSet = readableDocSet.union((DocSet)publicDocSet);
                continue;
            }
            HashSet<Long> aclIds = (HashSet<Long>)searcher.cacheLookup(AlfrescoSolrEventListener.ALFRESCO_READER_TO_ACL_IDS_CACHE, (Object)auth);
            if (aclIds == null) {
                aclIds = SolrReaderSetScorer.buildReaderAclIds(searcher, auth, aclIdByDocId);
                searcher.cacheInsert(AlfrescoSolrEventListener.ALFRESCO_READER_TO_ACL_IDS_CACHE, (Object)auth, aclIds);
            }
            acls.addAll(aclIds);
        }
        if (ignoredAlcs != null) {
            acls.removeAll(ignoredAlcs);
        }
        AlfrescoSolrEventListener.AclLookUp key = new AlfrescoSolrEventListener.AclLookUp(0L);
        for (Long acl : acls) {
            key.setAclid(acl);
            AlfrescoSolrEventListener.AclLookUp value = (AlfrescoSolrEventListener.AclLookUp)lookups.get(key);
            if (value == null) continue;
            for (int i = value.getStart(); i < value.getEnd(); ++i) {
                readableDocSet.add(((AlfrescoSolrEventListener.CacheEntry)aclThenLeafOrderedEntries.get(i)).getLeaf());
            }
        }
        return new SolrReaderSetScorer(similarity, (DocSet)readableDocSet, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<Long> buildReaderAclIds(SolrIndexSearcher searcher, String authority, long[] aclIdByDocId) throws IOException {
        HashSet<Long> aclsAsSet = new HashSet<Long>();
        SolrIndexReader reader = searcher.getReader();
        try (TermEnum termEnum = reader.terms(new Term("READER", authority));){
            Term term = termEnum.term();
            if (term == null) {
                HashSet<Long> hashSet = aclsAsSet;
                return hashSet;
            }
            if (term.field().equals("READER") && term.text().equals(authority)) {
                try (TermDocs termDocs = reader.termDocs(term);){
                    while (termDocs.next()) {
                        int currentDoc = termDocs.doc();
                        long acl = aclIdByDocId[currentDoc];
                        aclsAsSet.add(acl);
                    }
                }
                HashSet<Long> hashSet = aclsAsSet;
                return hashSet;
            }
            HashSet<Long> hashSet = aclsAsSet;
            return hashSet;
        }
    }
}

