/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.io.IOException;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.repo.search.impl.lucene.analysis.NumericEncoder;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclChangeSets;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.GetNodesParameters;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.client.Transactions;
import org.alfresco.solr.tracker.CoreTracker;
import org.alfresco.util.DynamicallySizedThreadPoolExecutor;
import org.alfresco.util.TraceableThreadFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.util.RefCounted;
import org.json.JSONException;

public class MultiThreadedCoreTracker
extends CoreTracker {
    private static final int DEFAULT_CORE_POOL_SIZE = 4;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = -1;
    private static final int DEFAULT_KEEP_ALIVE_TIME = 120;
    private static final int DEFAULT_THREAD_PRIORITY = 5;
    private static final boolean DEFAULT_THREAD_DAEMON = Boolean.TRUE;
    private static final int DEFAULT_WORK_QUEUE_SIZE = -1;
    private static final RejectedExecutionHandler DEFAULT_REJECTED_EXECUTION_HANDLER = new ThreadPoolExecutor.CallerRunsPolicy();
    private static final int DEFAULT_TRANSACTION_DOCS_BATCH_SIZE = 100;
    private static final int DEFAULT_CHANGE_SET_ACLS_BATCH_SIZE = 100;
    private static final int DEFAULT_ACL_BATCH_SIZE = 10;
    private String poolName = "";
    private boolean enableMultiThreadedTracking = false;
    private int corePoolSize = 4;
    private int maximumPoolSize = -1;
    private int keepAliveTime = 120;
    private int threadPriority = 5;
    private boolean threadDaemon = DEFAULT_THREAD_DAEMON;
    private int workQueueSize = -1;
    private int transactionDocsBatchSize = 100;
    private int changeSetAclsBatchSize = 100;
    private int aclBatchSize = 10;
    private RejectedExecutionHandler rejectedExecutionHandler = DEFAULT_REJECTED_EXECUTION_HANDLER;
    private DynamicallySizedThreadPoolExecutor threadPool;
    private LinkedBlockingQueue<AbstractWorkerRunnable> reindexThreadQueue = new LinkedBlockingQueue();
    private ReentrantReadWriteLock reindexThreadLock = new ReentrantReadWriteLock(true);

    MultiThreadedCoreTracker(AlfrescoCoreAdminHandler adminHandler, SolrCore core) {
        super(adminHandler, core);
        Properties p = core.getResourceLoader().getCoreProperties();
        this.enableMultiThreadedTracking = Boolean.parseBoolean(p.getProperty("alfresco.enableMultiThreadedTracking", "true"));
        this.corePoolSize = Integer.parseInt(p.getProperty("alfresco.corePoolSize", "3"));
        this.maximumPoolSize = Integer.parseInt(p.getProperty("alfresco.maximumPoolSize", "-1"));
        this.keepAliveTime = Integer.parseInt(p.getProperty("alfresco.keepAliveTime", "120"));
        this.threadPriority = Integer.parseInt(p.getProperty("alfresco.threadPriority", "5"));
        this.threadDaemon = Boolean.parseBoolean(p.getProperty("alfresco.threadDaemon", "true"));
        this.workQueueSize = Integer.parseInt(p.getProperty("alfresco.workQueueSize", "-1"));
        this.transactionDocsBatchSize = Integer.parseInt(p.getProperty("alfresco.transactionDocsBatchSize", "100"));
        this.changeSetAclsBatchSize = Integer.parseInt(p.getProperty("alfresco.changeSetAclsBatchSize", "100"));
        this.aclBatchSize = Integer.parseInt(p.getProperty("alfresco.aclBatchSize", "10"));
        if (this.enableMultiThreadedTracking) {
            this.poolName = "SolrTrackingPool-" + core.getName();
            if (this.maximumPoolSize == -1) {
                this.maximumPoolSize = this.corePoolSize;
            }
            TraceableThreadFactory threadFactory = new TraceableThreadFactory();
            threadFactory.setThreadDaemon(this.threadDaemon);
            threadFactory.setThreadPriority(this.threadPriority);
            if (this.poolName.length() > 0) {
                threadFactory.setNamePrefix(this.poolName);
            }
            AbstractQueue workQueue = this.workQueueSize < 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(this.workQueueSize);
            this.threadPool = new DynamicallySizedThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.SECONDS, workQueue, (ThreadFactory)threadFactory, this.rejectedExecutionHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void trackTransactions() throws AuthenticationException, IOException, JSONException {
        Transactions transactions;
        if (!this.enableMultiThreadedTracking) {
            super.trackTransactions();
            return;
        }
        boolean indexed = false;
        boolean upToDate = false;
        ArrayList transactionsOrderedById = new ArrayList(10000);
        CoreTracker.BoundedDeque<Transaction> txnsFound = new CoreTracker.BoundedDeque<Transaction>(100);
        HashSet<Transaction> transactionsIndexed = new HashSet<Transaction>();
        do {
            Long maxTxnId;
            int docCount = 0;
            Long fromCommitTime = this.getTxFromCommitTime(txnsFound, this.state.lastGoodTxCommitTimeInIndex);
            transactions = this.getSomeTransactions(txnsFound, fromCommitTime, 3600000L, 2000, this.state.timeToStopIndexing);
            Long maxTxnCommitTime = transactions.getMaxTxnCommitTime();
            if (maxTxnCommitTime != null) {
                this.state.lastTxCommitTimeOnServer = transactions.getMaxTxnCommitTime();
            }
            if ((maxTxnId = transactions.getMaxTxnId()) != null) {
                this.state.lastTxIdOnServer = transactions.getMaxTxnId();
            }
            log.info("Scanning transactions ...");
            if (transactions.getTransactions().size() > 0) {
                log.info(".... from " + transactions.getTransactions().get(0));
                log.info(".... to " + transactions.getTransactions().get(transactions.getTransactions().size() - 1));
            } else {
                log.info(".... non found after lastTxCommitTime " + (txnsFound.size() > 0 ? txnsFound.getLast().getCommitTimeMs() : this.state.lastIndexedTxCommitTime));
            }
            ArrayList<Transaction> txBatch = new ArrayList<Transaction>();
            for (Transaction info : transactions.getTransactions()) {
                boolean index = false;
                String target = NumericEncoder.encode((long)info.getId());
                RefCounted refCounted = null;
                Term term = null;
                try {
                    refCounted = this.core.getSearcher(false, true, null);
                    TermEnum termEnum = ((SolrIndexSearcher)refCounted.get()).getReader().terms(new Term("TXID", target));
                    term = termEnum.term();
                    termEnum.close();
                }
                finally {
                    if (refCounted != null) {
                        refCounted.decref();
                    }
                    refCounted = null;
                }
                if (term == null) {
                    index = true;
                } else if (target.equals(term.text())) {
                    txnsFound.add(info);
                } else {
                    index = true;
                }
                if (index) {
                    if (info.getCommitTimeMs() > this.state.timeToStopIndexing) {
                        upToDate = true;
                        break;
                    }
                    txBatch.add(info);
                    if (this.getDocCout(txBatch) > this.transactionDocsBatchSize) {
                        indexed = true;
                        refCounted = null;
                        try {
                            refCounted = this.core.getSearcher(false, true, null);
                            docCount += this.indexBatchOfTransactions(txBatch, (SolrIndexSearcher)refCounted.get());
                        }
                        finally {
                            if (refCounted != null) {
                                refCounted.decref();
                            }
                            refCounted = null;
                        }
                        for (Transaction scheduled : txBatch) {
                            txnsFound.add(scheduled);
                            transactionsIndexed.add(scheduled);
                        }
                        txBatch.clear();
                    }
                }
                if ((long)docCount > this.batchCount && this.getRegisteredSearcherCount() < this.getMaxLiveSearchers()) {
                    this.waitAndIndexTransactions(transactionsIndexed);
                    docCount = 0;
                }
                this.checkShutdown();
            }
            if (txBatch.isEmpty()) continue;
            indexed = true;
            if (this.getDocCout(txBatch) > 0) {
                RefCounted refCounted = null;
                try {
                    refCounted = this.core.getSearcher(false, true, null);
                    docCount += this.indexBatchOfTransactions(txBatch, (SolrIndexSearcher)refCounted.get());
                }
                finally {
                    if (refCounted != null) {
                        refCounted.decref();
                    }
                    refCounted = null;
                }
            }
            for (Transaction scheduled : txBatch) {
                txnsFound.add(scheduled);
                transactionsIndexed.add(scheduled);
            }
            txBatch.clear();
        } while (transactions.getTransactions().size() > 0 && !upToDate);
        if (indexed) {
            this.waitAndIndexTransactions(transactionsIndexed);
        }
    }

    private int getDocCout(ArrayList<Transaction> txBatch) {
        int count = 0;
        for (Transaction tx : txBatch) {
            count = (int)((long)count + tx.getUpdates());
            count = (int)((long)count + tx.getDeletes());
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int indexBatchOfTransactions(ArrayList<Transaction> txBatch, SolrIndexSearcher solrIndexSearcher) throws AuthenticationException, IOException, JSONException {
        int docCount = 0;
        GetNodesParameters gnp = new GetNodesParameters();
        ArrayList<Long> txs = new ArrayList<Long>();
        for (Transaction info : txBatch) {
            if (info.getUpdates() <= 0L && info.getDeletes() <= 0L) continue;
            txs.add(info.getId());
        }
        gnp.setTransactionIds(txs);
        gnp.setStoreProtocol(this.storeRef.getProtocol());
        gnp.setStoreIdentifier(this.storeRef.getIdentifier());
        List<Node> nodes = this.client.getNodes(gnp, Integer.MAX_VALUE);
        for (Node node : nodes) {
            ++docCount;
            if (log.isDebugEnabled()) {
                log.debug(node.toString());
            }
            NodeIndexWorkerRunnable niwr = new NodeIndexWorkerRunnable(node, solrIndexSearcher);
            try {
                this.reindexThreadLock.writeLock().lock();
                this.reindexThreadQueue.add(niwr);
            }
            finally {
                this.reindexThreadLock.writeLock().unlock();
            }
            this.threadPool.execute((Runnable)niwr);
        }
        return docCount;
    }

    private void waitAndIndexTransactions(HashSet<Transaction> transactionsIndexed) throws IOException {
        this.waitForAsynchronousReindexing();
        for (Transaction tx : transactionsIndexed) {
            this.indexTransaction(tx, true);
            if (tx.getCommitTimeMs() > this.state.lastIndexedTxCommitTime) {
                this.state.lastIndexedTxCommitTime = tx.getCommitTimeMs();
                this.state.lastIndexedTxId = tx.getId();
            }
            this.trackerStats.addTxDocs((int)(tx.getUpdates() + tx.getDeletes()));
        }
        transactionsIndexed.clear();
        this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void trackAclChangeSets() throws AuthenticationException, IOException, JSONException {
        AclChangeSets aclChangeSets;
        if (!this.enableMultiThreadedTracking) {
            super.trackAclChangeSets();
            return;
        }
        boolean indexed = false;
        boolean upToDate = false;
        CoreTracker.BoundedDeque<AclChangeSet> changeSetsFound = new CoreTracker.BoundedDeque<AclChangeSet>(100);
        HashSet<AclChangeSet> changeSetsIndexed = new HashSet<AclChangeSet>();
        do {
            Long maxChangeSetId;
            int aclCount = 0;
            Long fromCommitTime = this.getChangeSetFromCommitTime(changeSetsFound, this.state.lastGoodChangeSetCommitTimeInIndex);
            aclChangeSets = this.getSomeAclChangeSets(changeSetsFound, fromCommitTime, 3600000L, 2000, this.state.timeToStopIndexing);
            Long maxChangeSetCommitTime = aclChangeSets.getMaxChangeSetCommitTime();
            if (maxChangeSetCommitTime != null) {
                this.state.lastChangeSetCommitTimeOnServer = aclChangeSets.getMaxChangeSetCommitTime();
            }
            if ((maxChangeSetId = aclChangeSets.getMaxChangeSetId()) != null) {
                this.state.lastChangeSetIdOnServer = aclChangeSets.getMaxChangeSetId();
            }
            log.info("Scanning Acl change sets ...");
            if (aclChangeSets.getAclChangeSets().size() > 0) {
                log.info(".... from " + aclChangeSets.getAclChangeSets().get(0));
                log.info(".... to " + aclChangeSets.getAclChangeSets().get(aclChangeSets.getAclChangeSets().size() - 1));
            } else {
                log.info(".... non found after lastTxCommitTime " + fromCommitTime);
            }
            ArrayList<AclChangeSet> changeSetBatch = new ArrayList<AclChangeSet>();
            for (AclChangeSet changeSet : aclChangeSets.getAclChangeSets()) {
                boolean index = false;
                String target = NumericEncoder.encode((long)changeSet.getId());
                RefCounted refCounted = null;
                Term term = null;
                try {
                    refCounted = this.core.getSearcher(false, true, null);
                    TermEnum termEnum = ((SolrIndexSearcher)refCounted.get()).getReader().terms(new Term("ACLTXID", target));
                    term = termEnum.term();
                    termEnum.close();
                }
                finally {
                    if (refCounted != null) {
                        refCounted.decref();
                    }
                    refCounted = null;
                }
                if (term == null) {
                    index = true;
                } else if (target.equals(term.text())) {
                    changeSetsFound.add(changeSet);
                } else {
                    index = true;
                }
                if (index) {
                    if (changeSet.getCommitTimeMs() > this.state.timeToStopIndexing) {
                        upToDate = true;
                        break;
                    }
                    changeSetBatch.add(changeSet);
                    if (this.getAclCount(changeSetBatch) > this.changeSetAclsBatchSize) {
                        indexed = true;
                        try {
                            refCounted = this.core.getSearcher(false, true, null);
                            aclCount += this.indexBatchOfChangeSets(changeSetBatch, (SolrIndexSearcher)refCounted.get());
                        }
                        finally {
                            if (refCounted != null) {
                                refCounted.decref();
                            }
                            refCounted = null;
                        }
                        for (AclChangeSet scheduled : changeSetBatch) {
                            changeSetsFound.add(scheduled);
                            changeSetsIndexed.add(scheduled);
                        }
                        changeSetBatch.clear();
                    }
                }
                if ((long)aclCount > this.batchCount && this.getRegisteredSearcherCount() < this.getMaxLiveSearchers()) {
                    this.waitForAsynchronousReindexing();
                    for (AclChangeSet set : changeSetsIndexed) {
                        this.indexAclTransaction(set, true);
                        if (set.getCommitTimeMs() > this.state.lastIndexedChangeSetCommitTime) {
                            this.state.lastIndexedChangeSetCommitTime = set.getCommitTimeMs();
                            this.state.lastIndexedChangeSetId = set.getId();
                        }
                        this.trackerStats.addChangeSetAcls(set.getAclCount());
                    }
                    changeSetsIndexed.clear();
                    this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
                    aclCount = 0;
                }
                this.checkShutdown();
            }
            if (changeSetBatch.isEmpty()) continue;
            indexed = true;
            if (this.getAclCount(changeSetBatch) > 0) {
                RefCounted refCounted = null;
                try {
                    refCounted = this.core.getSearcher(false, true, null);
                    aclCount += this.indexBatchOfChangeSets(changeSetBatch, (SolrIndexSearcher)refCounted.get());
                }
                finally {
                    if (refCounted != null) {
                        refCounted.decref();
                    }
                    refCounted = null;
                }
            }
            for (AclChangeSet scheduled : changeSetBatch) {
                changeSetsFound.add(scheduled);
                changeSetsIndexed.add(scheduled);
            }
            changeSetBatch.clear();
        } while (aclChangeSets.getAclChangeSets().size() > 0 && !upToDate);
        if (indexed) {
            this.waitForAsynchronousReindexing();
            for (AclChangeSet set : changeSetsIndexed) {
                this.indexAclTransaction(set, true);
                if (set.getCommitTimeMs() > this.state.lastIndexedChangeSetCommitTime) {
                    this.state.lastIndexedChangeSetCommitTime = set.getCommitTimeMs();
                    this.state.lastIndexedChangeSetId = set.getId();
                }
                this.trackerStats.addChangeSetAcls(set.getAclCount());
            }
            changeSetsIndexed.clear();
            this.core.getUpdateHandler().commit(new CommitUpdateCommand(false));
        }
    }

    private int getAclCount(ArrayList<AclChangeSet> changeSetBatch) {
        int count = 0;
        for (AclChangeSet set : changeSetBatch) {
            count += set.getAclCount();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int indexBatchOfChangeSets(ArrayList<AclChangeSet> changeSetBatch, SolrIndexSearcher solrIndexSearcher) throws AuthenticationException, IOException, JSONException {
        int aclCount = 0;
        ArrayList<AclChangeSet> nonEmptyChangeSets = new ArrayList<AclChangeSet>(changeSetBatch.size());
        for (AclChangeSet set : changeSetBatch) {
            if (set.getAclCount() <= 0) continue;
            nonEmptyChangeSets.add(set);
        }
        ArrayList<Acl> aclBatch = new ArrayList<Acl>();
        List<Acl> acls = this.client.getAcls(nonEmptyChangeSets, null, Integer.MAX_VALUE);
        for (Acl acl : acls) {
            if (log.isDebugEnabled()) {
                log.debug(acl.toString());
            }
            aclBatch.add(acl);
            if (aclBatch.size() <= this.aclBatchSize) continue;
            aclCount += aclBatch.size();
            AclIndexWorkerRunnable aiwr = new AclIndexWorkerRunnable(aclBatch);
            try {
                this.reindexThreadLock.writeLock().lock();
                this.reindexThreadQueue.add(aiwr);
            }
            finally {
                this.reindexThreadLock.writeLock().unlock();
            }
            this.threadPool.execute((Runnable)aiwr);
            aclBatch = new ArrayList();
        }
        if (aclBatch.size() > 0) {
            aclCount += aclBatch.size();
            AclIndexWorkerRunnable aiwr = new AclIndexWorkerRunnable(aclBatch);
            try {
                this.reindexThreadLock.writeLock().lock();
                this.reindexThreadQueue.add(aiwr);
            }
            finally {
                this.reindexThreadLock.writeLock().unlock();
            }
            this.threadPool.execute((Runnable)aiwr);
            aclBatch = new ArrayList();
        }
        return aclCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void waitForAsynchronousReindexing() {
        AbstractWorkerRunnable currentRunnable = this.peekHeadReindexWorker();
        while (currentRunnable != null) {
            this.checkShutdown();
            MultiThreadedCoreTracker multiThreadedCoreTracker = this;
            synchronized (multiThreadedCoreTracker) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            currentRunnable = this.peekHeadReindexWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractWorkerRunnable peekHeadReindexWorker() {
        try {
            this.reindexThreadLock.readLock().lock();
            AbstractWorkerRunnable abstractWorkerRunnable = this.reindexThreadQueue.peek();
            return abstractWorkerRunnable;
        }
        finally {
            this.reindexThreadLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(SolrCore core) {
        try {
            super.close(core);
        }
        finally {
            if (this.threadPool != null) {
                this.threadPool.shutdownNow();
            }
        }
        MultiThreadedCoreTracker multiThreadedCoreTracker = this;
        synchronized (multiThreadedCoreTracker) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class AclIndexWorkerRunnable
    extends AbstractWorkerRunnable {
        List<Acl> acls;

        AclIndexWorkerRunnable(List<Acl> acls) {
            this.acls = acls;
        }

        @Override
        protected void doWork() throws IOException, AuthenticationException, JSONException {
            List<AclReaders> readers = MultiThreadedCoreTracker.this.client.getAclReaders(this.acls);
            MultiThreadedCoreTracker.this.indexAcl(readers, true);
        }
    }

    class NodeIndexWorkerRunnable
    extends AbstractWorkerRunnable {
        SolrIndexSearcher solrIndexSearcher;
        Node node;

        NodeIndexWorkerRunnable(Node node, SolrIndexSearcher solrIndexSearcher) {
            this.solrIndexSearcher = solrIndexSearcher;
            this.node = node;
        }

        @Override
        protected void doWork() throws IOException, AuthenticationException, JSONException {
            MultiThreadedCoreTracker.this.indexNode(this.node, this.solrIndexSearcher, true);
        }
    }

    abstract class AbstractWorkerRunnable
    implements Runnable {
        AbstractWorkerRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.doWork();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (AuthenticationException e) {
                e.printStackTrace();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            finally {
                this.removeFromQueueAndProdHead();
            }
        }

        protected abstract void doWork() throws IOException, AuthenticationException, JSONException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromQueueAndProdHead() {
            try {
                MultiThreadedCoreTracker.this.reindexThreadLock.writeLock().lock();
                MultiThreadedCoreTracker.this.reindexThreadQueue.remove(this);
            }
            finally {
                MultiThreadedCoreTracker.this.reindexThreadLock.writeLock().unlock();
            }
        }
    }
}

