/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.copy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.util.file.JarUtils;
import org.jboss.util.id.GUID;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.DelegatingHandler;
import org.jboss.virtual.plugins.context.temp.BasicTempInfo;
import org.jboss.virtual.plugins.copy.CopyMechanism;
import org.jboss.virtual.plugins.copy.TempContext;
import org.jboss.virtual.spi.Options;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

public abstract class AbstractCopyMechanism
implements CopyMechanism {
    private static Logger log = Logger.getLogger(CopyMechanism.class);
    private static File tempDir;
    private static WriteRootChecker COPY;
    private static WriteRootChecker EXPLODE;

    public static synchronized File getTempDirectory() {
        if (tempDir == null) {
            tempDir = AccessController.doPrivileged(new GetTempDir());
            log.info((Object)("VFS temp dir: " + tempDir));
        }
        return tempDir;
    }

    protected abstract String getType();

    protected abstract boolean isAlreadyModified(VirtualFileHandler var1) throws IOException;

    protected abstract boolean replaceOldHandler(VirtualFileHandler var1, VirtualFileHandler var2, VirtualFileHandler var3) throws IOException;

    protected static VirtualFileHandler unwrap(VirtualFileHandler handler) {
        if (handler instanceof DelegatingHandler) {
            handler = ((DelegatingHandler)handler).getDelegate();
        }
        return handler;
    }

    public VirtualFile copy(VirtualFile file, VirtualFileHandler handler) throws IOException, URISyntaxException {
        VirtualFileHandler unwrapped = AbstractCopyMechanism.unwrap(handler);
        if (this.isAlreadyModified(unwrapped)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Should already be " + this.getType() + ": " + unwrapped));
            }
            return file;
        }
        File guidDir = AbstractCopyMechanism.createTempDirectory(AbstractCopyMechanism.getTempDirectory(), GUID.asString());
        File copy = this.copy(guidDir, handler);
        String path = handler.getPathName();
        VFSContext oldVFSContext = handler.getVFSContext();
        TempContext fileSystemContext = new TempContext(copy, oldVFSContext, path);
        Options newOptions = fileSystemContext.getOptions();
        if (newOptions != null) {
            Options oldOptions = oldVFSContext.getOptions();
            if (oldOptions != null && oldOptions.size() > 0) {
                newOptions.merge(oldOptions);
            }
            newOptions.addOption("IS_TEMP_FILE", Boolean.TRUE);
            newOptions.addOption(VirtualFileHandler.class.getName(), handler);
        }
        VirtualFileHandler newHandler = fileSystemContext.getRoot();
        oldVFSContext.addTempInfo(new BasicTempInfo(path, copy, newHandler));
        VirtualFileHandler parent = handler.getParent();
        if (parent != null && this.replaceOldHandler(parent, handler, newHandler)) {
            parent.replaceChild(handler, newHandler);
        }
        return newHandler.getVirtualFile();
    }

    protected File copy(File guidDir, VirtualFileHandler handler) throws IOException {
        File copy = this.createCopy(guidDir, handler);
        this.doCopy(copy, handler);
        return copy;
    }

    protected File createCopy(File guidDir, VirtualFileHandler handler) throws IOException {
        return AbstractCopyMechanism.createTempDirectory(guidDir, handler.getName());
    }

    protected abstract void doCopy(File var1, VirtualFileHandler var2) throws IOException;

    protected static File createTempDirectory(File parent, String name) {
        File file = new File(parent, name);
        if (!file.mkdir()) {
            throw new IllegalArgumentException("Cannot create directory: " + file);
        }
        file.deleteOnExit();
        return file;
    }

    protected static void exactCopy(File copy, VirtualFileHandler root) throws IOException {
        AbstractCopyMechanism.unpack(copy, root, COPY);
    }

    protected static void explode(File copy, VirtualFileHandler root) throws IOException {
        AbstractCopyMechanism.unpack(copy, root, EXPLODE);
    }

    protected static void unpack(File copy, VirtualFileHandler root, WriteRootChecker checker) throws IOException {
        List<VirtualFileHandler> children;
        boolean writeRoot = checker.writeRoot(root);
        if (writeRoot) {
            AbstractCopyMechanism.rewrite(root, copy);
        }
        if (!writeRoot && (children = root.getChildren(true)) != null && !children.isEmpty()) {
            for (VirtualFileHandler handler : children) {
                File next = new File(copy, handler.getName());
                if (!checker.writeRoot(handler) && !next.mkdir()) {
                    throw new IllegalArgumentException("Problems creating new directory: " + next);
                }
                next.deleteOnExit();
                AbstractCopyMechanism.unpack(next, handler, checker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unjar(File copy, VirtualFileHandler handler) throws IOException {
        InputStream in = handler.openStream();
        try {
            JarUtils.unjar((InputStream)in, (File)copy);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void rewrite(VirtualFileHandler handler, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        InputStream in = handler.openStream();
        try {
            byte[] bytes = new byte[1024];
            while (in.available() > 0) {
                int length = in.read(bytes);
                if (length <= 0) continue;
                ((OutputStream)out).write(bytes, 0, length);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignored) {}
            try {
                ((OutputStream)out).close();
            }
            catch (IOException ignored) {}
        }
    }

    static {
        COPY = new WriteRootChecker(){

            public boolean writeRoot(VirtualFileHandler handler) throws IOException {
                return handler.isArchive() || handler.isLeaf();
            }
        };
        EXPLODE = new WriteRootChecker(){

            public boolean writeRoot(VirtualFileHandler handler) throws IOException {
                return handler.isLeaf();
            }
        };
    }

    private static interface WriteRootChecker {
        public boolean writeRoot(VirtualFileHandler var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetTempDir
    implements PrivilegedAction<File> {
        private GetTempDir() {
        }

        @Override
        public File run() {
            String tempDirKey = System.getProperty("vfs.temp.dir", "jboss.server.temp.dir");
            return new File(System.getProperty(tempDirKey, System.getProperty("java.io.tmpdir")));
        }
    }
}

