/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public abstract class AbstractLifecycleBean
implements ApplicationListener,
ApplicationContextAware {
    protected static final Log log = LogFactory.getLog(AbstractLifecycleBean.class);
    private ApplicationContext applicationContext = null;

    public void onApplicationEvent(ApplicationEvent event) {
        ContextClosedEvent closedEvent;
        ApplicationContext closedContext;
        if (event instanceof ContextRefreshedEvent) {
            ContextRefreshedEvent refreshEvent = (ContextRefreshedEvent)event;
            ApplicationContext refreshContext = refreshEvent.getApplicationContext();
            if (refreshContext != null && refreshContext.equals(this.applicationContext)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Bootstrapping component " + this.getClass().getName()));
                }
                this.onBootstrap((ApplicationEvent)refreshEvent);
            }
        } else if (event instanceof ContextClosedEvent && (closedContext = (closedEvent = (ContextClosedEvent)event).getApplicationContext()) != null && closedContext.equals(this.applicationContext)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Shutting down component " + this.getClass().getName()));
            }
            this.onShutdown((ApplicationEvent)closedEvent);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected abstract void onBootstrap(ApplicationEvent var1);

    protected abstract void onShutdown(ApplicationEvent var1);
}

