/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.cache.TemplateLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.webscripts.AbstractStore;
import org.springframework.extensions.webscripts.ClassPathStoreResourceResolver;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptLoader;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathStore
extends AbstractStore
implements ApplicationContextAware,
Store {
    private static final Log logger = LogFactory.getLog(ClassPathStore.class);
    protected static final String VFSFILE_URL_PREFIX = "vfsfile:";
    protected static final String VFSZIP_URL_PREFIX = "vfszip:";
    protected static final String VFSJAR_URL_SEPARATOR = ".jar/";
    protected static final String VFSWAR_URL_SEPARATOR = ".war/WEB-INF/";
    protected static final String VFSWAR_CLASSES_URL_SEPARATOR = ".war/WEB-INF/classes/";
    protected ClassPathStoreResourceResolver resolver = null;
    protected String[] storeDirs = null;
    protected ApplicationContext applicationContext = null;
    protected String classPath;
    protected boolean mustExist = false;
    protected boolean exists = false;

    public void setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
    }

    public void setClassPath(String classPath) {
        String cleanClassPath;
        this.classPath = cleanClassPath = classPath.endsWith("/") ? classPath.substring(0, classPath.length() - 1) : classPath;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void init() {
        block11: {
            this.resolver = new ClassPathStoreResourceResolver(this.applicationContext);
            try {
                Resource[] resources = this.resolver.getResources("classpath*:" + this.classPath + "/*");
                if (resources.length != 0) {
                    this.exists = true;
                } else {
                    resources = this.resolver.getResources("classpath*:" + this.classPath + "/**/*");
                    boolean bl = this.exists = resources.length != 0;
                }
                if (!this.exists) break block11;
                try {
                    ArrayList<String> storeDirList;
                    block13: {
                        block12: {
                            storeDirList = null;
                            Object rootResource = null;
                            resources = this.resolver.getResources("classpath*:" + this.classPath + "*");
                            if (resources.length != 0) break block12;
                            resources = this.resolver.getResources("classpath*:" + this.classPath + "/*");
                            if (resources.length == 0) break block13;
                            String externalForm = resources[0].getURL().toExternalForm();
                            if (!(externalForm = externalForm.substring(0, externalForm.lastIndexOf(47))).endsWith(this.classPath)) break block13;
                            storeDirList = new ArrayList(1);
                            storeDirList.add(externalForm);
                            break block13;
                        }
                        storeDirList = new ArrayList<String>(resources.length);
                        for (Resource resource : resources) {
                            String externalForm = resource.getURL().toExternalForm();
                            if (!externalForm.endsWith(this.classPath) && !externalForm.endsWith(this.classPath + "/")) continue;
                            String directoryPath = resource.getFile().getAbsolutePath();
                            if (resource.getFile().isDirectory() && !directoryPath.endsWith("/")) {
                                directoryPath = directoryPath + "/";
                            }
                            if (!new FileSystemResource(directoryPath).exists()) continue;
                            storeDirList.add(resource.getFile().toURI().toURL().toExternalForm());
                        }
                    }
                    if (storeDirList != null && storeDirList.size() != 0) {
                        this.storeDirs = storeDirList.toArray(new String[storeDirList.size()]);
                    }
                }
                catch (IOException ioErr) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unable to resolve storeDir for base path " + this.classPath));
                    }
                }
            }
            catch (IOException ioe) {
                throw new WebScriptException("Failed to initialise Web Script Store classpath: " + this.classPath, ioe);
            }
        }
        if (!this.exists && this.mustExist) {
            throw new WebScriptException("Web Script Store classpath:" + this.classPath + " must exist; it was not found");
        }
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getBasePath() {
        return "classpath:" + this.classPath;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public String[] getAllDocumentPaths() {
        String[] paths;
        try {
            List<String> documentPaths = this.matchDocumentPaths("/**/*");
            paths = documentPaths.toArray(new String[documentPaths.size()]);
        }
        catch (IOException e) {
            paths = new String[]{};
        }
        return paths;
    }

    @Override
    public String[] getDocumentPaths(String path, boolean includeSubPaths, String documentPattern) throws IOException {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (documentPattern == null || documentPattern.length() == 0) {
            documentPattern = "*";
        }
        StringBuilder pattern = new StringBuilder(128);
        pattern.append(path).append(includeSubPaths ? "**/" : "").append(documentPattern);
        List<String> documentPaths = this.matchDocumentPaths(pattern.toString());
        return documentPaths.toArray(new String[documentPaths.size()]);
    }

    @Override
    public String[] getDescriptionDocumentPaths() throws IOException {
        return this.getDocumentPaths("/", true, "*.desc.xml");
    }

    @Override
    public String[] getScriptDocumentPaths(WebScript script) throws IOException {
        String scriptPaths = script.getDescription().getId() + ".*";
        return this.getDocumentPaths("/", false, scriptPaths);
    }

    @Override
    public long lastModified(String documentPath) throws IOException {
        long mod = -1L;
        Resource document = this.getDocumentResource(documentPath);
        if (document != null) {
            mod = document.getURL().openConnection().getLastModified();
        }
        return mod;
    }

    @Override
    public boolean hasDocument(String documentPath) {
        boolean exists = false;
        Resource document = this.getDocumentResource(documentPath);
        if (document != null) {
            exists = document.exists();
        }
        return exists;
    }

    @Override
    public InputStream getDocument(String documentPath) throws IOException {
        Resource document = this.getDocumentResource(documentPath);
        if (document == null || !document.exists()) {
            throw new IOException("Document " + documentPath + " does not exist within store " + this.getBasePath());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getDocument: documentPath: " + documentPath + " , storePath: " + document.getURL().toExternalForm()));
        }
        return document.getInputStream();
    }

    @Override
    public void createDocument(String documentPath, String content) throws IOException {
        throw new IOException("ClassPathStore is read-only - cannot create Document");
    }

    @Override
    public void updateDocument(String documentPath, String content) throws IOException {
        throw new IOException("ClassPathStore is read-only - cannot update Document");
    }

    @Override
    public boolean removeDocument(String documentPath) throws IOException {
        throw new IOException("ClassPathStore is read-only - cannot remove Document");
    }

    @Override
    public TemplateLoader getTemplateLoader() {
        return new ClassPathTemplateLoader();
    }

    @Override
    public ScriptLoader getScriptLoader() {
        return new ClassPathScriptLoader();
    }

    private Resource getDocumentResource(String documentPath) {
        String resourcePath = this.toResourcePath(documentPath);
        return this.resolver.getResource(resourcePath);
    }

    private Resource[] getDocumentResources(String locationPattern) throws IOException {
        String resourcePath = this.toResourcePath(locationPattern);
        Resource[] resources = this.resolver.getResources("classpath*:" + resourcePath);
        ArrayList<Resource> list = new ArrayList<Resource>(resources.length);
        for (Resource resource : resources) {
            if (resource.getURL().toExternalForm().endsWith("/")) continue;
            list.add(resource);
        }
        return list.toArray(new Resource[list.size()]);
    }

    private String toResourcePath(String documentPath) {
        return ClassPathStore.createPath(this.classPath, documentPath);
    }

    private String toDocumentPath(String resourcePath) {
        String documentPath;
        block21: {
            documentPath = null;
            try {
                String jarUrlString;
                int x;
                URL url = ResourceUtils.getURL((String)resourcePath);
                String urlString = resourcePath;
                if (ClassPathStore.isJarURL(url) && (x = urlString.indexOf(jarUrlString = ClassPathStore.extractJarFileURL(url).toExternalForm())) != -1) {
                    if ((urlString = urlString.substring(x + jarUrlString.length())).charAt(0) == '!') {
                        urlString = urlString.substring(1);
                    }
                    if (urlString.charAt(0) == '/') {
                        urlString = urlString.substring(1);
                    }
                }
                if (urlString.startsWith("classpath:")) {
                    urlString = urlString.substring("classpath:".length());
                }
                if (urlString.startsWith("file:")) {
                    if (this.storeDirs == null) {
                        throw new WebScriptException("Unable to resolve a file: resource without a storeDir.");
                    }
                    for (int i = 0; i < this.storeDirs.length; ++i) {
                        if (!urlString.startsWith(this.storeDirs[i])) continue;
                        urlString = urlString.substring(this.storeDirs[i].length());
                        break;
                    }
                } else if (urlString.startsWith(VFSFILE_URL_PREFIX)) {
                    if (this.storeDirs == null) {
                        throw new WebScriptException("Unable to resolve a vfsfile: resource without a storeDir.");
                    }
                    for (int i = 0; i < this.storeDirs.length; ++i) {
                        if (urlString.startsWith(this.storeDirs[i], 3)) {
                            urlString = urlString.substring(this.storeDirs[i].length() + 3);
                        } else {
                            if (!urlString.startsWith(this.storeDirs[i])) continue;
                            urlString = urlString.substring(this.storeDirs[i].length());
                        }
                        break;
                    }
                } else if (this.classPath != null && this.classPath.length() != 0 && urlString.startsWith(this.classPath)) {
                    urlString = urlString.substring(this.classPath.length());
                }
                if (urlString.charAt(0) == '/') {
                    urlString = urlString.substring(1);
                }
                documentPath = urlString;
            }
            catch (FileNotFoundException fnfe) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Unable to determine document path for resource: " + resourcePath + " with base path " + this.classPath), (Throwable)fnfe);
                }
            }
            catch (MalformedURLException mue) {
                if (!logger.isWarnEnabled()) break block21;
                logger.warn((Object)("Unable to determine document path for resource: " + resourcePath + " with base path " + this.classPath), (Throwable)mue);
            }
        }
        return documentPath;
    }

    public static String createPath(String path, String relativePath) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return path + "/" + relativePath;
    }

    private List<String> matchDocumentPaths(String pattern) throws IOException {
        Resource[] resources = this.getDocumentResources(pattern);
        ArrayList<String> documentPaths = new ArrayList<String>(resources.length);
        for (Resource resource : resources) {
            String documentPath = this.toDocumentPath(resource.getURL().toExternalForm());
            documentPaths.add(documentPath);
        }
        return documentPaths;
    }

    public String toString() {
        return "classpath*:" + this.classPath;
    }

    protected static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return "jar".equals(protocol) || "vfszip".equals(protocol) || "zip".equals(protocol) || "vfs".equals(protocol) || "wsjar".equals(protocol) || "code-source".equals(protocol) && url.getPath().contains("!/");
    }

    protected static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex == -1 && (separatorIndex = (urlFile = jarUrl.toString()).indexOf(VFSJAR_URL_SEPARATOR)) != -1) {
            separatorIndex += 4;
        }
        if (separatorIndex == -1) {
            urlFile = jarUrl.toString();
            separatorIndex = urlFile.indexOf(VFSWAR_CLASSES_URL_SEPARATOR);
            if (separatorIndex != -1) {
                separatorIndex += VFSWAR_CLASSES_URL_SEPARATOR.length() - 1;
            } else {
                separatorIndex = urlFile.indexOf(VFSWAR_URL_SEPARATOR);
                if (separatorIndex != -1) {
                    separatorIndex += VFSWAR_URL_SEPARATOR.length() - 1;
                }
            }
        }
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                return new URL(jarUrl.getProtocol() + ':' + jarFile);
            }
        }
        return jarUrl;
    }

    protected class ClassPathTemplateSource {
        private String templatePath;

        protected ClassPathTemplateSource(String path) {
            this.templatePath = path;
        }

        protected long lastModified() {
            try {
                return ClassPathStore.this.lastModified(this.templatePath);
            }
            catch (IOException e) {
                return -1L;
            }
        }

        protected Reader getReader(String encoding) throws IOException {
            Resource resource = ClassPathStore.this.getDocumentResource(this.templatePath);
            return encoding != null ? new InputStreamReader(resource.getInputStream(), encoding) : new InputStreamReader(resource.getInputStream());
        }
    }

    protected class ClassPathTemplateLoader
    implements TemplateLoader {
        protected ClassPathTemplateLoader() {
        }

        public void closeTemplateSource(Object templateSource) throws IOException {
        }

        public Object findTemplateSource(String name) throws IOException {
            ClassPathTemplateSource source = null;
            if (ClassPathStore.this.hasDocument(name)) {
                source = new ClassPathTemplateSource(name);
            }
            return source;
        }

        public long getLastModified(Object templateSource) {
            return ((ClassPathTemplateSource)templateSource).lastModified();
        }

        public Reader getReader(Object templateSource, String encoding) throws IOException {
            return ((ClassPathTemplateSource)templateSource).getReader(encoding);
        }
    }

    private static class ClassPathScriptLocation
    implements ScriptContent {
        private String basePath;
        private String path;
        private Resource location;

        public ClassPathScriptLocation(String basePath, String path, Resource location) {
            this.basePath = basePath;
            this.path = path;
            this.location = location;
        }

        public InputStream getInputStream() {
            try {
                return this.location.getInputStream();
            }
            catch (IOException e) {
                throw new WebScriptException("Unable to retrieve input stream for script " + this.getPathDescription());
            }
        }

        public Reader getReader() {
            try {
                return new InputStreamReader(this.getInputStream(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WebScriptsPlatformException("Unsupported Encoding", e);
            }
        }

        public String getPath() {
            String path = "<unknown path>";
            try {
                path = this.location.getURL().toExternalForm();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return path;
        }

        public String getPathDescription() {
            return "classpath*:" + ClassPathStore.createPath(this.basePath, this.path);
        }

        public boolean isCachable() {
            return true;
        }

        public boolean isSecure() {
            return true;
        }

        public String toString() {
            return this.getPathDescription();
        }
    }

    private class ClassPathScriptLoader
    implements ScriptLoader {
        private Map<String, ScriptContent> locationCache = new ConcurrentHashMap<String, ScriptContent>(256);
        private ClassPathScriptLocation CACHE_NULL_SENTINEL = new ClassPathScriptLocation(null, null, null);

        private ClassPathScriptLoader() {
        }

        public ScriptContent getScript(String documentPath) {
            ScriptContent location = this.locationCache.get(documentPath);
            if (location == null) {
                Resource script = ClassPathStore.this.getDocumentResource(documentPath);
                location = script != null && script.exists() ? new ClassPathScriptLocation(ClassPathStore.this.classPath, documentPath, script) : this.CACHE_NULL_SENTINEL;
                this.locationCache.put(documentPath, location);
            }
            return location != this.CACHE_NULL_SENTINEL ? location : null;
        }
    }
}

