/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.exception.ConnectorProviderException;
import org.springframework.extensions.webscripts.ScriptRemoteConnector;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;
import org.springframework.extensions.webscripts.annotation.ScriptMethod;
import org.springframework.extensions.webscripts.annotation.ScriptParameter;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorProvider;
import org.springframework.extensions.webscripts.connector.ConnectorProviderImpl;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.Response;

@ScriptClass(help="Provides useful functions for working with endpoints, connectors and credentials.", code="// get a connector to the Alfresco repository endpoint\nvar connector = remote.connect(\"alfresco\");\n// retrieve the web script index page \nvar indexHtml = connector.get(\"/index\");", types={ScriptClassType.JavaScriptRootObject})
public class ScriptRemote {
    private static final Log logger = LogFactory.getLog(ScriptRemote.class);
    private ConnectorService connectorService;
    private ConnectorProvider connectorProvider;

    public void setConnectorService(ConnectorService connectorService) {
        this.connectorService = connectorService;
    }

    public void setConnectorProvider(ConnectorProvider connectorProvider) {
        this.connectorProvider = connectorProvider;
    }

    @ScriptMethod(help="Constructs a remote connector to a default endpoint (if configured).\nIf a default endpoint is not configured, null will be returned.", output="The remote client")
    public ScriptRemoteConnector connect() {
        String defaultEndpointId;
        ScriptRemoteConnector remoteConnector = null;
        RemoteConfigElement remoteConfig = this.getRemoteConfig();
        if (remoteConfig != null && (defaultEndpointId = remoteConfig.getDefaultEndpointId()) != null) {
            remoteConnector = this.connect(defaultEndpointId);
        }
        return remoteConnector;
    }

    @ScriptMethod(help="Constructs a remote connector to a specific endpoint (if configured).\nIf a default endpoint is not configured, null will be returned.", output="The remote client")
    public ScriptRemoteConnector connect(@ScriptParameter(help="Endpoint Url") String endpointId) {
        ScriptRemoteConnector remoteConnector = null;
        RemoteConfigElement remoteConfig = this.getRemoteConfig();
        if (remoteConfig != null) {
            RemoteConfigElement.EndpointDescriptor descriptor = remoteConfig.getEndpointDescriptor(endpointId);
            if (descriptor == null) {
                logger.error((Object)("No EndPoint descriptor configuration found for ID: " + endpointId));
            } else {
                if (this.connectorProvider == null) {
                    this.connectorProvider = new ConnectorProviderImpl();
                }
                try {
                    Connector connector = this.connectorProvider.provide(endpointId);
                    remoteConnector = new ScriptRemoteConnector(connector, descriptor);
                }
                catch (ConnectorProviderException cpe) {
                    logger.error((Object)("Unable to provision connector for endpoint: " + endpointId));
                }
            }
        }
        return remoteConnector;
    }

    @ScriptMethod(help="Invoke a specific URI on the default endpoint", output="The reponse")
    public Response call(@ScriptParameter(help="Endpoint Url") String uri) {
        return this.connect().call(uri);
    }

    @ScriptMethod(help="Returns a list of the application endpoint ids", output="List of the application endpoint ids")
    public String[] getEndpointIds() {
        String[] endpointIds = null;
        RemoteConfigElement remoteConfig = this.getRemoteConfig();
        if (remoteConfig != null) {
            endpointIds = remoteConfig.getEndpointIds();
        }
        return endpointIds;
    }

    @ScriptMethod(help="Returns the name of an endpoint", output="Endpoint name")
    public String getEndpointName(@ScriptParameter(help="Endpoint id") String endpointId) {
        RemoteConfigElement.EndpointDescriptor descriptor;
        String name = null;
        RemoteConfigElement remoteConfig = this.getRemoteConfig();
        if (remoteConfig != null && (descriptor = remoteConfig.getEndpointDescriptor(endpointId)) != null) {
            name = descriptor.getName();
        }
        return name;
    }

    @ScriptMethod(help="Returns the description of an endpoint", output="Endpoint description")
    public String getEndpointDescription(@ScriptParameter(help="Endpoint id") String endpointId) {
        RemoteConfigElement.EndpointDescriptor descriptor;
        String description = null;
        RemoteConfigElement remoteConfig = this.getRemoteConfig();
        if (remoteConfig != null && (descriptor = remoteConfig.getEndpointDescriptor(endpointId)) != null) {
            description = descriptor.getDescription();
        }
        return description;
    }

    @ScriptMethod(help="Checks if an endpoint is persistent or not", output="True if the endpoint is persistent")
    public boolean isEndpointPersistent(@ScriptParameter(help="Endpoint id") String id) {
        RemoteConfigElement.EndpointDescriptor descriptor;
        boolean persistent = false;
        RemoteConfigElement remoteConfig = this.getRemoteConfig();
        if (remoteConfig != null && (descriptor = remoteConfig.getEndpointDescriptor(id)) != null) {
            persistent = descriptor.getPersistent();
        }
        return persistent;
    }

    @ScriptMethod(help="Returns the configured URL for the given endpoint", output="The endpoint url")
    public String getEndpointURL(@ScriptParameter(help="Endpoint id") String endpointId) {
        RemoteConfigElement.EndpointDescriptor descriptor;
        String url = null;
        RemoteConfigElement remoteConfig = this.getRemoteConfig();
        if (remoteConfig != null && (descriptor = remoteConfig.getEndpointDescriptor(endpointId)) != null) {
            url = descriptor.getEndpointUrl();
        }
        return url;
    }

    private RemoteConfigElement getRemoteConfig() {
        return this.connectorService.getRemoteConfig();
    }
}

