/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.webscripts.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchPath
implements ApplicationContextAware,
ApplicationListener {
    private ProcessorLifecycle lifecycle = new ProcessorLifecycle();
    private Collection<Store> searchPath = Collections.emptyList();

    public void setSearchPath(List<Store> searchPath) {
        this.searchPath = searchPath;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.lifecycle.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        this.lifecycle.onApplicationEvent(event);
    }

    Collection<Store> getStoresInternal() {
        return this.searchPath;
    }

    public Collection<Store> getStores() {
        ArrayList<Store> aliveStores = new ArrayList<Store>(this.searchPath.size());
        for (Store store : this.searchPath) {
            if (!store.exists()) continue;
            aliveStores.add(store);
        }
        return aliveStores;
    }

    public Store getStore(String storePath) {
        Collection<Store> stores = this.getStores();
        for (Store store : stores) {
            if (!store.getBasePath().equals(storePath)) continue;
            return store;
        }
        return null;
    }

    public boolean hasDocument(String documentPath) throws IOException {
        for (Store store : this.getStores()) {
            if (!store.hasDocument(documentPath)) continue;
            return true;
        }
        return false;
    }

    public InputStream getDocument(String documentPath) throws IOException {
        for (Store store : this.getStores()) {
            if (!store.hasDocument(documentPath)) continue;
            return store.getDocument(documentPath);
        }
        return null;
    }

    private class ProcessorLifecycle
    extends AbstractLifecycleBean {
        private ProcessorLifecycle() {
        }

        protected void onBootstrap(ApplicationEvent event) {
            for (Store store : SearchPath.this.searchPath) {
                store.init();
            }
        }

        protected void onShutdown(ApplicationEvent event) {
        }
    }
}

