/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.dom4j.Element;
import org.springframework.extensions.webscripts.AbstractBaseDescription;

public class TypeDescription
extends AbstractBaseDescription {
    public static final String ROOT_ELEMENT_NAME = "type";
    public static final String FORMAT_ELEMENT_NAME = "format";
    public static final String DEFINITION_ELEMENT_NAME = "definition";
    public static final String DEFINITION_ELEMENT_URL = "url";
    public String format;
    public String definition;
    public String url;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void parse(Element elem) {
        if (this.validateRootElement(elem, ROOT_ELEMENT_NAME)) {
            Element urlElement;
            Element definitionElement;
            super.parse(elem);
            Element formatElement = elem.element(FORMAT_ELEMENT_NAME);
            if (formatElement != null) {
                this.setFormat(formatElement.getTextTrim());
            }
            if ((definitionElement = elem.element(DEFINITION_ELEMENT_NAME)) != null) {
                this.setDefinition(definitionElement.getText());
            }
            if ((urlElement = elem.element(DEFINITION_ELEMENT_URL)) != null) {
                this.setUrl(urlElement.getText());
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    ").append("    ").append("<").append(ROOT_ELEMENT_NAME).append(">").append("\n");
        if (this.getId() != null && !this.getId().equals("")) {
            sb.append("    ").append("    ").append("    ").append("<id>").append(this.getId()).append("</id>").append("\n");
        }
        sb.append("    ").append("    ").append("    ").append("<shortname>").append(this.getShortName()).append("</shortname>").append("\n");
        sb.append("    ").append("    ").append("    ").append("<description>").append(this.getDescription()).append("</description>").append("\n");
        sb.append("    ").append("    ").append("    ").append("<").append(FORMAT_ELEMENT_NAME).append(">").append(this.getFormat()).append("</").append(FORMAT_ELEMENT_NAME).append(">").append("\n");
        if (this.getDefinition() != null) {
            sb.append("    ").append("    ").append("    ").append("<").append(DEFINITION_ELEMENT_NAME).append("><![CDATA[").append(this.getDefinition()).append("]]></").append(DEFINITION_ELEMENT_NAME).append(">").append("\n");
        }
        if (this.getUrl() != null) {
            sb.append("    ").append("    ").append("    ").append("<").append(DEFINITION_ELEMENT_URL).append(">").append(this.getUrl()).append("</").append(DEFINITION_ELEMENT_URL).append(">").append("\n");
        }
        sb.append("    ").append("    ").append("</").append(ROOT_ELEMENT_NAME).append(">");
        return sb.toString();
    }

    public static TypeDescription newInstance() {
        TypeDescription newTypeDescription = new TypeDescription("id", "shortname", "description", "", "");
        return newTypeDescription;
    }

    public boolean compare(TypeDescription newTypeDescription) {
        return !this.compareField(newTypeDescription.getShortName(), this.getShortName()) || !this.compareField(newTypeDescription.getId(), this.getId()) || !this.compareField(newTypeDescription.getDescription(), this.getDescription()) || !this.compareField(newTypeDescription.getFormat(), this.getFormat()) || !this.compareField(newTypeDescription.getDefinition(), this.getDefinition());
    }

    public TypeDescription(String id, String shortName, String description, String format, String definition) {
        super(id, shortName, description);
        this.format = format;
        this.definition = definition;
    }

    public TypeDescription() {
    }
}

