/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.FormatReader;
import org.springframework.extensions.webscripts.FormatRegistry;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.NegotiatedFormat;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class WebScriptRequestImpl
implements WebScriptRequest {
    private static final String ARG_GUEST = "guest";
    private static final String ARG_FORMAT = "format";
    private static final String ARG_ALF_CALLBACK = "alf_callback";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_ACCEPT = "Accept";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    protected static final Log logger = LogFactory.getLog(WebScriptRequestImpl.class);
    private Runtime runtime;
    private Object requestContent = this;
    private String format = null;

    public WebScriptRequestImpl(Runtime runtime) {
        this.runtime = runtime;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public String getExtensionPath() {
        String extensionPath = "";
        Match match = this.getServiceMatch();
        if (match != null) {
            String matchPath = this.getServiceMatch().getPath();
            String pathInfo = this.getPathInfo();
            if (pathInfo != null) {
                extensionPath = pathInfo.substring(matchPath.length());
            }
        }
        return extensionPath;
    }

    public boolean isGuest() {
        return Boolean.valueOf(this.getParameter(ARG_GUEST));
    }

    public String getFormat() {
        if (this.format == null) {
            String format = null;
            Match match = this.getServiceMatch();
            if (match != null && match.getKind() != Match.Kind.URI) {
                String argFormat;
                int pathIdx;
                int extIdx;
                String pathInfo;
                Description desc = match.getWebScript().getDescription();
                Description.FormatStyle style = desc.getFormatStyle();
                if ((style == Description.FormatStyle.extension || style == Description.FormatStyle.any) && (pathInfo = this.getPathInfo()) != null && (extIdx = pathInfo.lastIndexOf(46)) != -1 && (pathIdx = pathInfo.lastIndexOf(47)) < extIdx) {
                    format = pathInfo.substring(extIdx + 1);
                }
                if ((style == Description.FormatStyle.argument || style == Description.FormatStyle.any) && (argFormat = this.getParameter(ARG_FORMAT)) != null) {
                    if (format != null && format.length() > 0) {
                        throw new WebScriptException("Format specified both in extension and format argument");
                    }
                    format = argFormat;
                }
                if (format == null || format.length() == 0) {
                    String accept = this.getHeader(HEADER_ACCEPT);
                    NegotiatedFormat[] negotiatedFormats = desc.getNegotiatedFormats();
                    if (accept != null && negotiatedFormats != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Negotiating format for " + accept));
                        }
                        if ((format = NegotiatedFormat.negotiateFormat(accept, negotiatedFormats)) == null) {
                            throw new WebScriptException(406, "Cannot negotiate appropriate response format for Accept: " + accept);
                        }
                    }
                }
                if (format == null || format.length() == 0) {
                    format = desc.getDefaultFormat();
                }
            }
            this.format = format == null || format.length() == 0 ? "" : format;
        }
        return this.format;
    }

    public Description.FormatStyle getFormatStyle() {
        Match match = this.getServiceMatch();
        if (match == null) {
            return Description.FormatStyle.any;
        }
        Description.FormatStyle style = match.getWebScript().getDescription().getFormatStyle();
        if (style != Description.FormatStyle.any) {
            return style;
        }
        String argFormat = this.getParameter(ARG_FORMAT);
        if (argFormat != null && argFormat.length() > 0) {
            return Description.FormatStyle.argument;
        }
        return Description.FormatStyle.extension;
    }

    public String getJSONCallback() {
        return this.getParameter(ARG_ALF_CALLBACK);
    }

    public boolean forceSuccessStatus() {
        return false;
    }

    public String getContentType() {
        String contentType = this.getHeader(HEADER_CONTENT_TYPE);
        if (contentType != null && contentType.startsWith(MULTIPART_FORM_DATA)) {
            contentType = MULTIPART_FORM_DATA;
        }
        return contentType;
    }

    public Object parseContent() {
        if (this.requestContent == this) {
            FormatRegistry formatRegistry;
            FormatReader<Object> reader;
            this.requestContent = null;
            String contentType = this.getContentType();
            if (contentType != null && contentType.length() > 0 && (reader = (formatRegistry = this.getRuntime().getContainer().getFormatRegistry()).getReader(contentType)) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converting request (mimetype: " + contentType + ") to " + reader.getDestinationClass().getName()));
                }
                this.requestContent = reader.read(this);
            }
        }
        return this.requestContent;
    }
}

