/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.atom;

import java.io.StringReader;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Service;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;
import org.springframework.extensions.webscripts.annotation.ScriptMethod;
import org.springframework.extensions.webscripts.annotation.ScriptParameter;
import org.springframework.extensions.webscripts.atom.AbderaService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScriptClass(help="Collection of Atom related methods.", code="//JavaScript Sample Code\n var object = entry.getExtension(atom.names.cmis_object);\n//Freemarker Sample Code\n<#assign cmis_object=entry.getExtension(atom.names.cmis_object)>", types={ScriptClassType.JavaScriptRootObject, ScriptClassType.TemplateRootObject})
public class AtomService {
    private AbderaService abderaService;

    public void setAbderaService(AbderaService abderaService) {
        this.abderaService = abderaService;
    }

    @ScriptMethod(help="Constructs an empty feed", output="Empty feed")
    public Feed createFeed() {
        return this.abderaService.createFeed();
    }

    @ScriptMethod(help="Constructs an empty entry", output="Empty entry")
    public Entry createEntry() {
        return this.abderaService.createEntry();
    }

    @ScriptMethod(help="Gets pre-configured Atom Extensions (QNames)", output="map of QNames by alias")
    public Map<String, QName> getNames() {
        return this.abderaService.getNames();
    }

    @ScriptMethod(help="Creates a QName", output="QName")
    public QName createQName(@ScriptParameter(help="Uri string") String uri, @ScriptParameter(help="Local name") String localName) {
        return new QName(uri, localName);
    }

    @ScriptMethod(help="Establishs mimetype of atom content", output="mimetype (or null, if it could not be established)")
    public String toMimeType(@ScriptParameter(help="Entry") Entry entry) {
        Content.Type type;
        String mimetype;
        if (entry == null || entry.getContentElement() == null) {
            return null;
        }
        Content content = entry.getContentElement();
        String string = mimetype = content.getMimeType() == null ? null : content.getMimeType().toString();
        if (mimetype == null && (type = content.getContentType()) != null) {
            if (type == Content.Type.HTML) {
                mimetype = Format.HTML.mimetype();
            } else if (type == Content.Type.XHTML) {
                mimetype = Format.XHTML.mimetype();
            } else if (type == Content.Type.TEXT) {
                mimetype = Format.TEXT.mimetype();
            }
        }
        return mimetype;
    }

    @ScriptMethod(help="Parses an Atom element", output="Element")
    public Element toAtom(@ScriptParameter(help="Atom element") org.springframework.extensions.surf.util.Content atom) {
        return this.abderaService.parse(atom.getInputStream(), null);
    }

    @ScriptMethod(help="Parses an Atom element", output="Element")
    public Element toAtom(@ScriptParameter(help="Atom element string") String atom) {
        return this.abderaService.parse(new StringReader(atom), null);
    }

    @ScriptMethod(help="Parses an Atom service", output="Atom servce")
    public Service toService(@ScriptParameter(help="Atom entry") org.springframework.extensions.surf.util.Content entry) {
        return this.abderaService.parseService(entry.getInputStream(), null);
    }

    @ScriptMethod(help="Parses an Atom service", output="Atom service")
    public Service toService(@ScriptParameter(help="Atom entry string") String entry) {
        return this.abderaService.parseService(new StringReader(entry), null);
    }

    @ScriptMethod(help="Parses an Atom Entry", output="Entry")
    public Entry toEntry(@ScriptParameter(help="Atom entry") org.springframework.extensions.surf.util.Content entry) {
        return this.abderaService.parseEntry(entry.getInputStream(), null);
    }

    @ScriptMethod(help="Parses an Atom entry", output="Entry")
    public Entry toEntry(@ScriptParameter(help="Atom entry string") String entry) {
        return this.abderaService.parseEntry(new StringReader(entry), null);
    }

    @ScriptMethod(help="Parses an Atom feed", output="Feed")
    public Feed toFeed(@ScriptParameter(help="Atom feed") org.springframework.extensions.surf.util.Content feed) {
        return this.abderaService.parseFeed(feed.getInputStream(), null);
    }

    @ScriptMethod(help="Parses an Atom feed", output="Feed")
    public Feed toFeed(@ScriptParameter(help="Atom feed string") String feed) {
        return this.abderaService.parseFeed(new StringReader(feed), null);
    }
}

