/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
implements Principal,
Serializable {
    public static String PROP_ID = "id";
    public static String PROP_FIRST_NAME = "firstName";
    public static String PROP_MIDDLE_NAME = "middleName";
    public static String PROP_LAST_NAME = "lastName";
    public static String PROP_EMAIL = "email";
    public static String PROP_ORGANIZATION = "organization";
    public static String PROP_JOB_TITLE = "jobtitle";
    public static String PROP_LOCATION = "location";
    public static String PROP_BIOGRAPHY = "persondescription";
    public static String PROP_TELEPHONE = "telephone";
    public static String PROP_MOBILE_PHONE = "mobile";
    public static String PROP_SKYPE = "skype";
    public static String PROP_INSTANTMSG = "instantmsg";
    public static String PROP_GOOGLEUSERNAME = "googleusername";
    public static String PROP_COMPANY_ADDRESS1 = "companyaddress1";
    public static String PROP_COMPANY_ADDRESS2 = "companyaddress2";
    public static String PROP_COMPANY_ADDRESS3 = "companyaddress3";
    public static String PROP_COMPANY_POSTCODE = "companypostcode";
    public static String PROP_COMPANY_TELEPHONE = "companytelephone";
    public static String PROP_COMPANY_FAX = "companyfax";
    public static String PROP_COMPANY_EMAIL = "companyemail";
    public static final String CAPABILITY_ADMIN = "isAdmin";
    public static final String CAPABILITY_GUEST = "isGuest";
    public static final String CAPABILITY_MUTABLE = "isMutable";
    protected String fullName = null;
    protected final Map<String, Boolean> capabilities;
    protected final Map<String, Serializable> map = new HashMap<String, Serializable>(32);

    public User(String id, Map<String, Boolean> capabilities) {
        this.capabilities = capabilities;
        this.setProperty(PROP_ID, (Serializable)((Object)id));
    }

    @Override
    public String getName() {
        return this.getId();
    }

    public String getId() {
        return this.getStringProperty(PROP_ID);
    }

    public String getFirstName() {
        return this.getStringProperty(PROP_FIRST_NAME);
    }

    public void setFirstName(String value) {
        this.setProperty(PROP_FIRST_NAME, (Serializable)((Object)value));
        this.fullName = null;
    }

    public String getLastName() {
        return this.getStringProperty(PROP_LAST_NAME);
    }

    public void setLastName(String value) {
        this.setProperty(PROP_LAST_NAME, (Serializable)((Object)value));
        this.fullName = null;
    }

    public String getMiddleName() {
        return this.getStringProperty(PROP_MIDDLE_NAME);
    }

    public void setMiddleName(String value) {
        this.setProperty(PROP_MIDDLE_NAME, (Serializable)((Object)value));
        this.fullName = null;
    }

    public String getEmail() {
        return this.getStringProperty(PROP_EMAIL);
    }

    public void setEmail(String value) {
        this.setProperty(PROP_EMAIL, (Serializable)((Object)value));
    }

    public String getOrganization() {
        return this.getStringProperty(PROP_ORGANIZATION);
    }

    public void setOrganization(String value) {
        this.setProperty(PROP_ORGANIZATION, (Serializable)((Object)value));
    }

    public String getJobTitle() {
        return this.getStringProperty(PROP_JOB_TITLE);
    }

    public void setJobTitle(String value) {
        this.setProperty(PROP_JOB_TITLE, (Serializable)((Object)value));
    }

    public String getLocation() {
        return this.getStringProperty(PROP_LOCATION);
    }

    public void setLocation(String value) {
        this.setProperty(PROP_LOCATION, (Serializable)((Object)value));
    }

    public String getBiography() {
        return this.getStringProperty(PROP_BIOGRAPHY);
    }

    public void setBiography(String value) {
        if (value != null && value.length() != 0) {
            value = StringUtils.stripUnsafeHTMLTags(value, false);
        }
        this.setProperty(PROP_BIOGRAPHY, (Serializable)((Object)value));
    }

    public String getTelephone() {
        return this.getStringProperty(PROP_TELEPHONE);
    }

    public void setTelephone(String value) {
        this.setProperty(PROP_TELEPHONE, (Serializable)((Object)value));
    }

    public String getMobilePhone() {
        return this.getStringProperty(PROP_MOBILE_PHONE);
    }

    public void setMobilePhone(String value) {
        this.setProperty(PROP_MOBILE_PHONE, (Serializable)((Object)value));
    }

    public String getSkype() {
        return this.getStringProperty(PROP_SKYPE);
    }

    public void setSkype(String value) {
        this.setProperty(PROP_SKYPE, (Serializable)((Object)value));
    }

    public String getInstantMsg() {
        return this.getStringProperty(PROP_INSTANTMSG);
    }

    public void setInstantMsg(String value) {
        this.setProperty(PROP_INSTANTMSG, (Serializable)((Object)value));
    }

    public String getGoogleUsername() {
        return this.getStringProperty(PROP_GOOGLEUSERNAME);
    }

    public void setGoogleUsername(String value) {
        this.setProperty(PROP_GOOGLEUSERNAME, (Serializable)((Object)value));
    }

    public String getCompanyAddress1() {
        return this.getStringProperty(PROP_COMPANY_ADDRESS1);
    }

    public void setCompanyAddress1(String value) {
        this.setProperty(PROP_COMPANY_ADDRESS1, (Serializable)((Object)value));
    }

    public String getCompanyAddress2() {
        return this.getStringProperty(PROP_COMPANY_ADDRESS2);
    }

    public void setCompanyAddress2(String value) {
        this.setProperty(PROP_COMPANY_ADDRESS2, (Serializable)((Object)value));
    }

    public String getCompanyAddress3() {
        return this.getStringProperty(PROP_COMPANY_ADDRESS3);
    }

    public void setCompanyAddress3(String value) {
        this.setProperty(PROP_COMPANY_ADDRESS3, (Serializable)((Object)value));
    }

    public String getCompanyPostcode() {
        return this.getStringProperty(PROP_COMPANY_POSTCODE);
    }

    public void setCompanyPostcode(String value) {
        this.setProperty(PROP_COMPANY_POSTCODE, (Serializable)((Object)value));
    }

    public String getCompanyTelephone() {
        return this.getStringProperty(PROP_COMPANY_TELEPHONE);
    }

    public void setCompanyTelephone(String value) {
        this.setProperty(PROP_COMPANY_TELEPHONE, (Serializable)((Object)value));
    }

    public String getCompanyFax() {
        return this.getStringProperty(PROP_COMPANY_FAX);
    }

    public void setCompanyFax(String value) {
        this.setProperty(PROP_COMPANY_FAX, (Serializable)((Object)value));
    }

    public String getCompanyEmail() {
        return this.getStringProperty(PROP_COMPANY_EMAIL);
    }

    public void setCompanyEmail(String value) {
        this.setProperty(PROP_COMPANY_EMAIL, (Serializable)((Object)value));
    }

    public Object getProperty(String key) {
        return this.map.get(key);
    }

    public String getStringProperty(String key) {
        return (String)((Object)this.map.get(key));
    }

    public void setProperty(String key, Serializable value) {
        this.map.put(key, value);
    }

    public Map<String, Serializable> getProperties() {
        return this.map;
    }

    public boolean isAdmin() {
        Boolean value = this.capabilities.get(CAPABILITY_ADMIN);
        return value == null ? false : value;
    }

    public boolean isGuest() {
        Boolean value = this.capabilities.get(CAPABILITY_GUEST);
        return value == null ? false : value;
    }

    public Map<String, Boolean> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    public String getFullName() {
        if (this.fullName == null) {
            boolean hasFirstName = this.getFirstName() != null && this.getFirstName().length() != 0;
            boolean hasMiddleName = this.getMiddleName() != null && this.getMiddleName().length() != 0;
            boolean hasLastName = this.getLastName() != null && this.getLastName().length() != 0;
            this.fullName = this.getId();
            if (hasFirstName) {
                this.fullName = this.getFirstName();
                if (hasMiddleName) {
                    this.fullName = this.fullName + " " + this.getMiddleName();
                }
                if (hasLastName) {
                    this.fullName = this.fullName + " " + this.getLastName();
                }
            }
        }
        return this.fullName;
    }

    public void save() {
    }
}

