/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.json;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.FormatReader;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONReader
implements FormatReader<Object> {
    @Override
    public Class<? extends Object> getDestinationClass() {
        return Object.class;
    }

    @Override
    public String getSourceMimetype() {
        return Format.JSON.mimetype();
    }

    @Override
    public Object read(WebScriptRequest req) {
        Content content = req.getContent();
        if (content == null) {
            throw new WebScriptException("Failed to convert request to JSON");
        }
        Object result = null;
        try {
            String jsonString = content.getContent();
            result = jsonString.startsWith("[") ? new JSONArray(jsonString) : new JSONObject(jsonString);
        }
        catch (Exception exception) {
            throw new WebScriptException("Failed to convert request to JSON", exception);
        }
        return result;
    }

    @Override
    public Map<String, Object> createScriptParameters(WebScriptRequest req, WebScriptResponse res) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("json", this.read(req));
        return params;
    }
}

