/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.json;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.json.RawValue;

public final class JSONWriter {
    private Writer out;
    private Stack<Boolean> stack = new Stack();

    public JSONWriter(Writer out) {
        this.out = out;
        this.stack.push(Boolean.FALSE);
    }

    public JSONWriter startArray() throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write("[");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        this.stack.push(Boolean.FALSE);
        return this;
    }

    public JSONWriter endArray() throws IOException {
        this.out.write("]");
        this.stack.pop();
        return this;
    }

    public JSONWriter startObject() throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write("{");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        this.stack.push(Boolean.FALSE);
        return this;
    }

    public JSONWriter endObject() throws IOException {
        this.out.write("}");
        this.stack.pop();
        return this;
    }

    public JSONWriter startValue(String name) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        this.stack.push(Boolean.FALSE);
        return this;
    }

    public JSONWriter endValue() {
        this.stack.pop();
        return this;
    }

    public JSONWriter writeValue(String name, String value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": \"");
        this.out.write(JSONWriter.encodeJSONString(value));
        this.out.write(34);
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String name, int value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Integer.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String name, long value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Long.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String name, float value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Float.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String name, double value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Double.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String name, boolean value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": ");
        this.out.write(Boolean.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(String value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(JSONWriter.encodeJSONString(value));
        this.out.write(34);
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(int value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Integer.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(long value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Long.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(float value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Float.isInfinite(value) || Float.isNaN(value) ? "0" : Float.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(double value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Double.isInfinite(value) || Double.isNaN(value) ? "0" : Double.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeValue(boolean value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(Boolean.toString(value));
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeNullValue() throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write("null");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeNullValue(String name) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(34);
        this.out.write(name);
        this.out.write("\": null");
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public JSONWriter writeRawValue(RawValue value) throws IOException {
        if (this.stack.peek().booleanValue()) {
            this.out.write(", ");
        }
        this.out.write(value.toJSONString());
        this.stack.pop();
        this.stack.push(Boolean.TRUE);
        return this;
    }

    public static String encodeToJSON(Object obj) {
        try {
            StringBuilderWriter out = new StringBuilderWriter(1024);
            JSONWriter.encodeToJSON(obj, new JSONWriter((Writer)out));
            return out.toString();
        }
        catch (IOException ioe) {
            return "";
        }
    }

    public static void encodeToJSON(Object obj, JSONWriter writer) throws IOException {
        if (obj instanceof Map) {
            writer.startObject();
            for (Object key : ((Map)obj).keySet()) {
                writer.startValue(key.toString());
                JSONWriter.encodeToJSON(((Map)obj).get(key), writer);
                writer.endValue();
            }
            writer.endObject();
        } else if (obj instanceof List) {
            writer.startArray();
            for (Object val : (List)obj) {
                JSONWriter.encodeToJSON(val, writer);
            }
            writer.endArray();
        } else if (obj instanceof String) {
            writer.writeValue((String)obj);
        } else if (obj instanceof Boolean) {
            writer.writeValue((Boolean)obj);
        } else if (obj instanceof Double) {
            writer.writeValue((Double)obj);
        } else if (obj instanceof Float) {
            writer.writeValue(((Float)obj).floatValue());
        } else if (obj instanceof Long) {
            writer.writeValue((Long)obj);
        } else if (obj instanceof Integer) {
            writer.writeValue((Integer)obj);
        } else if (obj instanceof RawValue) {
            writer.writeRawValue((RawValue)obj);
        } else if (obj != null) {
            writer.writeValue(obj.toString());
        } else {
            writer.writeNullValue();
        }
    }

    public static String encodeJSONString(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            String enc = null;
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    enc = "\\\\";
                    break;
                }
                case '\"': {
                    enc = "\\\"";
                    break;
                }
                case '/': {
                    enc = "\\/";
                    break;
                }
                case '\b': {
                    enc = "\\b";
                    break;
                }
                case '\t': {
                    enc = "\\t";
                    break;
                }
                case '\n': {
                    enc = "\\n";
                    break;
                }
                case '\f': {
                    enc = "\\f";
                    break;
                }
                case '\r': {
                    enc = "\\r";
                    break;
                }
                default: {
                    if (c < '\u0080' && c >= ' ') break;
                    String u = "000" + Integer.toHexString(c);
                    enc = "\\u" + u.substring(u.length() - 4);
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = s.substring(0, i);
                    sb = new StringBuilder(i + 8);
                    sb.append(soFar);
                }
                sb.append(enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return s;
        }
        return sb.toString();
    }
}

