/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.AbstractRuntime;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WebScriptSession;
import org.springframework.extensions.webscripts.WebScriptSessionFactory;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;
import org.springframework.extensions.webscripts.servlet.WebScriptServletSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebScriptServletRuntime
extends AbstractRuntime {
    protected ServletAuthenticatorFactory authFactory;
    protected HttpServletRequest req;
    protected HttpServletResponse res;
    protected ServerProperties serverProperties;
    protected WebScriptServletRequest servletReq;
    protected WebScriptServletResponse servletRes;
    protected WebScriptServletSession servletSession;

    public WebScriptServletRuntime(RuntimeContainer container, ServletAuthenticatorFactory authFactory, HttpServletRequest req, HttpServletResponse res, ServerProperties serverProperties) {
        super(container);
        this.authFactory = authFactory;
        this.req = req;
        this.res = res;
        this.serverProperties = serverProperties;
    }

    @Override
    protected String getScriptMethod() {
        String method = this.req.getMethod();
        if (method.equalsIgnoreCase("post")) {
            boolean overloadParam = false;
            String overload = this.req.getHeader("X-HTTP-Method-Override");
            if (overload == null || overload.length() == 0) {
                overload = this.req.getParameter("alf_method");
                overloadParam = true;
            }
            if (overload != null && overload.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("POST is tunnelling method '" + overload + "' as specified by " + (overloadParam ? "alf_method parameter" : "X-HTTP-Method-Override header")));
                }
                method = overload;
            }
        }
        return method;
    }

    @Override
    protected String getScriptUrl() {
        String requestURI = this.req.getRequestURI();
        String serviceContextPath = this.req.getContextPath() + this.req.getServletPath();
        String pathInfo = serviceContextPath.length() > requestURI.length() ? this.req.getPathInfo() : URLDecoder.decode((String)requestURI.substring(serviceContextPath.length()));
        return pathInfo;
    }

    @Override
    protected WebScriptRequest createRequest(Match match) {
        this.servletReq = new WebScriptServletRequest(this, this.req, match, this.serverProperties);
        return this.servletReq;
    }

    @Override
    protected WebScriptResponse createResponse() {
        this.servletRes = new WebScriptServletResponse(this, this.res);
        return this.servletRes;
    }

    @Override
    protected Authenticator createAuthenticator() {
        if (this.authFactory == null) {
            return null;
        }
        return this.authFactory.create(this.servletReq, this.servletRes);
    }

    @Override
    protected WebScriptSessionFactory createSessionFactory() {
        return new WebScriptSessionFactory(){

            public WebScriptSession createSession() {
                return new WebScriptServletSession(WebScriptServletRuntime.this.req.getSession());
            }
        };
    }

    @Override
    public String getName() {
        return "ServletRuntime";
    }

    public static HttpServletRequest getHttpServletRequest(WebScriptRequest request) {
        WebScriptRequest realRequest = WebScriptServletRuntime.getRealWebScriptRequest(request);
        if (realRequest instanceof WebScriptServletRequest) {
            return ((WebScriptServletRequest)realRequest).getHttpServletRequest();
        }
        return null;
    }

    public static HttpServletResponse getHttpServletResponse(WebScriptResponse response) {
        WebScriptResponse realResponse = WebScriptServletRuntime.getRealWebScriptResponse(response);
        if (realResponse instanceof WebScriptServletResponse) {
            return ((WebScriptServletResponse)realResponse).getHttpServletResponse();
        }
        return null;
    }

    public List<HttpMethod> getSupportedMethods() {
        HttpMethod[] methods = HttpMethod.values();
        ArrayList<HttpMethod> supportedMethods = new ArrayList<HttpMethod>(methods.length);
        Match match = null;
        for (int i = 0; i < methods.length; ++i) {
            match = this.container.getRegistry().findWebScript(methods[i].name(), this.getScriptUrl());
            if (!match.getKind().equals((Object)Match.Kind.FULL)) continue;
            supportedMethods.add(methods[i]);
        }
        return supportedMethods;
    }
}

