/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet.mvc;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

public abstract class AbstractWebScriptViewResolver
extends UrlBasedViewResolver {
    private final Map<Object, View> viewCache = new ConcurrentHashMap<Object, View>(128);
    protected boolean useNullSentinel = true;

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        if (!this.isCache()) {
            return this.createView(viewName, locale);
        }
        Object cacheKey = this.getCacheKey(viewName, locale);
        View view = this.viewCache.get(cacheKey);
        if (view == null && (view = this.createView(viewName, locale)) == null && this.useNullSentinel) {
            view = ViewSentinel.getInstance();
            this.viewCache.put(cacheKey, view);
        }
        return view != ViewSentinel.getInstance() ? view : null;
    }

    public void clearCache() {
        this.viewCache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ViewSentinel
    implements View {
        private static ViewSentinel instance = new ViewSentinel();

        private ViewSentinel() {
        }

        static ViewSentinel getInstance() {
            return instance;
        }

        public String getContentType() {
            return null;
        }

        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        }
    }
}

