/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Map;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.springframework.extensions.webscripts.JaxRSUriIndex;
import org.springframework.extensions.webscripts.UriTemplate;
import org.springframework.extensions.webscripts.WebScriptException;

public class JaxRSUriIndexTest
extends TestCase {
    public void testInvalidTemplate() {
        try {
            new UriTemplate(null);
            JaxRSUriIndexTest.fail((String)"Failed to catch null template");
        }
        catch (WebScriptException e) {
            // empty catch block
        }
        try {
            new UriTemplate("");
            JaxRSUriIndexTest.fail((String)"Failed to catch empty template");
        }
        catch (WebScriptException e) {
            // empty catch block
        }
        try {
            new UriTemplate("//");
            JaxRSUriIndexTest.fail((String)"Failed to catch double /");
        }
        catch (WebScriptException e) {
            // empty catch block
        }
        try {
            new UriTemplate("/a//");
            JaxRSUriIndexTest.fail((String)"Failed to catch double /");
        }
        catch (WebScriptException e) {
            // empty catch block
        }
        try {
            new UriTemplate("/a//b");
            JaxRSUriIndexTest.fail((String)"Failed to catch double /");
        }
        catch (WebScriptException e) {
            // empty catch block
        }
        try {
            new UriTemplate("/{1a}");
            JaxRSUriIndexTest.fail((String)"Failed to catch var name beginning with number");
        }
        catch (WebScriptException e) {
            // empty catch block
        }
        try {
            new UriTemplate("/;a");
            JaxRSUriIndexTest.fail((String)"Failed to catch semi-colon without prefix");
        }
        catch (WebScriptException e) {
            // empty catch block
        }
        try {
            new UriTemplate("/{1;a}");
            JaxRSUriIndexTest.fail((String)"Failed to catch semi-colon in template var name");
        }
        catch (WebScriptException webScriptException) {
            // empty catch block
        }
    }

    public void testValidTemplate() {
        try {
            new UriTemplate("/");
        }
        catch (WebScriptException e) {
            JaxRSUriIndexTest.fail((String)"Root path is valid");
        }
        try {
            new UriTemplate("/a;");
        }
        catch (WebScriptException e) {
            JaxRSUriIndexTest.fail((String)"Semi-colon in path is valid");
        }
        try {
            new UriTemplate("/a;aaaa");
        }
        catch (WebScriptException e) {
            JaxRSUriIndexTest.fail((String)"Semi-colon in path is valid");
        }
        try {
            new UriTemplate("/a;a;aaaa");
        }
        catch (WebScriptException e) {
            JaxRSUriIndexTest.fail((String)"Semi-colon in path is valid");
        }
        try {
            new UriTemplate("/{a_b}");
        }
        catch (WebScriptException e) {
            JaxRSUriIndexTest.fail((String)"Underscore in token name is valid");
        }
        try {
            new UriTemplate("/ads/test-2/{storeid}/{path}");
        }
        catch (WebScriptException e) {
            JaxRSUriIndexTest.fail((String)"Hypthen in path is valid");
        }
        try {
            new UriTemplate("/ads/test_2/{storeid}/{path}");
        }
        catch (WebScriptException e) {
            JaxRSUriIndexTest.fail((String)"Hypthen in path is valid");
        }
    }

    public void testParseTemplate() {
        UriTemplate i1 = new UriTemplate("/");
        JaxRSUriIndexTest.assertEquals((String)"/", (String)i1.getTemplate());
        JaxRSUriIndexTest.assertEquals((String)"/", (String)i1.getRegex().pattern());
        JaxRSUriIndexTest.assertEquals((int)1, (int)i1.getStaticCharCount());
        JaxRSUriIndexTest.assertEquals((int)0, (int)i1.getVariableNames().length);
        UriTemplate i2 = new UriTemplate("/a/{a1}/b{b1}b/{c_c}");
        JaxRSUriIndexTest.assertEquals((String)"/a/{a1}/b{b1}b/{c_c}", (String)i2.getTemplate());
        JaxRSUriIndexTest.assertEquals((String)"/a/(.*?)/b(.*?)b/(.*?)", (String)i2.getRegex().pattern());
        JaxRSUriIndexTest.assertEquals((int)7, (int)i2.getStaticCharCount());
        JaxRSUriIndexTest.assertEquals((int)3, (int)i2.getVariableNames().length);
        JaxRSUriIndexTest.assertEquals((String)"a1", (String)i2.getVariableNames()[0]);
        JaxRSUriIndexTest.assertEquals((String)"b1", (String)i2.getVariableNames()[1]);
        JaxRSUriIndexTest.assertEquals((String)"c_c", (String)i2.getVariableNames()[2]);
    }

    public void testTemplateMatch() {
        UriTemplate i1 = new UriTemplate("/a/{a1}/b/b{b1}b");
        JaxRSUriIndexTest.assertNull((Object)i1.match("/"));
        JaxRSUriIndexTest.assertNull((Object)i1.match("/a"));
        JaxRSUriIndexTest.assertNull((Object)i1.match("/a/1/b"));
        JaxRSUriIndexTest.assertNull((Object)i1.match("/a/1/b/2"));
        JaxRSUriIndexTest.assertNull((Object)i1.match("/a/1/b/b2"));
        JaxRSUriIndexTest.assertNull((Object)i1.match("/a/1/b/b2b/"));
        Map values1 = i1.match("/a/1/b/b2b");
        JaxRSUriIndexTest.assertNotNull((Object)values1);
        JaxRSUriIndexTest.assertEquals((int)2, (int)values1.size());
        JaxRSUriIndexTest.assertEquals((String)"1", (String)((String)values1.get("a1")));
        JaxRSUriIndexTest.assertEquals((String)"2", (String)((String)values1.get("b1")));
        UriTemplate i2 = new UriTemplate("/a/{a1}/b/{b1}");
        Map values2 = i2.match("/a/1/b/2/3");
        JaxRSUriIndexTest.assertNotNull((Object)values2);
        JaxRSUriIndexTest.assertEquals((int)2, (int)values2.size());
        JaxRSUriIndexTest.assertEquals((String)"1", (String)((String)values2.get("a1")));
        JaxRSUriIndexTest.assertEquals((String)"2/3", (String)((String)values2.get("b1")));
        UriTemplate i3 = new UriTemplate("/a/{a1}/b/{a1}");
        Map values3 = i3.match("/a/1/b/2");
        JaxRSUriIndexTest.assertNull((Object)values3);
        UriTemplate i4 = new UriTemplate("/a/b{b}/{c}");
        Map values4 = i4.match("/a/b/c");
        JaxRSUriIndexTest.assertEquals((int)2, (int)values4.size());
        JaxRSUriIndexTest.assertEquals((String)"", (String)((String)values4.get("b")));
        JaxRSUriIndexTest.assertEquals((String)"c", (String)((String)values4.get("c")));
        UriTemplate i5 = new UriTemplate("/a/b{b}/{c}");
        Map values5 = i5.match("/a/bb/c");
        JaxRSUriIndexTest.assertEquals((int)2, (int)values5.size());
        JaxRSUriIndexTest.assertEquals((String)"b", (String)((String)values5.get("b")));
        JaxRSUriIndexTest.assertEquals((String)"c", (String)((String)values5.get("c")));
    }

    public void testTemplateDotMatch() {
        UriTemplate i1 = new UriTemplate("/a/b/{b}/c");
        Map values1 = i1.match("/a/b/x/y/z.ext/c");
        JaxRSUriIndexTest.assertEquals((int)1, (int)values1.size());
        JaxRSUriIndexTest.assertEquals((String)"x/y/z.ext", (String)((String)values1.get("b")));
    }

    public void testIndexSort() {
        JaxRSUriIndex.IndexEntry i1 = new JaxRSUriIndex.IndexEntry("GET", new UriTemplate("/"), false, null);
        JaxRSUriIndex.IndexEntry i2 = new JaxRSUriIndex.IndexEntry("POST", new UriTemplate("/a/{a}"), false, null);
        JaxRSUriIndex.IndexEntry i3 = new JaxRSUriIndex.IndexEntry("get", new UriTemplate("/a/{a}/b"), false, null);
        JaxRSUriIndex.IndexEntry i4 = new JaxRSUriIndex.IndexEntry("get", new UriTemplate("/a"), false, null);
        JaxRSUriIndex.IndexEntry i5 = new JaxRSUriIndex.IndexEntry("get", new UriTemplate("/c/d"), false, null);
        JaxRSUriIndex.IndexEntry i6 = new JaxRSUriIndex.IndexEntry("get", new UriTemplate("/c/d/{e}"), true, null);
        JaxRSUriIndex.IndexEntry i7 = new JaxRSUriIndex.IndexEntry("get", new UriTemplate("/a/b"), false, null);
        JaxRSUriIndex.IndexEntry i8 = new JaxRSUriIndex.IndexEntry("get", new UriTemplate("/c/d/{e}/{e}"), false, null);
        JaxRSUriIndex.IndexEntry i9 = new JaxRSUriIndex.IndexEntry("get", new UriTemplate("/e"), false, null);
        JaxRSUriIndex.IndexEntry i10 = new JaxRSUriIndex.IndexEntry("GET", new UriTemplate("/a/{a}"), false, null);
        TreeSet<JaxRSUriIndex.IndexEntry> index = new TreeSet<JaxRSUriIndex.IndexEntry>(JaxRSUriIndex.COMPARATOR);
        index.add(i1);
        index.add(i2);
        index.add(i3);
        index.add(i4);
        index.add(i5);
        index.add(i6);
        index.add(i7);
        index.add(i8);
        index.add(i9);
        index.add(i10);
        JaxRSUriIndex.IndexEntry[] sorted = new JaxRSUriIndex.IndexEntry[index.size()];
        index.toArray(sorted);
        JaxRSUriIndexTest.assertEquals((Object)i1, (Object)sorted[9]);
        JaxRSUriIndexTest.assertEquals((Object)i4, (Object)sorted[8]);
        JaxRSUriIndexTest.assertEquals((Object)i9, (Object)sorted[7]);
        JaxRSUriIndexTest.assertEquals((Object)i10, (Object)sorted[6]);
        JaxRSUriIndexTest.assertEquals((Object)i2, (Object)sorted[5]);
        JaxRSUriIndexTest.assertEquals((Object)i7, (Object)sorted[4]);
        JaxRSUriIndexTest.assertEquals((Object)i5, (Object)sorted[3]);
        JaxRSUriIndexTest.assertEquals((Object)i3, (Object)sorted[2]);
        JaxRSUriIndexTest.assertEquals((Object)i6, (Object)sorted[1]);
        JaxRSUriIndexTest.assertEquals((Object)i8, (Object)sorted[0]);
    }
}

