/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.ui.cas;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.intercept.web.AuthenticationEntryPoint;
import net.sf.acegisecurity.ui.cas.ServiceProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CasProcessingFilterEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private ServiceProperties serviceProperties;
    private String loginUrl;

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setServiceProperties(ServiceProperties serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public ServiceProperties getServiceProperties() {
        return this.serviceProperties;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.loginUrl, (String)"loginUrl must be specified");
        Assert.notNull((Object)this.serviceProperties, (String)"serviceProperties must be specified");
    }

    public void commence(ServletRequest request, ServletResponse response, AuthenticationException authenticationException) throws IOException, ServletException {
        String url = this.serviceProperties.isSendRenew() ? this.loginUrl + "?renew=true" + "&service=" + this.serviceProperties.getService() : this.loginUrl + "?service=" + URLEncoder.encode(this.serviceProperties.getService(), "UTF-8");
        ((HttpServletResponse)response).sendRedirect(url);
    }
}

