/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.lang.reflect.Array;
import org.apache.ibatis.ognl.ASTProperty;
import org.apache.ibatis.ognl.DynamicSubscript;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.SimpleNode;

class ASTChain
extends SimpleNode {
    public ASTChain(int id) {
        super(id);
    }

    public ASTChain(OgnlParser p, int id) {
        super(p, id);
    }

    public void jjtClose() {
        this.flattenTree();
    }

    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        Object result = source;
        int ilast = this.children.length - 1;
        for (int i = 0; i <= ilast; ++i) {
            ASTProperty indexNode;
            ASTProperty propertyNode;
            int indexType;
            boolean handled = false;
            if (i < ilast && this.children[i] instanceof ASTProperty && (indexType = (propertyNode = (ASTProperty)this.children[i]).getIndexedPropertyType(context, result)) != OgnlRuntime.INDEXED_PROPERTY_NONE && this.children[i + 1] instanceof ASTProperty && (indexNode = (ASTProperty)this.children[i + 1]).isIndexedAccess()) {
                Object index = indexNode.getProperty(context, result);
                if (index instanceof DynamicSubscript) {
                    if (indexType == OgnlRuntime.INDEXED_PROPERTY_INT) {
                        Object array = propertyNode.getValue(context, result);
                        int len = Array.getLength(array);
                        switch (((DynamicSubscript)index).getFlag()) {
                            case 3: {
                                result = Array.newInstance(array.getClass().getComponentType(), len);
                                System.arraycopy(array, 0, result, 0, len);
                                handled = true;
                                ++i;
                                break;
                            }
                            case 0: {
                                index = new Integer(len > 0 ? 0 : -1);
                                break;
                            }
                            case 1: {
                                index = new Integer(len > 0 ? len / 2 : -1);
                                break;
                            }
                            case 2: {
                                index = new Integer(len > 0 ? len - 1 : -1);
                            }
                        }
                    } else if (indexType == OgnlRuntime.INDEXED_PROPERTY_OBJECT) {
                        throw new OgnlException("DynamicSubscript '" + indexNode + "' not allowed for object indexed property '" + propertyNode + "'");
                    }
                }
                if (!handled) {
                    result = OgnlRuntime.getIndexedProperty(context, result, propertyNode.getProperty(context, result).toString(), index);
                    handled = true;
                    ++i;
                }
            }
            if (handled) continue;
            result = this.children[i].getValue(context, result);
        }
        return result;
    }

    protected void setValueBody(OgnlContext context, Object target, Object value) throws OgnlException {
        boolean handled = false;
        int ilast = this.children.length - 2;
        for (int i = 0; i <= ilast; ++i) {
            ASTProperty indexNode;
            ASTProperty propertyNode;
            int indexType;
            if (i == ilast && this.children[i] instanceof ASTProperty && (indexType = (propertyNode = (ASTProperty)this.children[i]).getIndexedPropertyType(context, target)) != OgnlRuntime.INDEXED_PROPERTY_NONE && this.children[i + 1] instanceof ASTProperty && (indexNode = (ASTProperty)this.children[i + 1]).isIndexedAccess()) {
                Object index = indexNode.getProperty(context, target);
                if (index instanceof DynamicSubscript) {
                    if (indexType == OgnlRuntime.INDEXED_PROPERTY_INT) {
                        Object array = propertyNode.getValue(context, target);
                        int len = Array.getLength(array);
                        switch (((DynamicSubscript)index).getFlag()) {
                            case 3: {
                                System.arraycopy(target, 0, value, 0, len);
                                handled = true;
                                ++i;
                                break;
                            }
                            case 0: {
                                index = new Integer(len > 0 ? 0 : -1);
                                break;
                            }
                            case 1: {
                                index = new Integer(len > 0 ? len / 2 : -1);
                                break;
                            }
                            case 2: {
                                index = new Integer(len > 0 ? len - 1 : -1);
                            }
                        }
                    } else if (indexType == OgnlRuntime.INDEXED_PROPERTY_OBJECT) {
                        throw new OgnlException("DynamicSubscript '" + indexNode + "' not allowed for object indexed property '" + propertyNode + "'");
                    }
                }
                if (!handled) {
                    OgnlRuntime.setIndexedProperty(context, target, propertyNode.getProperty(context, target).toString(), index, value);
                    handled = true;
                    ++i;
                }
            }
            if (handled) continue;
            target = this.children[i].getValue(context, target);
        }
        if (!handled) {
            this.children[this.children.length - 1].setValue(context, target, value);
        }
    }

    public boolean isSimpleNavigationChain(OgnlContext context) throws OgnlException {
        boolean result = false;
        if (this.children != null && this.children.length > 0) {
            result = true;
            for (int i = 0; result && i < this.children.length; ++i) {
                result = this.children[i] instanceof SimpleNode ? ((SimpleNode)this.children[i]).isSimpleProperty(context) : false;
            }
        }
        return result;
    }

    public String toString() {
        String result = "";
        if (this.children != null && this.children.length > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!(i <= 0 || this.children[i] instanceof ASTProperty && ((ASTProperty)this.children[i]).isIndexedAccess())) {
                    result = result + ".";
                }
                result = result + this.children[i].toString();
            }
        }
        return result;
    }
}

