/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.abdera.ext;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.MimeType;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.axiom.attachments.utils.DataHandlerUtils;
import org.apache.chemistry.abdera.ext.CMISConstants;

public class CMISContent
extends ExtensibleElementWrapper {
    public CMISContent(Element internal) {
        super(internal);
    }

    public CMISContent(Factory factory, QName qname) {
        super(factory, qname);
    }

    public MimeType getMediaType() {
        String mediaTypeVal;
        MimeType type = null;
        Element mediaType = this.getFirstChild(CMISConstants.CONTENT_MEDIATYPE);
        if (mediaType != null && (mediaTypeVal = mediaType.getText()) != null) {
            try {
                type = new MimeType(mediaTypeVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return type;
    }

    public String getBase64() {
        String base64Str = null;
        Element base64 = this.getFirstChild(CMISConstants.CONTENT_BASE64);
        if (base64 != null) {
            base64Str = base64.getText();
        }
        return base64Str;
    }

    public InputStream getContentStream() throws IOException {
        MimeType type = this.getMediaType();
        String base64 = this.getBase64();
        DataHandler dh = (DataHandler)DataHandlerUtils.getDataHandlerFromText((String)base64, (String)(type != null ? type.toString() : null));
        return dh.getInputStream();
    }
}

