/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.abdera.ext;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMISProperty
extends ExtensibleElementWrapper {
    public CMISProperty(Element internal) {
        super(internal);
    }

    public CMISProperty(Factory factory, QName qname) {
        super(factory, qname);
    }

    public abstract String getType();

    public String getId() {
        return this.getAttributeValue(CMISConstants.PROPERTY_ID);
    }

    public String getDisplayName() {
        return this.getAttributeValue(CMISConstants.PROPERTY_DISPLAY_NAME);
    }

    public boolean isNull() {
        return this.getFirstChild() == null;
    }

    public boolean isMultiValued() {
        List children = this.getElements();
        return children.size() > 1;
    }

    public CMISValue getValue() {
        CMISValue child = (CMISValue)this.getFirstChild(CMISConstants.PROPERTY_VALUE);
        if (child != null) {
            return child;
        }
        return null;
    }

    public List<CMISValue> getValues() {
        return this.getElements();
    }

    public Object getNativeValue() {
        CMISValue value = this.getValue();
        return value == null ? null : value.getNativeValue();
    }

    public List<Object> getNativeValues() {
        List<CMISValue> values = this.getValues();
        ArrayList<Object> nativeValues = new ArrayList<Object>(values.size());
        for (CMISValue value : values) {
            nativeValues.add(value.getNativeValue());
        }
        return nativeValues;
    }

    public String getStringValue() {
        CMISValue value = this.getValue();
        return value == null ? null : value.getStringValue();
    }

    public BigDecimal getDecimalValue() {
        CMISValue value = this.getValue();
        return value == null ? null : value.getDecimalValue();
    }

    public int getIntegerValue() {
        CMISValue value = this.getValue();
        return value == null ? null : Integer.valueOf(value.getIntegerValue());
    }

    public boolean getBooleanValue() {
        CMISValue value = this.getValue();
        return value == null ? null : Boolean.valueOf(value.getBooleanValue());
    }

    public Date getDateValue() {
        CMISValue value = this.getValue();
        return value == null ? null : value.getDateValue();
    }

    public static class CMISPropertyBoolean
    extends CMISProperty {
        public CMISPropertyBoolean(Element internal) {
            super(internal);
        }

        public CMISPropertyBoolean(Factory factory, QName qname) {
            super(factory, qname);
        }

        public String getType() {
            return "boolean";
        }
    }

    public static class CMISPropertyDateTime
    extends CMISProperty {
        public CMISPropertyDateTime(Element internal) {
            super(internal);
        }

        public CMISPropertyDateTime(Factory factory, QName qname) {
            super(factory, qname);
        }

        public String getType() {
            return "datetime";
        }
    }

    public static class CMISPropertyDecimal
    extends CMISProperty {
        public CMISPropertyDecimal(Element internal) {
            super(internal);
        }

        public CMISPropertyDecimal(Factory factory, QName qname) {
            super(factory, qname);
        }

        public String getType() {
            return "decimal";
        }
    }

    public static class CMISPropertyHtml
    extends CMISPropertyString {
        public CMISPropertyHtml(Element internal) {
            super(internal);
        }

        public CMISPropertyHtml(Factory factory, QName qname) {
            super(factory, qname);
        }

        public String getType() {
            return "html";
        }
    }

    public static class CMISPropertyId
    extends CMISPropertyString {
        public CMISPropertyId(Element internal) {
            super(internal);
        }

        public CMISPropertyId(Factory factory, QName qname) {
            super(factory, qname);
        }

        public String getType() {
            return "id";
        }
    }

    public static class CMISPropertyInteger
    extends CMISProperty {
        public CMISPropertyInteger(Element internal) {
            super(internal);
        }

        public CMISPropertyInteger(Factory factory, QName qname) {
            super(factory, qname);
        }

        public String getType() {
            return "integer";
        }
    }

    public static class CMISPropertyString
    extends CMISProperty {
        public CMISPropertyString(Element internal) {
            super(internal);
        }

        public CMISPropertyString(Factory factory, QName qname) {
            super(factory, qname);
        }

        public String getType() {
            return "string";
        }
    }

    public static class CMISPropertyUri
    extends CMISPropertyString {
        public CMISPropertyUri(Element internal) {
            super(internal);
        }

        public CMISPropertyUri(Factory factory, QName qname) {
            super(factory, qname);
        }

        public String getType() {
            return "uri";
        }
    }
}

