/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.abdera.ext;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.chemistry.abdera.ext.CMISChoice;
import org.apache.chemistry.abdera.ext.CMISConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMISPropertyDefinition
extends ExtensibleElementWrapper {
    public CMISPropertyDefinition(Element internal) {
        super(internal);
    }

    public CMISPropertyDefinition(Factory factory, QName qname) {
        super(factory, qname);
    }

    public String getId() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_ID);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public String getLocalName() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_LOCAL_NAME);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public String getLocalNamespace() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_LOCAL_NAMESPACE);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public String getQueryName() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_QUERY_NAME);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public String getDisplayName() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_DISPLAY_NAME);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public String getDescription() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_DESCRIPTION);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public String getPropertyType() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_PROPERTY_TYPE);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public String getCardinality() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_CARDINALITY);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public String getUpdatability() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_UPDATABILITY);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public Boolean getInherited() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_INHERITED);
        if (child != null) {
            return Boolean.parseBoolean(child.getText());
        }
        return null;
    }

    public Boolean getRequired() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_REQUIRED);
        if (child != null) {
            return Boolean.parseBoolean(child.getText());
        }
        return null;
    }

    public Boolean getQueryable() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_QUERYABLE);
        if (child != null) {
            return Boolean.parseBoolean(child.getText());
        }
        return null;
    }

    public Boolean getOrderable() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_ORDERABLE);
        if (child != null) {
            return Boolean.parseBoolean(child.getText());
        }
        return null;
    }

    public Boolean getOpenChoice() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_OPEN_CHOICE);
        if (child != null) {
            return Boolean.parseBoolean(child.getText());
        }
        return null;
    }

    public String getDefaultValue() {
        Element child = this.getFirstChild(CMISConstants.PROPDEF_DEFAULT_VALUE);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public List<CMISChoice> getChoices(boolean includeNestedChoices) {
        List children = this.getElements();
        ArrayList<CMISChoice> entries = new ArrayList<CMISChoice>(children.size());
        for (Element child : children) {
            if (!(child instanceof CMISChoice)) continue;
            CMISChoice childChoice = (CMISChoice)child;
            entries.add(childChoice);
            if (!includeNestedChoices) continue;
            entries.addAll(childChoice.getChoices(true));
        }
        return entries;
    }

    public static class CMISPropertyBooleanDefinition
    extends CMISPropertyDefinition {
        public CMISPropertyBooleanDefinition(Element internal) {
            super(internal);
        }

        public CMISPropertyBooleanDefinition(Factory factory, QName qname) {
            super(factory, qname);
        }
    }

    public static class CMISPropertyDateTimeDefinition
    extends CMISPropertyDefinition {
        public CMISPropertyDateTimeDefinition(Element internal) {
            super(internal);
        }

        public CMISPropertyDateTimeDefinition(Factory factory, QName qname) {
            super(factory, qname);
        }

        public String getResolution() {
            Element child = this.getFirstChild(CMISConstants.PROPDEF_DATE_RESOLUTION);
            if (child != null) {
                return child.getText();
            }
            return null;
        }
    }

    public static class CMISPropertyDecimalDefinition
    extends CMISPropertyDefinition {
        public CMISPropertyDecimalDefinition(Element internal) {
            super(internal);
        }

        public CMISPropertyDecimalDefinition(Factory factory, QName qname) {
            super(factory, qname);
        }

        public Integer getMinValue() {
            Element child = this.getFirstChild(CMISConstants.PROPDEF_INT_MIN_VALUE);
            if (child != null) {
                return Integer.parseInt(child.getText());
            }
            return null;
        }

        public Integer getMaxValue() {
            Element child = this.getFirstChild(CMISConstants.PROPDEF_INT_MAX_VALUE);
            if (child != null) {
                return Integer.parseInt(child.getText());
            }
            return null;
        }

        public String getPrecision() {
            Element child = this.getFirstChild(CMISConstants.PROPDEF_DECIMAL_PRECISION);
            if (child != null) {
                return child.getText();
            }
            return null;
        }
    }

    public static class CMISPropertyHtmlDefinition
    extends CMISPropertyDefinition {
        public CMISPropertyHtmlDefinition(Element internal) {
            super(internal);
        }

        public CMISPropertyHtmlDefinition(Factory factory, QName qname) {
            super(factory, qname);
        }
    }

    public static class CMISPropertyIdDefinition
    extends CMISPropertyDefinition {
        public CMISPropertyIdDefinition(Element internal) {
            super(internal);
        }

        public CMISPropertyIdDefinition(Factory factory, QName qname) {
            super(factory, qname);
        }
    }

    public static class CMISPropertyIntegerDefinition
    extends CMISPropertyDefinition {
        public CMISPropertyIntegerDefinition(Element internal) {
            super(internal);
        }

        public CMISPropertyIntegerDefinition(Factory factory, QName qname) {
            super(factory, qname);
        }
    }

    public static class CMISPropertyStringDefinition
    extends CMISPropertyDefinition {
        public CMISPropertyStringDefinition(Element internal) {
            super(internal);
        }

        public CMISPropertyStringDefinition(Factory factory, QName qname) {
            super(factory, qname);
        }

        public Integer getMaxLength() {
            Element child = this.getFirstChild(CMISConstants.PROPDEF_STRING_MAX_LENGTH);
            if (child != null) {
                return Integer.parseInt(child.getText());
            }
            return null;
        }
    }

    public static class CMISPropertyUriDefinition
    extends CMISPropertyDefinition {
        public CMISPropertyUriDefinition(Element internal) {
            super(internal);
        }

        public CMISPropertyUriDefinition(Factory factory, QName qname) {
            super(factory, qname);
        }
    }
}

