/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.abdera.ext;

import java.util.ArrayList;
import java.util.List;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISPropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISTypeDefinition
extends ExtensibleElementWrapper {
    public CMISTypeDefinition(Element internal) {
        super(internal);
    }

    public CMISTypeDefinition(Factory factory) {
        super(factory, CMISConstants.TYPE_DEFINITION);
    }

    public String getId() {
        return this.getFirstChild(CMISConstants.TYPE_ID).getText();
    }

    public List<CMISPropertyDefinition> getPropertyDefinitions() {
        List elements = this.getElements();
        ArrayList<CMISPropertyDefinition> propertyDefs = new ArrayList<CMISPropertyDefinition>(elements.size());
        for (Element element : elements) {
            if (!(element instanceof CMISPropertyDefinition)) continue;
            propertyDefs.add((CMISPropertyDefinition)element);
        }
        return propertyDefs;
    }

    public CMISPropertyDefinition getPropertyDefinition(String id) {
        List elements = this.getElements();
        for (Element element : elements) {
            CMISPropertyDefinition propDef;
            if (!(element instanceof CMISPropertyDefinition) || !id.equals((propDef = (CMISPropertyDefinition)element).getId())) continue;
            return propDef;
        }
        return null;
    }

    public String getLocalName() {
        return this.getFirstChild(CMISConstants.TYPE_LOCAL_NAME).getText();
    }

    public String getLocalNamespace() {
        return this.getFirstChild(CMISConstants.TYPE_LOCAL_NAMESPACE).getText();
    }

    public String getQueryName() {
        return this.getFirstChild(CMISConstants.TYPE_QUERY_NAME).getText();
    }

    public String getDisplayName() {
        return this.getFirstChild(CMISConstants.TYPE_DISPLAY_NAME).getText();
    }

    public String getBaseId() {
        return this.getFirstChild(CMISConstants.TYPE_BASE_ID).getText();
    }

    public String getParentId() {
        return this.getFirstChild(CMISConstants.TYPE_BASE_ID).getText();
    }

    public String getDescription() {
        return this.getFirstChild(CMISConstants.TYPE_DESCRIPTION).getText();
    }

    public boolean getCreatable() {
        return Boolean.parseBoolean(this.getFirstChild(CMISConstants.TYPE_CREATABLE).getText());
    }

    public boolean getFileable() {
        return Boolean.parseBoolean(this.getFirstChild(CMISConstants.TYPE_FILEABLE).getText());
    }

    public boolean getVersionable() {
        return Boolean.parseBoolean(this.getFirstChild(CMISConstants.TYPE_VERSIONABLE).getText());
    }

    public boolean getQueryable() {
        return Boolean.parseBoolean(this.getFirstChild(CMISConstants.TYPE_QUERYABLE).getText());
    }

    public String getContentStreamAllowed() {
        return this.getFirstChild(CMISConstants.TYPE_CONTENT_STREAM_ALLOWED).getText();
    }

    public boolean getControllablePolicy() {
        return Boolean.parseBoolean(this.getFirstChild(CMISConstants.TYPE_CONTROLLABLE_POLICY).getText());
    }

    public boolean getControllableACL() {
        return Boolean.parseBoolean(this.getFirstChild(CMISConstants.TYPE_CONTROLLABLE_ACL).getText());
    }

    public boolean getFullTextIndexed() {
        return Boolean.parseBoolean(this.getFirstChild(CMISConstants.TYPE_FULL_TEXT_INDEXED).getText());
    }

    public boolean getIncludeInSupertypeQuery() {
        return Boolean.parseBoolean(this.getFirstChild(CMISConstants.TYPE_INCLUDED_IN_SUPERTYPE_QUERY).getText());
    }
}

