/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.abdera.ext;

import java.util.Map;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.i18n.templates.Template;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ElementWrapper;
import org.apache.chemistry.abdera.ext.CMISConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISUriTemplate
extends ElementWrapper {
    public CMISUriTemplate(Element internal) {
        super(internal);
    }

    public CMISUriTemplate(Factory factory) {
        super(factory, CMISConstants.URI_TEMPLATE);
    }

    public String getTemplate() {
        Element child = this.getFirstChild(CMISConstants.URI_TEMPLATE_PATH);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public String getType() {
        Element child = this.getFirstChild(CMISConstants.URI_TEMPLATE_TYPE);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public String getMediaType() {
        Element child = this.getFirstChild(CMISConstants.URI_TEMPLATE_MEDIATYPE);
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public IRI generateUri(Map<String, Object> variables) {
        String template = this.getTemplate();
        if (template != null) {
            Template uriTemplate = new Template(template);
            return new IRI(uriTemplate.expand(variables));
        }
        return null;
    }
}

