/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.RelationshipTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.CmisExtensionElementImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public abstract class CMISAbstractDictionaryService
extends AbstractLifecycleBean
implements CMISDictionaryService,
DictionaryListener {
    protected static final Log logger = LogFactory.getLog(CMISAbstractDictionaryService.class);
    public static final String ALFRESCO_EXTENSION_NAMESPACE = "http://www.alfresco.org";
    public static final String MANDATORY_ASPECTS = "mandatoryAspects";
    public static final String MANDATORY_ASPECT = "mandatoryAspect";
    private DictionaryDAO dictionaryDAO;
    protected DictionaryService dictionaryService;
    protected CMISMapping cmisMapping;
    protected PropertyAccessorMapping accessorMapping;
    protected PropertyLuceneBuilderMapping luceneBuilderMapping;
    private final ReentrantReadWriteLock registryLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock registryWriteLock = this.registryLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock registryReadLock = this.registryLock.readLock();
    private SimpleCache<String, DictionaryRegistry> singletonCache;
    private final String KEY_OPENCMIS_DICTIONARY_REGISTRY = "key.openCmisDictionaryRegistry";
    protected String key_opencmis_dictionary_registry = null;

    public void setCmisMapping(CMISMapping cmisMapping) {
        this.cmisMapping = cmisMapping;
    }

    public void setPropertyAccessorMapping(PropertyAccessorMapping accessorMapping) {
        this.accessorMapping = accessorMapping;
    }

    public void setPropertyLuceneBuilderMapping(PropertyLuceneBuilderMapping luceneBuilderMapping) {
        this.luceneBuilderMapping = luceneBuilderMapping;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setSingletonCache(SimpleCache<String, DictionaryRegistry> singletonCache) {
        this.singletonCache = singletonCache;
    }

    protected DictionaryRegistry getRegistry() {
        return this.getRegistryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DictionaryRegistry getRegistryImpl() {
        DictionaryRegistry registry = null;
        this.registryReadLock.lock();
        try {
            if (this.key_opencmis_dictionary_registry != null) {
                registry = this.singletonCache.get(this.key_opencmis_dictionary_registry);
            }
        }
        finally {
            this.registryReadLock.unlock();
        }
        if (registry == null) {
            this.init();
            registry = this.singletonCache.get(this.key_opencmis_dictionary_registry);
        }
        return registry;
    }

    @Override
    public TypeDefinitionWrapper findType(String typeId) {
        return this.getRegistry().typeDefsByTypeId.get(typeId);
    }

    @Override
    public boolean isExcluded(QName qname) {
        return this.cmisMapping.isExcluded(qname);
    }

    @Override
    public TypeDefinitionWrapper findTypeForClass(QName clazz, BaseTypeId ... matchingScopes) {
        TypeDefinitionWrapper matchingTypeDef;
        boolean scopeByRelationship = false;
        for (BaseTypeId scope : matchingScopes) {
            if (scope != BaseTypeId.CMIS_RELATIONSHIP) continue;
            scopeByRelationship = true;
            break;
        }
        clazz = this.cmisMapping.getCmisType(clazz);
        TypeDefinitionWrapper typeDef = null;
        if (scopeByRelationship) {
            typeDef = this.getRegistry().assocDefsByQName.get(clazz);
        } else {
            typeDef = this.getRegistry().typeDefsByQName.get(clazz);
            if (typeDef == null) {
                typeDef = this.getRegistry().assocDefsByQName.get(clazz);
            }
        }
        TypeDefinitionWrapper typeDefinitionWrapper = matchingTypeDef = matchingScopes.length == 0 ? typeDef : null;
        if (typeDef != null) {
            for (BaseTypeId scope : matchingScopes) {
                if (typeDef.getBaseTypeId() != scope) continue;
                matchingTypeDef = typeDef;
                break;
            }
        }
        return matchingTypeDef;
    }

    @Override
    public TypeDefinitionWrapper findNodeType(QName clazz) {
        return this.getRegistry().typeDefsByQName.get(this.cmisMapping.getCmisType(clazz));
    }

    @Override
    public TypeDefinitionWrapper findAssocType(QName clazz) {
        return this.getRegistry().assocDefsByQName.get(this.cmisMapping.getCmisType(clazz));
    }

    @Override
    public TypeDefinitionWrapper findTypeByQueryName(String queryName) {
        return this.getRegistry().typeDefsByQueryName.get(ISO9075.lowerCaseEncodedSQL(queryName));
    }

    public QName getAlfrescoClass(QName name) {
        return this.cmisMapping.getAlfrescoClass(name);
    }

    @Override
    public PropertyDefinitionWrapper findProperty(String propId) {
        return this.getRegistry().propDefbyPropId.get(propId);
    }

    @Override
    public PropertyDefinitionWrapper findPropertyByQueryName(String queryName) {
        return this.getRegistry().propDefbyQueryName.get(ISO9075.lowerCaseEncodedSQL(queryName));
    }

    @Override
    public List<TypeDefinitionWrapper> getBaseTypes() {
        return Collections.unmodifiableList(this.getRegistry().baseTypes);
    }

    @Override
    public List<TypeDefinitionWrapper> getAllTypes() {
        return Collections.unmodifiableList(new ArrayList<AbstractTypeDefinitionWrapper>(this.getRegistry().typeDefsByTypeId.values()));
    }

    @Override
    public PropertyType findDataType(QName dataType) {
        return this.cmisMapping.getDataType(dataType);
    }

    @Override
    public QName findAlfrescoDataType(PropertyType propertyType) {
        return this.cmisMapping.getAlfrescoDataType(propertyType);
    }

    protected abstract void createDefinitions(DictionaryRegistry var1);

    private void addTypeExtensions(DictionaryRegistry registry, TypeDefinitionWrapper td) {
        List<AspectDefinition> defaultAspects;
        QName classQName = td.getAlfrescoClass();
        ClassDefinition classDef = this.dictionaryService.getClass(classQName);
        if (classDef != null && (defaultAspects = classDef.getDefaultAspects(true)) != null && defaultAspects.size() > 0) {
            ArrayList<CmisExtensionElementImpl> mandatoryAspectsExtensions = new ArrayList<CmisExtensionElementImpl>();
            for (AspectDefinition aspectDef : defaultAspects) {
                QName aspectQName = aspectDef.getName();
                TypeDefinitionWrapper aspectType = registry.typeDefsByQName.get(this.cmisMapping.getCmisType(aspectQName));
                if (aspectType == null) continue;
                mandatoryAspectsExtensions.add(new CmisExtensionElementImpl(ALFRESCO_EXTENSION_NAMESPACE, MANDATORY_ASPECT, null, aspectType.getTypeId()));
            }
            if (!mandatoryAspectsExtensions.isEmpty()) {
                td.getTypeDefinition(true).setExtensions(Collections.singletonList(new CmisExtensionElementImpl(ALFRESCO_EXTENSION_NAMESPACE, MANDATORY_ASPECTS, null, mandatoryAspectsExtensions)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        this.registryWriteLock.lock();
        try {
            this.key_opencmis_dictionary_registry = "key.openCmisDictionaryRegistry." + this.cmisMapping.getCmisVersion().toString();
            DictionaryRegistry registry = new DictionaryRegistry();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Creating type definitions...");
            }
            this.createDefinitions(registry);
            for (AbstractTypeDefinitionWrapper objectTypeDef : registry.typeDefsByTypeId.values()) {
                objectTypeDef.connectParentAndSubTypes(this.cmisMapping, registry, this.dictionaryService);
            }
            for (AbstractTypeDefinitionWrapper typeDef : registry.typeDefsByTypeId.values()) {
                if (typeDef.getTypeDefinition(false).getParentTypeId() != null) continue;
                registry.baseTypes.add(typeDef);
                typeDef.resolveInheritance(this.cmisMapping, registry, this.dictionaryService);
            }
            for (AbstractTypeDefinitionWrapper typeDef : registry.typeDefsByTypeId.values()) {
                registry.registerPropertyDefinitions(typeDef);
            }
            for (AbstractTypeDefinitionWrapper typeDef : registry.typeDefsByTypeId.values()) {
                typeDef.assertComplete();
                this.addTypeExtensions(registry, typeDef);
            }
            this.singletonCache.put(this.key_opencmis_dictionary_registry, registry);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Initialized CMIS Dictionary. Types:" + registry.typeDefsByTypeId.size() + ", Base Types:" + registry.baseTypes.size()));
            }
        }
        finally {
            this.registryWriteLock.unlock();
        }
    }

    @Override
    public void onDictionaryInit() {
    }

    @Override
    public void afterDictionaryInit() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterDictionaryDestroy() {
        this.registryWriteLock.lock();
        try {
            this.singletonCache.remove(this.key_opencmis_dictionary_registry);
        }
        finally {
            this.registryWriteLock.unlock();
        }
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.afterDictionaryInit();
        if (this.dictionaryDAO != null) {
            this.dictionaryDAO.register(this);
        } else {
            logger.error((Object)"DictionaryDAO is null - hence CMIS Dictionary not registered for updates");
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public String getCmisTypeId(QName classQName) {
        return this.cmisMapping.getCmisTypeId(classQName);
    }

    public class DictionaryRegistry {
        Map<QName, TypeDefinitionWrapper> typeDefsByQName = new HashMap<QName, TypeDefinitionWrapper>();
        Map<QName, TypeDefinitionWrapper> assocDefsByQName = new HashMap<QName, TypeDefinitionWrapper>();
        Map<String, AbstractTypeDefinitionWrapper> typeDefsByTypeId = new HashMap<String, AbstractTypeDefinitionWrapper>();
        Map<String, TypeDefinitionWrapper> typeDefsByQueryName = new HashMap<String, TypeDefinitionWrapper>();
        List<TypeDefinitionWrapper> baseTypes = new ArrayList<TypeDefinitionWrapper>();
        Map<String, PropertyDefinitionWrapper> propDefbyPropId = new HashMap<String, PropertyDefinitionWrapper>();
        Map<String, PropertyDefinitionWrapper> propDefbyQueryName = new HashMap<String, PropertyDefinitionWrapper>();

        public void registerTypeDefinition(AbstractTypeDefinitionWrapper typeDef) {
            AbstractTypeDefinitionWrapper existingTypeDef = this.typeDefsByTypeId.get(typeDef.getTypeId());
            if (existingTypeDef != null) {
                throw new AlfrescoRuntimeException("Type " + typeDef.getTypeId() + " already registered");
            }
            this.typeDefsByTypeId.put(typeDef.getTypeId(), typeDef);
            QName typeQName = typeDef.getAlfrescoName();
            if (typeQName != null) {
                if (typeDef instanceof RelationshipTypeDefintionWrapper && !typeDef.isBaseType()) {
                    this.assocDefsByQName.put(typeQName, typeDef);
                } else {
                    this.typeDefsByQName.put(typeQName, typeDef);
                }
            }
            this.typeDefsByQueryName.put(typeDef.getTypeDefinition(false).getQueryName(), typeDef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered type " + typeDef.getTypeId() + " (scope=" + typeDef.getBaseTypeId() + ")"));
                logger.debug((Object)(" QName: " + typeDef.getAlfrescoName()));
                logger.debug((Object)(" Table: " + typeDef.getTypeDefinition(false).getQueryName()));
                logger.debug((Object)(" Action Evaluators: " + typeDef.getActionEvaluators().size()));
            }
        }

        public void registerPropertyDefinitions(AbstractTypeDefinitionWrapper typeDef) {
            for (PropertyDefinitionWrapper propDef : typeDef.getProperties()) {
                if (propDef.getPropertyDefinition().isInherited().booleanValue()) continue;
                this.propDefbyPropId.put(propDef.getPropertyId(), propDef);
                this.propDefbyQueryName.put(propDef.getPropertyDefinition().getQueryName(), propDef);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DictionaryRegistry[");
            builder.append("Types=").append(this.typeDefsByTypeId.size()).append(", ");
            builder.append("Base Types=").append(this.baseTypes.size()).append(", ");
            builder.append("]");
            return builder.toString();
        }
    }
}

