/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.Collection;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.opencmis.dictionary.DocumentTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.FolderTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.PolicyTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.RelationshipTypeDefintionWrapper;
import org.alfresco.opencmis.dictionary.SecondaryTypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;

public class CMISStrictDictionaryService
extends CMISAbstractDictionaryService {
    public static final String DEFAULT = "DEFAULT_DICTIONARY";

    @Override
    protected void createDefinitions(CMISAbstractDictionaryService.DictionaryRegistry registry) {
        this.createTypeDefs(registry, this.dictionaryService.getAllTypes());
        this.createAssocDefs(registry, this.dictionaryService.getAllAssociations());
        this.createTypeDefs(registry, this.dictionaryService.getAllAspects());
    }

    private void createTypeDefs(CMISAbstractDictionaryService.DictionaryRegistry registry, Collection<QName> classQNames) {
        for (QName classQName : classQNames) {
            if (this.cmisMapping.isRemappedType(classQName)) continue;
            ClassDefinition classDef = this.dictionaryService.getClass(classQName);
            String typeId = null;
            AbstractTypeDefinitionWrapper objectTypeDef = null;
            if (this.cmisMapping.isValidCmisDocument(classQName)) {
                typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_DOCUMENT, classQName);
                objectTypeDef = new DocumentTypeDefinitionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, classDef);
            } else if (this.cmisMapping.isValidCmisFolder(classQName)) {
                typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_FOLDER, classQName);
                objectTypeDef = new FolderTypeDefintionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, classDef);
            } else if (this.cmisMapping.getCmisVersion().equals((Object)CmisVersion.CMIS_1_1) && this.cmisMapping.isValidCmisSecondaryType(classQName)) {
                typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_SECONDARY, classQName);
                objectTypeDef = new SecondaryTypeDefinitionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, classDef);
            } else if (this.cmisMapping.isValidCmisPolicy(classQName)) {
                typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_POLICY, classQName);
                objectTypeDef = new PolicyTypeDefintionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, classDef);
            }
            if (objectTypeDef == null) continue;
            registry.registerTypeDefinition(objectTypeDef);
        }
    }

    private void createAssocDefs(CMISAbstractDictionaryService.DictionaryRegistry registry, Collection<QName> classQNames) {
        String typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_RELATIONSHIP, CMISMapping.RELATIONSHIP_QNAME);
        ClassDefinition classDef = this.dictionaryService.getClass(CMISMapping.RELATIONSHIP_QNAME);
        if (classDef == null) {
            if (classQNames.size() != 0) {
                logger.warn((Object)("Unexpected - no class for " + CMISMapping.RELATIONSHIP_QNAME + " - cannot create assocDefs for: " + classQNames));
            }
            return;
        }
        RelationshipTypeDefintionWrapper objectTypeDef = new RelationshipTypeDefintionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, classDef);
        registry.registerTypeDefinition(objectTypeDef);
        for (QName classQName : classQNames) {
            if (!this.cmisMapping.isValidCmisRelationship(classQName)) continue;
            AssociationDefinition assocDef = this.dictionaryService.getAssociation(classQName);
            typeId = this.cmisMapping.getCmisTypeId(BaseTypeId.CMIS_RELATIONSHIP, classQName);
            objectTypeDef = new RelationshipTypeDefintionWrapper(this.cmisMapping, this.accessorMapping, this.luceneBuilderMapping, typeId, this.dictionaryService, assocDef);
            registry.registerTypeDefinition(objectTypeDef);
        }
    }
}

