/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.CMISUtils;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.ShadowTypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;

public class FolderTypeDefintionWrapper
extends ShadowTypeDefinitionWrapper {
    private static final long serialVersionUID = 1L;
    private FolderTypeDefinitionImpl typeDef;
    private FolderTypeDefinitionImpl typeDefInclProperties;

    public FolderTypeDefintionWrapper(CMISMapping cmisMapping, PropertyAccessorMapping accessorMapping, PropertyLuceneBuilderMapping luceneBuilderMapping, String typeId, DictionaryService dictionaryService, ClassDefinition cmisClassDef) {
        this.alfrescoName = cmisClassDef.getName();
        this.alfrescoClass = cmisMapping.getAlfrescoClass(this.alfrescoName);
        this.typeDef = new FolderTypeDefinitionImpl();
        this.typeDef.setBaseTypeId(BaseTypeId.CMIS_FOLDER);
        this.typeDef.setId(typeId);
        this.typeDef.setLocalName(this.alfrescoName.getLocalName());
        this.typeDef.setLocalNamespace(this.alfrescoName.getNamespaceURI());
        boolean isSystemFolder = false;
        if (BaseTypeId.CMIS_FOLDER.value().equals(typeId)) {
            this.typeDef.setQueryName(ISO9075.encodeSQL(typeId));
            this.typeDef.setParentTypeId(null);
        } else {
            this.typeDef.setQueryName(ISO9075.encodeSQL(cmisMapping.buildPrefixEncodedString(this.alfrescoName)));
            QName parentQName = cmisMapping.getCmisType(cmisClassDef.getParentName());
            if (cmisMapping.isValidCmisFolder(parentQName)) {
                this.typeDef.setParentTypeId(cmisMapping.getCmisTypeId(BaseTypeId.CMIS_FOLDER, parentQName));
            }
            if (this.alfrescoName.equals(ContentModel.TYPE_SYSTEM_FOLDER) || cmisMapping.getDictionaryService().isSubClass(this.alfrescoName, ContentModel.TYPE_SYSTEM_FOLDER)) {
                isSystemFolder = true;
            }
        }
        this.typeDef.setDisplayName(cmisClassDef.getTitle(dictionaryService) != null ? cmisClassDef.getTitle(dictionaryService) : typeId);
        this.typeDef.setDescription(cmisClassDef.getDescription(dictionaryService) != null ? cmisClassDef.getDescription(dictionaryService) : this.typeDef.getDisplayName());
        this.typeDef.setIsCreatable(Boolean.valueOf(!isSystemFolder));
        this.typeDef.setIsQueryable(Boolean.valueOf(true));
        this.typeDef.setIsFulltextIndexed(Boolean.valueOf(true));
        this.typeDef.setIsControllablePolicy(Boolean.valueOf(false));
        this.typeDef.setIsControllableAcl(Boolean.valueOf(true));
        this.typeDef.setIsIncludedInSupertypeQuery(cmisClassDef.getIncludedInSuperTypeQuery());
        this.typeDef.setIsFileable(Boolean.valueOf(true));
        this.typeDefInclProperties = CMISUtils.copy(this.typeDef);
        this.setTypeDefinition((AbstractTypeDefinition)this.typeDef, (AbstractTypeDefinition)this.typeDefInclProperties);
        this.createOwningPropertyDefinitions(cmisMapping, accessorMapping, luceneBuilderMapping, dictionaryService, cmisClassDef);
        this.createActionEvaluators(accessorMapping, BaseTypeId.CMIS_FOLDER);
    }
}

