/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.AbstractLuceneBuilder;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ObjectTypeIdLuceneBuilder
extends AbstractLuceneBuilder {
    private CMISDictionaryService cmisDictionaryService;

    public ObjectTypeIdLuceneBuilder(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    @Override
    public String getLuceneFieldName() {
        return "EXACTTYPE";
    }

    private String getValueAsString(Serializable value) {
        String asString = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
        return asString;
    }

    @Override
    public Query buildLuceneEquality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        TypeDefinitionWrapper type = this.cmisDictionaryService.findType(stringValue);
        return lqp.getFieldQuery(field, type.getAlfrescoClass().toString(), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneExists(AbstractLuceneQueryParser lqp, Boolean not) throws ParseException {
        if (not.booleanValue()) {
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        return new MatchAllDocsQuery();
    }

    @Override
    public Query buildLuceneGreaterThan(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CmisInvalidArgumentException("Property cmis:objectTypeId can not be used in a 'greater than' comparison");
    }

    @Override
    public Query buildLuceneGreaterThanOrEquals(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CmisInvalidArgumentException("Property cmis:objectTypeId can not be used in a 'greater than or equals' comparison");
    }

    @Override
    public Query buildLuceneIn(AbstractLuceneQueryParser lqp, Collection<Serializable> values, Boolean not, PredicateMode mode) throws ParseException {
        String field = this.getLuceneFieldName();
        ArrayList<String> asStrings = new ArrayList<String>(values.size());
        for (Serializable value : values) {
            String stringValue = this.getValueAsString(value);
            TypeDefinitionWrapper type = this.cmisDictionaryService.findType(stringValue);
            asStrings.add(type.getAlfrescoClass().toString());
        }
        if (asStrings.size() == 0) {
            if (not.booleanValue()) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        if (asStrings.size() == 1) {
            String value = (String)asStrings.iterator().next();
            if (not.booleanValue()) {
                return lqp.getDoesNotMatchFieldQuery(field, value, AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            }
            return lqp.getFieldQuery(field, value, AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        if (not.booleanValue()) {
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        }
        for (String value : asStrings) {
            Query any = lqp.getFieldQuery(field, value, AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            if (not.booleanValue()) {
                booleanQuery.add(any, BooleanClause.Occur.MUST_NOT);
                continue;
            }
            booleanQuery.add(any, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    @Override
    public Query buildLuceneInequality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        TypeDefinitionWrapper type = this.cmisDictionaryService.findType(stringValue);
        return lqp.getDoesNotMatchFieldQuery(field, type.getAlfrescoClass().toString(), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneLessThan(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CmisInvalidArgumentException("Property cmis:objectTypeId can not be used in a 'less than' comparison");
    }

    @Override
    public Query buildLuceneLessThanOrEquals(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CmisInvalidArgumentException("Property cmis:objectTypeId can not be used in a 'less than or equals' comparison");
    }

    @Override
    public Query buildLuceneLike(AbstractLuceneQueryParser lqp, Serializable value, Boolean not) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        TypeDefinitionWrapper type = this.cmisDictionaryService.findType(stringValue);
        String typeQName = type.getAlfrescoClass().toString();
        if (not.booleanValue()) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            booleanQuery.add(lqp.getLikeQuery(field, typeQName, AnalysisMode.IDENTIFIER), BooleanClause.Occur.MUST_NOT);
            return booleanQuery;
        }
        return lqp.getLikeQuery(field, typeQName, AnalysisMode.IDENTIFIER);
    }

    @Override
    public String getLuceneSortField(AbstractLuceneQueryParser lqp) {
        return this.getLuceneFieldName();
    }
}

