/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.analysis.AnalysisException;
import org.alfresco.repo.search.impl.lucene.analysis.MLTokenDuplicator;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.springframework.extensions.surf.util.I18NUtil;

public class MLAnalayser
extends Analyzer {
    private static Log s_logger = LogFactory.getLog(MLAnalayser.class);
    private DictionaryService dictionaryService;
    private HashMap<Pair<String, Locale>, Analyzer> analysers = new HashMap();
    private MLAnalysisMode mlAnalaysisMode;
    private Analyzer analyzer;

    public MLAnalayser(DictionaryService dictionaryService, MLAnalysisMode mlAnalaysisMode) {
        this(dictionaryService, mlAnalaysisMode, null);
    }

    public MLAnalayser(DictionaryService dictionaryService, MLAnalysisMode mlAnalaysisMode, Analyzer analyzer) {
        this.dictionaryService = dictionaryService;
        this.mlAnalaysisMode = mlAnalaysisMode;
        this.analyzer = analyzer;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        BufferedReader breader = new BufferedReader(reader);
        breader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            if (!breader.markSupported()) {
                throw new AnalysisException("Multilingual tokenisation requires a reader that supports marks and reset");
            }
            breader.mark(100);
            StringBuilder builder = new StringBuilder();
            if (breader.read() == 0) {
                char c;
                String language = "";
                String country = "";
                String varient = "";
                int count = 0;
                while ((c = (char)breader.read()) != '\u0000') {
                    if (count++ > 99) {
                        breader.reset();
                        return this.getDefaultAnalyser(fieldName).tokenStream(fieldName, (Reader)breader);
                    }
                    if (c == '_') {
                        if (language.length() == 0) {
                            language = builder.toString();
                        } else if (country.length() == 0) {
                            country = builder.toString();
                        } else if (varient.length() == 0) {
                            varient = builder.toString();
                        } else {
                            breader.reset();
                            return this.getDefaultAnalyser(fieldName).tokenStream(fieldName, (Reader)breader);
                        }
                        builder = new StringBuilder();
                        continue;
                    }
                    builder.append(c);
                }
                if (builder.length() > 0) {
                    if (language.length() == 0) {
                        language = builder.toString();
                    } else if (country.length() == 0) {
                        country = builder.toString();
                    } else if (varient.length() == 0) {
                        varient = builder.toString();
                    } else {
                        breader.reset();
                        return this.getDefaultAnalyser(fieldName).tokenStream(fieldName, (Reader)breader);
                    }
                }
                Locale locale = new Locale(language, country, varient);
                return new MLTokenDuplicator(this.getAnalyser(fieldName, locale).tokenStream(fieldName, (Reader)breader), locale, breader, this.mlAnalaysisMode);
            }
            breader.reset();
            return this.getDefaultAnalyser(fieldName).tokenStream(fieldName, (Reader)breader);
        }
        catch (IOException io) {
            try {
                breader.reset();
            }
            catch (IOException e) {
                throw new AnalysisException("Failed to reset buffered reader - token stream will be invalid", e);
            }
            return this.getDefaultAnalyser(fieldName).tokenStream(fieldName, (Reader)breader);
        }
    }

    private Analyzer getDefaultAnalyser(String fieldName) {
        return this.getAnalyser(fieldName, I18NUtil.getLocale());
    }

    private Analyzer getAnalyser(String fieldName, Locale locale) {
        if (this.analyzer != null) {
            return this.analyzer;
        }
        Pair key = new Pair((Object)fieldName, (Object)locale);
        Analyzer localeSpecificAnalyzer = this.analysers.get(key);
        if (localeSpecificAnalyzer == null) {
            localeSpecificAnalyzer = this.findAnalyser((Pair<String, Locale>)key);
        }
        return localeSpecificAnalyzer;
    }

    private Analyzer findAnalyser(Pair<String, Locale> key) {
        Analyzer localeSpecificAnalyzer = this.loadAnalyzer(key);
        this.analysers.put(key, localeSpecificAnalyzer);
        return localeSpecificAnalyzer;
    }

    private Analyzer loadAnalyzer(Pair<String, Locale> key) {
        String analyserClassName;
        QName propertyQName = QName.createQName(((String)key.getFirst()).substring(1));
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
        if (propertyDef == null) {
            DataTypeDefinition dataType = this.dictionaryService.getDataType(DataTypeDefinition.TEXT);
            analyserClassName = dataType.resolveAnalyserClassName((Locale)key.getSecond());
        } else {
            analyserClassName = propertyDef.resolveAnalyserClassName((Locale)key.getSecond());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Loading " + analyserClassName + " for " + key));
        }
        try {
            Class<?> clazz = Class.forName(analyserClassName);
            Analyzer localeSpecificAnalyzer = (Analyzer)clazz.newInstance();
            return localeSpecificAnalyzer;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load analyser" + analyserClassName);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to load analyser" + analyserClassName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to load analyser" + analyserClassName);
        }
    }
}

