/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import java.io.IOException;
import org.alfresco.repo.search.impl.lucene.query.AbstractStructuredFieldPosition;

public class AnyStructuredFieldPosition
extends AbstractStructuredFieldPosition {
    public AnyStructuredFieldPosition(String termText) {
        super(termText, true, false);
        if (termText == null) {
            this.setTerminal(false);
        }
    }

    public AnyStructuredFieldPosition() {
        super(null, false, false);
    }

    @Override
    public int matches(int start, int end, int offset) throws IOException {
        if (this.getCachingTermPositions() != null) {
            this.setTerminal(true);
            int realPosition = 0;
            int adjustedPosition = 0;
            this.getCachingTermPositions().reset();
            int count = this.getCachingTermPositions().freq();
            for (int i = 0; i < count; ++i) {
                realPosition = this.getCachingTermPositions().nextPosition();
                adjustedPosition = realPosition - start;
                if (end != -1 && realPosition > end) {
                    return -1;
                }
                if (adjustedPosition <= offset) continue;
                return adjustedPosition;
            }
        } else {
            this.setTerminal(false);
            return offset;
        }
        return -1;
    }

    @Override
    public String getDescription() {
        return "Any";
    }
}

