/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.impl.functions.Child;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;

public class LuceneChild
extends Child
implements LuceneQueryBuilderComponent {
    private StoreRef getStore(LuceneQueryBuilderContext luceneContext) {
        ArrayList<StoreRef> stores = luceneContext.getLuceneQueryParser().getSearchParameters().getStores();
        if (stores.size() < 1) {
            return StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        }
        return stores.get(0);
    }

    @Override
    public Query addComponent(Set<String> selectors, Map<String, Argument> functionArgs, LuceneQueryBuilderContext luceneContext, FunctionEvaluationContext functionContext) throws ParseException {
        NodeRef nodeRef;
        AbstractLuceneQueryParser lqp = luceneContext.getLuceneQueryParser();
        Argument argument = functionArgs.get("Parent");
        String id = (String)((Object)argument.getValue(functionContext));
        argument = functionArgs.get("Selector");
        if (argument != null) {
            String selector = (String)((Object)argument.getValue(functionContext));
            if (!selectors.contains(selector)) {
                throw new QueryModelException("Unkown selector " + selector);
            }
        } else if (selectors.size() > 1) {
            throw new QueryModelException("Selector must be specified for child constraint (IN_FOLDER) and join");
        }
        if (NodeRef.isNodeRef(id)) {
            nodeRef = new NodeRef(id);
        } else {
            StoreRef storeRef = this.getStore(luceneContext);
            nodeRef = new NodeRef(storeRef, id);
        }
        Query query = lqp.getFieldQuery("PARENT", nodeRef.toString());
        return query;
    }
}

