/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.CMISUtils;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.BasePropertyDefintionWrapper;
import org.alfresco.opencmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.SecondaryTypeDefinitionImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SecondaryTypeDefinitionWrapper
extends AbstractTypeDefinitionWrapper {
    private static final long serialVersionUID = 1L;
    protected static final Log logger = LogFactory.getLog(SecondaryTypeDefinitionWrapper.class);
    private SecondaryTypeDefinitionImpl typeDef;
    private SecondaryTypeDefinitionImpl typeDefInclProperties;

    public SecondaryTypeDefinitionWrapper(CMISMapping cmisMapping, PropertyAccessorMapping propertyAccessorMapping, PropertyLuceneBuilderMapping luceneBuilderMapping, String typeId, DictionaryService dictionaryService, ClassDefinition cmisClassDef) {
        this.alfrescoName = cmisClassDef.getName();
        this.alfrescoClass = cmisMapping.getAlfrescoClass(this.alfrescoName);
        this.typeDef = new SecondaryTypeDefinitionImpl();
        this.typeDef.setBaseTypeId(BaseTypeId.CMIS_SECONDARY);
        this.typeDef.setId(typeId);
        this.typeDef.setLocalName(this.alfrescoName.getLocalName());
        this.typeDef.setLocalNamespace(this.alfrescoName.getNamespaceURI());
        if (BaseTypeId.CMIS_SECONDARY.value().equals(typeId)) {
            this.typeDef.setQueryName(ISO9075.encodeSQL(typeId));
            this.typeDef.setParentTypeId(null);
        } else {
            this.typeDef.setQueryName(ISO9075.encodeSQL(cmisMapping.buildPrefixEncodedString(this.alfrescoName)));
            QName parentQName = cmisMapping.getCmisType(cmisClassDef.getParentName());
            if (parentQName == null) {
                this.typeDef.setParentTypeId(cmisMapping.getCmisTypeId(CMISMapping.SECONDARY_TYPES_QNAME));
            } else if (cmisMapping.isValidCmisSecondaryType(parentQName)) {
                this.typeDef.setParentTypeId(cmisMapping.getCmisTypeId(BaseTypeId.CMIS_SECONDARY, parentQName));
            } else {
                throw new IllegalStateException("The CMIS type model should ignore aspects that inherit from excluded aspects");
            }
        }
        this.typeDef.setDisplayName(cmisClassDef.getTitle(dictionaryService) != null ? cmisClassDef.getTitle(dictionaryService) : typeId);
        this.typeDef.setDescription(cmisClassDef.getDescription(dictionaryService) != null ? cmisClassDef.getDescription(dictionaryService) : this.typeDef.getDisplayName());
        this.typeDef.setIsCreatable(Boolean.valueOf(false));
        this.typeDef.setIsQueryable(Boolean.valueOf(true));
        this.typeDef.setIsFulltextIndexed(Boolean.valueOf(true));
        this.typeDef.setIsControllablePolicy(Boolean.valueOf(false));
        this.typeDef.setIsControllableAcl(Boolean.valueOf(false));
        this.typeDef.setIsIncludedInSupertypeQuery(cmisClassDef.getIncludedInSuperTypeQuery());
        this.typeDef.setIsFileable(Boolean.valueOf(false));
        this.typeDefInclProperties = CMISUtils.copy(this.typeDef);
        this.setTypeDefinition((AbstractTypeDefinition)this.typeDef, (AbstractTypeDefinition)this.typeDefInclProperties);
        this.createOwningPropertyDefinitions(cmisMapping, propertyAccessorMapping, luceneBuilderMapping, dictionaryService, cmisClassDef);
        this.createActionEvaluators(propertyAccessorMapping, BaseTypeId.CMIS_SECONDARY);
    }

    @Override
    public void connectParentAndSubTypes(CMISMapping cmisMapping, CMISAbstractDictionaryService.DictionaryRegistry registry, DictionaryService dictionaryService) {
        if (this.typeDef.getParentTypeId() != null) {
            this.parent = registry.typeDefsByTypeId.get(this.typeDef.getParentTypeId());
        } else {
            if (!this.isBaseType()) {
                throw new AlfrescoRuntimeException("Type " + this.typeDef.getId() + " has no parent!");
            }
            this.parent = null;
        }
        this.children = new ArrayList();
        Collection<Object> childrenNames = null;
        if (this.isBaseType()) {
            childrenNames = new ArrayList();
            String aspectsTypeId = cmisMapping.getCmisTypeId(CMISMapping.SECONDARY_TYPES_QNAME);
            for (AbstractTypeDefinitionWrapper tdw : registry.typeDefsByTypeId.values()) {
                String parentId = tdw.getTypeDefinition(false).getParentTypeId();
                if (parentId == null || !parentId.equals(aspectsTypeId)) continue;
                childrenNames.add(tdw.getAlfrescoName());
            }
        } else {
            childrenNames = dictionaryService.getSubAspects(cmisMapping.getAlfrescoClass(this.getAlfrescoName()), false);
        }
        for (QName qName : childrenNames) {
            if (cmisMapping.isValidCmisSecondaryType(qName)) {
                TypeDefinitionWrapper child = registry.typeDefsByQName.get(qName);
                if (child == null) {
                    throw new AlfrescoRuntimeException("Failed to retrieve sub type for type id " + qName + " for parent type " + this.getAlfrescoName() + "!");
                }
                this.children.add(child);
                continue;
            }
            logger.info((Object)("Not a secondary type: " + qName));
        }
    }

    @Override
    public void resolveInheritance(CMISMapping cmisMapping, CMISAbstractDictionaryService.DictionaryRegistry registry, DictionaryService dictionaryService) {
        if (this.parent != null) {
            for (PropertyDefinitionWrapper propDef : this.parent.getProperties()) {
                if (this.propertiesById.containsKey(propDef.getPropertyId())) continue;
                PropertyDefinition alfrescoPropDef = dictionaryService.getProperty(propDef.getOwningType().getAlfrescoName(), propDef.getAlfrescoName());
                org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition<?> propertyDefintion = this.createPropertyDefinition(cmisMapping, propDef.getPropertyId(), alfrescoPropDef.getName(), dictionaryService, alfrescoPropDef, true);
                if (propertyDefintion == null) continue;
                this.registerProperty(new BasePropertyDefintionWrapper(propertyDefintion, alfrescoPropDef.getName(), propDef.getOwningType(), propDef.getPropertyAccessor(), propDef.getPropertyLuceneBuilder()));
            }
        }
        for (TypeDefinitionWrapper child : this.children) {
            if (!(child instanceof AbstractTypeDefinitionWrapper)) continue;
            ((AbstractTypeDefinitionWrapper)child).resolveInheritance(cmisMapping, registry, dictionaryService);
        }
    }
}

