/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.Collection;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.AbstractLuceneBuilder;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class BaseTypeIdLuceneBuilder
extends AbstractLuceneBuilder {
    private CMISDictionaryService dictionaryService;

    public BaseTypeIdLuceneBuilder(CMISDictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public Query buildLuceneEquality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        return lqp.getFieldQuery("TYPE", this.getType(this.getValueAsString(value)), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneInequality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        return lqp.getDoesNotMatchFieldQuery("TYPE", this.getType(this.getValueAsString(value)), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneIn(AbstractLuceneQueryParser lqp, Collection<Serializable> values, Boolean not, PredicateMode mode) throws ParseException {
        String field = "TYPE";
        Collection<String> asStrings = DefaultTypeConverter.INSTANCE.convert(String.class, values);
        if (asStrings.size() == 0) {
            if (not.booleanValue()) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        if (asStrings.size() == 1) {
            String value = asStrings.iterator().next();
            if (not.booleanValue()) {
                return lqp.getDoesNotMatchFieldQuery(field, this.getType(value), AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            }
            return lqp.getFieldQuery(field, this.getType(value), AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        if (not.booleanValue()) {
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        }
        for (String value : asStrings) {
            Query any = lqp.getFieldQuery(field, this.getType(value), AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            if (not.booleanValue()) {
                booleanQuery.add(any, BooleanClause.Occur.MUST_NOT);
                continue;
            }
            booleanQuery.add(any, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    @Override
    public Query buildLuceneExists(AbstractLuceneQueryParser lqp, Boolean not) throws ParseException {
        if (not.booleanValue()) {
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        return new MatchAllDocsQuery();
    }

    private String getType(String tableName) {
        TypeDefinitionWrapper typeDef = this.dictionaryService.findTypeByQueryName(tableName);
        if (typeDef == null) {
            throw new CmisInvalidArgumentException("Unknwon type: " + tableName);
        }
        if (!typeDef.isBaseType()) {
            throw new CmisInvalidArgumentException("Not a base type: " + tableName);
        }
        if (!typeDef.getTypeDefinition(false).isQueryable().booleanValue()) {
            throw new CmisInvalidArgumentException("Type is not queryable: " + tableName);
        }
        return typeDef.getAlfrescoClass().toString();
    }

    private String getValueAsString(Serializable value) {
        String asString = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
        return asString;
    }
}

