/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.repo.dictionary.M2ChildAssociation;
import org.alfresco.repo.dictionary.M2ClassAssociation;
import org.alfresco.repo.dictionary.M2Label;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.repo.dictionary.ModelQuery;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

class M2AssociationDefinition
implements AssociationDefinition {
    private ClassDefinition classDef;
    private M2ClassAssociation assoc;
    private QName name;
    private QName targetClassName;
    private ClassDefinition targetClass;
    private QName sourceRoleName;
    private QName targetRoleName;
    private transient MessageLookup staticMessageLookup = new StaticMessageLookup();

    M2AssociationDefinition(ClassDefinition classDef, M2ClassAssociation assoc, NamespacePrefixResolver resolver) {
        this.classDef = classDef;
        this.assoc = assoc;
        this.name = QName.createQName(assoc.getName(), resolver);
        this.targetClassName = QName.createQName(assoc.getTargetClassName(), resolver);
        this.sourceRoleName = QName.createQName(assoc.getSourceRoleName(), resolver);
        this.targetRoleName = QName.createQName(assoc.getTargetRoleName(), resolver);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(56);
        sb.append("Association").append("[ class=").append(this.classDef).append(", name=").append(this.name).append(", target class=").append(this.targetClassName).append(", source role=").append(this.sourceRoleName).append(", target role=").append(this.targetRoleName).append("]");
        return sb.toString();
    }

    M2ClassAssociation getM2Association() {
        return this.assoc;
    }

    void resolveDependencies(ModelQuery query) {
        if (this.targetClassName == null) {
            throw new DictionaryException("Target class of association " + this.name.toPrefixString() + " must be specified");
        }
        this.targetClass = query.getClass(this.targetClassName);
        if (this.targetClass == null) {
            throw new DictionaryException("Target class " + this.targetClassName.toPrefixString() + " of association " + this.name.toPrefixString() + " is not found");
        }
    }

    @Override
    public ModelDefinition getModel() {
        return this.classDef.getModel();
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public boolean isChild() {
        return this.assoc instanceof M2ChildAssociation;
    }

    @Override
    public String getTitle() {
        return this.getTitle(this.staticMessageLookup);
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.staticMessageLookup);
    }

    @Override
    public String getTitle(MessageLookup messageLookup) {
        String value = M2Label.getLabel(this.classDef.getModel(), messageLookup, "association", this.name, "title");
        if (value == null) {
            value = this.assoc.getTitle();
        }
        return value;
    }

    @Override
    public String getDescription(MessageLookup messageLookup) {
        String value = M2Label.getLabel(this.classDef.getModel(), messageLookup, "association", this.name, "description");
        if (value == null) {
            value = this.assoc.getDescription();
        }
        return value;
    }

    @Override
    public boolean isProtected() {
        return this.assoc.isProtected();
    }

    @Override
    public ClassDefinition getSourceClass() {
        return this.classDef;
    }

    @Override
    public QName getSourceRoleName() {
        return this.sourceRoleName;
    }

    @Override
    public boolean isSourceMandatory() {
        return this.assoc.isSourceMandatory();
    }

    @Override
    public boolean isSourceMany() {
        return this.assoc.isSourceMany();
    }

    @Override
    public ClassDefinition getTargetClass() {
        return this.targetClass;
    }

    @Override
    public QName getTargetRoleName() {
        return this.targetRoleName;
    }

    @Override
    public boolean isTargetMandatory() {
        return this.assoc.isTargetMandatory();
    }

    @Override
    public boolean isTargetMandatoryEnforced() {
        return this.assoc.isTargetMandatoryEnforced();
    }

    @Override
    public boolean isTargetMany() {
        return this.assoc.isTargetMany();
    }

    M2ModelDiff diffAssoc(AssociationDefinition assocDef) {
        M2ModelDiff modelDiff = null;
        boolean isUpdated = false;
        boolean isUpdatedIncrementally = false;
        if (this == assocDef) {
            modelDiff = new M2ModelDiff(this.name, "ASSOCIATION", "unchanged");
            return modelDiff;
        }
        if (!this.name.equals(assocDef.getName())) {
            isUpdated = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getTitle(null), (String)assocDef.getTitle(null), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((String)this.getDescription(null), (String)assocDef.getDescription(null), (boolean)false)) {
            isUpdatedIncrementally = true;
        }
        if (!EqualsHelper.nullSafeEquals((Object)this.getSourceClass().getName(), (Object)assocDef.getSourceClass().getName())) {
            isUpdated = true;
        }
        if (!EqualsHelper.nullSafeEquals((Object)this.getSourceRoleName(), (Object)assocDef.getSourceRoleName())) {
            isUpdated = true;
        }
        if (!EqualsHelper.nullSafeEquals((Object)this.getTargetClass().getName(), (Object)assocDef.getTargetClass().getName())) {
            isUpdated = true;
        }
        if (!EqualsHelper.nullSafeEquals((Object)this.getTargetRoleName(), (Object)assocDef.getTargetRoleName())) {
            isUpdated = true;
        }
        modelDiff = isUpdated ? new M2ModelDiff(this.name, "ASSOCIATION", "updated") : (isUpdatedIncrementally ? new M2ModelDiff(this.name, "ASSOCIATION", "updated_inc") : new M2ModelDiff(this.name, "ASSOCIATION", "unchanged"));
        return modelDiff;
    }

    static Collection<M2ModelDiff> diffAssocLists(Collection<AssociationDefinition> previousAssocs, Collection<AssociationDefinition> newAssocs) {
        boolean found;
        ArrayList<M2ModelDiff> modelDiffs = new ArrayList<M2ModelDiff>();
        for (AssociationDefinition previousAssoc : previousAssocs) {
            found = false;
            for (AssociationDefinition newAssoc : newAssocs) {
                if (!newAssoc.getName().equals(previousAssoc.getName())) continue;
                modelDiffs.add(((M2AssociationDefinition)previousAssoc).diffAssoc(newAssoc));
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(previousAssoc.getName(), "ASSOCIATION", "deleted"));
        }
        for (AssociationDefinition newAssoc : newAssocs) {
            found = false;
            for (AssociationDefinition previousAssoc : previousAssocs) {
                if (!newAssoc.getName().equals(previousAssoc.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            modelDiffs.add(new M2ModelDiff(newAssoc.getName(), "ASSOCIATION", "created"));
        }
        return modelDiffs;
    }
}

