/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AbstractAnalyzer;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParserException;
import org.alfresco.repo.search.impl.lucene.analysis.DateTimeAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.MLTokenDuplicator;
import org.alfresco.repo.search.impl.parsers.FTSQueryException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.SearchLanguageConversion;
import org.antlr.misc.OrderedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardTermEnum;
import org.apache.lucene.search.regex.RegexQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.jaxen.saxpath.SAXPathException;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class AbstractLuceneQueryParser
extends QueryParser {
    public static final String FIELD_NO_LOCALE_SUFFIX = ".no_locale";
    public static final String FIELD_SORT_SUFFIX = ".sort";
    public static final String FIELD_LOCALE_SUFFIX = ".locale";
    public static final String FIELD_SIZE_SUFFIX = ".size";
    public static final String FIELD_MIMETYPE_SUFFIX = ".mimetype";
    public static final String FIELD_FTSSTATUS = "FTSSTATUS";
    public static final String FIELD_FTSREF = "FTSREF";
    public static final String FIELD_ISNOTNULL = "ISNOTNULL";
    public static final String FIELD_ISNULL = "ISNULL";
    public static final String FIELD_ISUNSET = "ISUNSET";
    public static final String FIELD_ALL = "ALL";
    public static final String PROPERTY_FIELD_PREFIX = "@";
    public static final String FIELD_EXACTASPECT = "EXACTASPECT";
    public static final String FIELD_EXACTTYPE = "EXACTTYPE";
    public static final String FIELD_TYPE = "TYPE";
    public static final String FIELD_ASPECT = "ASPECT";
    public static final String FIELD_CLASS = "CLASS";
    public static final String FIELD_ASSOCTYPEQNAME = "ASSOCTYPEQNAME";
    public static final String FIELD_PRIMARYASSOCTYPEQNAME = "PRIMARYASSOCTYPEQNAME";
    public static final String FIELD_QNAME = "QNAME";
    public static final String FIELD_PRIMARYPARENT = "PRIMARYPARENT";
    public static final String FIELD_PARENT = "PARENT";
    @Deprecated
    public static final String FIELD_TX = "TX";
    public static final String FIELD_ISNODE = "ISNODE";
    public static final String FIELD_ISCONTAINER = "ISCONTAINER";
    public static final String FIELD_ISROOT = "ISROOT";
    public static final String FIELD_DBID = "DBID";
    public static final String FIELD_ID = "ID";
    public static final String FIELD_TEXT = "TEXT";
    public static final String FIELD_PATHWITHREPEATS = "PATHWITHREPEATS";
    public static final String FIELD_PATH = "PATH";
    public static final String FIELD_TAG = "TAG";
    public static final String FIELD_ACLID = "ACLID";
    public static final String FIELD_OWNER = "OWNER";
    public static final String FIELD_READER = "READER";
    public static final String FIELD_AUTHORITY = "AUTHORITY";
    public static final String FIELD_OWNERSET = "OWNERSET";
    public static final String FIELD_READERSET = "READERSET";
    public static final String FIELD_AUTHORITYSET = "AUTHSET";
    public static final String FIELD_TXID = "TXID";
    public static final String FIELD_INTXID = "INTXID";
    public static final String FIELD_ACLTXID = "ACLTXID";
    public static final String FIELD_INACLTXID = "INACLTXID";
    public static final String FIELD_TXCOMMITTIME = "TXCOMMITTIME";
    public static final String FIELD_ACLTXCOMMITTIME = "ACLTXCOMMITTIME";
    public static final String FIELD_LINKASPECT = "LINKASPECT";
    public static final String FIELD_ANCESTOR = "ANCESTOR";
    public static final String FIELD_ISCATEGORY = "ISCATEGORY";
    public static final String FIELD_ENCODING_SUFFIX = ".encoding";
    public static final String FIELD_CONTENT_DOC_ID_SUFFIX = "contentDocId";
    public static final String FIELD_TRANSFORMATION_EXCEPTION_SUFFIX = ".transformationException";
    public static final String FIELD_TRANSFORMATION_TIME_SUFFIX = ".transformationTime";
    public static final String FIELD_TRANSFORMATION_STATUS_SUFFIX = ".transformationStatus";
    public static final String FIELD_PARENT_ASSOC_CRC = "PARENTASSOCCRC";
    public static final String FIELD_PRIMARYASSOCQNAME = "PRIMARYASSOCQNAME";
    public static final String FIELD_LID = "LID";
    public static final String FIELD_TENANT = "TENANT";
    public static final String FIELD_EXCEPTION_MESSAGE = "EXCEPTIONMESSAGE";
    public static final String FIELD_EXCEPTION_STACK = "EXCEPTIONSTACK";
    private static Log s_logger = LogFactory.getLog(AbstractLuceneQueryParser.class);
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected DictionaryService dictionaryService;
    private TenantService tenantService;
    private SearchParameters searchParameters;
    private MLAnalysisMode defaultSearchMLAnalysisMode;
    private IndexReader indexReader;
    private int internalSlop = 0;
    private AbstractAnalyzer luceneAnalyser;

    public void setDefaultSearchMLAnalysisMode(MLAnalysisMode defaultSearchMLAnalysisMode) {
        this.defaultSearchMLAnalysisMode = defaultSearchMLAnalysisMode;
    }

    public void setIndexReader(IndexReader indexReader) {
        this.indexReader = indexReader;
    }

    public void setSearchParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public MLAnalysisMode getDefaultSearchMLAnalysisMode() {
        return this.defaultSearchMLAnalysisMode;
    }

    public abstract boolean addContentCrossLocaleWildcards();

    public AbstractLuceneQueryParser(String arg0, Analyzer arg1) {
        super(arg0, arg1);
        if (arg1 instanceof AbstractAnalyzer) {
            this.luceneAnalyser = (AbstractAnalyzer)arg1;
        }
    }

    public AbstractLuceneQueryParser(CharStream arg0) {
        super(arg0);
    }

    public AbstractLuceneQueryParser(QueryParserTokenManager arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        try {
            Query query;
            this.internalSlop = slop;
            Query query2 = query = this.getFieldQuery(field, queryText);
            return query2;
        }
        finally {
            this.internalSlop = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query getFieldQuery(String field, String queryText, AnalysisMode analysisMode, int slop, LuceneFunction luceneFunction) throws ParseException {
        try {
            Query query;
            this.internalSlop = slop;
            Query query2 = query = this.getFieldQuery(field, queryText, analysisMode, luceneFunction);
            return query2;
        }
        finally {
            this.internalSlop = 0;
        }
    }

    public Query getLikeQuery(String field, String sqlLikeClause, AnalysisMode analysisMode) throws ParseException {
        String luceneWildCardExpression = this.translate(sqlLikeClause);
        return this.getWildcardQuery(field, luceneWildCardExpression, AnalysisMode.LIKE);
    }

    private String translate(String string) {
        StringBuilder builder = new StringBuilder(string.length());
        boolean lastWasEscape = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (lastWasEscape) {
                builder.append(c);
                lastWasEscape = false;
                continue;
            }
            if (c == '\\') {
                lastWasEscape = true;
                continue;
            }
            if (c == '%') {
                builder.append('*');
                continue;
            }
            if (c == '_') {
                builder.append('?');
                continue;
            }
            if (c == '*') {
                builder.append('\\');
                builder.append(c);
                continue;
            }
            if (c == '?') {
                builder.append('\\');
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        if (lastWasEscape) {
            throw new FTSQueryException("Escape character at end of string " + string);
        }
        return builder.toString();
    }

    public Query getDoesNotMatchFieldQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        BooleanQuery query = new BooleanQuery();
        MatchAllDocsQuery allQuery = new MatchAllDocsQuery();
        Query matchQuery = this.getFieldQuery(field, queryText, analysisMode, luceneFunction);
        if (matchQuery == null) {
            throw new UnsupportedOperationException();
        }
        query.add((Query)allQuery, BooleanClause.Occur.MUST);
        query.add(matchQuery, BooleanClause.Occur.MUST_NOT);
        return query;
    }

    public Query getFieldQuery(String field, String queryText) throws ParseException {
        return this.getFieldQuery(field, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    public Query getSpanQuery(String field, String first, String last, int slop, boolean inOrder) {
        if (field.equals(FIELD_PATH)) {
            throw new UnsupportedOperationException("Span is not supported for PATH");
        }
        if (field.equals(FIELD_PATHWITHREPEATS)) {
            throw new UnsupportedOperationException("Span is not supported for PATHWITHREPEATS");
        }
        if (field.equals(FIELD_TEXT)) {
            Set<String> text = this.searchParameters.getTextAttributes();
            if (text == null || text.size() == 0) {
                Query query = this.getSpanQuery(PROPERTY_FIELD_PREFIX + ContentModel.PROP_CONTENT.toString(), first, last, slop, inOrder);
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : text) {
                Query part = this.getSpanQuery(fieldName, first, last, slop, inOrder);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_CLASS)) {
            throw new UnsupportedOperationException("Span is not supported for CLASS");
        }
        if (field.equals(FIELD_TYPE)) {
            throw new UnsupportedOperationException("Span is not supported for TYPE");
        }
        if (field.equals(FIELD_EXACTTYPE)) {
            throw new UnsupportedOperationException("Span is not supported for EXACTTYPE");
        }
        if (field.equals(FIELD_ASPECT)) {
            throw new UnsupportedOperationException("Span is not supported for ASPECT");
        }
        if (field.equals(FIELD_EXACTASPECT)) {
            throw new UnsupportedOperationException("Span is not supported for EXACTASPECT");
        }
        if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
            return this.spanQueryBuilder(field, first, last, slop, inOrder);
        }
        if (field.equals(FIELD_ALL)) {
            Set<String> all = this.searchParameters.getAllAttributes();
            if (all == null || all.size() == 0) {
                Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(null);
                BooleanQuery query = new BooleanQuery();
                for (QName qname : contentAttributes) {
                    Query part = this.getSpanQuery(PROPERTY_FIELD_PREFIX + qname.toString(), first, last, slop, inOrder);
                    query.add(part, BooleanClause.Occur.SHOULD);
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : all) {
                Query part = this.getSpanQuery(fieldName, first, last, slop, inOrder);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_ISUNSET)) {
            throw new UnsupportedOperationException("Span is not supported for ISUNSET");
        }
        if (field.equals(FIELD_ISNULL)) {
            throw new UnsupportedOperationException("Span is not supported for ISNULL");
        }
        if (field.equals(FIELD_ISNOTNULL)) {
            throw new UnsupportedOperationException("Span is not supported for ISNOTNULL");
        }
        if (this.matchDataTypeDefinition(field) != null) {
            Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(this.matchDataTypeDefinition(field).getName());
            BooleanQuery query = new BooleanQuery();
            for (QName qname : contentAttributes) {
                Query part = this.getSpanQuery(PROPERTY_FIELD_PREFIX + qname.toString(), first, last, slop, inOrder);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_FTSSTATUS)) {
            throw new UnsupportedOperationException("Span is not supported for FTSSTATUS");
        }
        if (field.equals(FIELD_TAG)) {
            return null;
        }
        SpanTermQuery firstTerm = new SpanTermQuery(new Term(field, first));
        SpanTermQuery lastTerm = new SpanTermQuery(new Term(field, last));
        return new SpanNearQuery(new SpanQuery[]{firstTerm, lastTerm}, slop, inOrder);
    }

    private DataTypeDefinition matchDataTypeDefinition(String string) {
        QName search = QName.createQName(this.expandQName(string));
        DataTypeDefinition dataTypeDefinition = this.dictionaryService.getDataType(QName.createQName(this.expandQName(string)));
        QName match = null;
        if (dataTypeDefinition == null) {
            for (QName definition : this.dictionaryService.getAllDataTypes()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new LuceneQueryParserException("Ambiguous data datype " + string);
            }
        } else {
            return dataTypeDefinition;
        }
        if (match == null) {
            return null;
        }
        return this.dictionaryService.getDataType(match);
    }

    private PropertyDefinition matchPropertyDefinition(String string) {
        QName search = QName.createQName(this.expandQName(string));
        PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(QName.createQName(this.expandQName(string)));
        QName match = null;
        if (propertyDefinition == null) {
            for (QName definition : this.dictionaryService.getAllProperties(null)) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new LuceneQueryParserException("Ambiguous data datype " + string);
            }
        } else {
            return propertyDefinition;
        }
        if (match == null) {
            return null;
        }
        return this.dictionaryService.getProperty(match);
    }

    private AspectDefinition matchAspectDefinition(String string) {
        QName search = QName.createQName(this.expandQName(string));
        AspectDefinition aspectDefinition = this.dictionaryService.getAspect(QName.createQName(this.expandQName(string)));
        QName match = null;
        if (aspectDefinition == null) {
            for (QName definition : this.dictionaryService.getAllAspects()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new LuceneQueryParserException("Ambiguous data datype " + string);
            }
        } else {
            return aspectDefinition;
        }
        if (match == null) {
            return null;
        }
        return this.dictionaryService.getAspect(match);
    }

    private TypeDefinition matchTypeDefinition(String string) {
        QName search = QName.createQName(this.expandQName(string));
        TypeDefinition typeDefinition = this.dictionaryService.getType(QName.createQName(this.expandQName(string)));
        QName match = null;
        if (typeDefinition == null) {
            for (QName definition : this.dictionaryService.getAllTypes()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new LuceneQueryParserException("Ambiguous data datype " + string);
            }
        } else {
            return typeDefinition;
        }
        if (match == null) {
            return null;
        }
        return this.dictionaryService.getType(match);
    }

    private ClassDefinition matchClassDefinition(String string) {
        QName search = QName.createQName(this.expandQName(string));
        ClassDefinition classDefinition = this.dictionaryService.getClass(QName.createQName(this.expandQName(string)));
        QName match = null;
        if (classDefinition == null) {
            for (QName definition : this.dictionaryService.getAllTypes()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new LuceneQueryParserException("Ambiguous data datype " + string);
            }
            for (QName definition : this.dictionaryService.getAllAspects()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new LuceneQueryParserException("Ambiguous data datype " + string);
            }
        } else {
            return classDefinition;
        }
        if (match == null) {
            return null;
        }
        return this.dictionaryService.getClass(match);
    }

    public Query getFieldQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        try {
            if (field.equals(FIELD_PATH)) {
                return this.createPathQuery(queryText, false);
            }
            if (field.equals(FIELD_PATHWITHREPEATS)) {
                return this.createPathQuery(queryText, true);
            }
            if (field.equals(FIELD_TEXT)) {
                return this.createTextQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_ID)) {
                return this.createIdQuery(queryText);
            }
            if (field.equals(FIELD_DBID)) {
                return this.createDbidQuery(queryText);
            }
            if (field.equals(FIELD_ACLID)) {
                return this.createAclIdQuery(queryText);
            }
            if (field.equals(FIELD_OWNER)) {
                return this.createOwnerQuery(queryText);
            }
            if (field.equals(FIELD_OWNERSET)) {
                return this.createOwnerSetQuery(queryText);
            }
            if (field.equals(FIELD_READER)) {
                return this.createReaderQuery(queryText);
            }
            if (field.equals(FIELD_READERSET)) {
                return this.createReaderSetQuery(queryText);
            }
            if (field.equals(FIELD_AUTHORITY)) {
                return this.createAuthorityQuery(queryText);
            }
            if (field.equals(FIELD_AUTHORITYSET)) {
                return this.createAuthoritySetQuery(queryText);
            }
            if (field.equals(FIELD_ISROOT)) {
                return this.createIsRootQuery(queryText);
            }
            if (field.equals(FIELD_ISCONTAINER)) {
                return this.createIsContainerQuery(queryText);
            }
            if (field.equals(FIELD_ISNODE)) {
                return this.createIsNodeQuery(queryText);
            }
            if (field.equals(FIELD_TX)) {
                return this.createTransactionQuery(queryText);
            }
            if (field.equals(FIELD_INTXID)) {
                return this.createInTxIdQuery(queryText);
            }
            if (field.equals(FIELD_INACLTXID)) {
                return this.createInAclTxIdQuery(queryText);
            }
            if (field.equals(FIELD_PARENT)) {
                return this.createParentQuery(queryText);
            }
            if (field.equals(FIELD_PRIMARYPARENT)) {
                return this.createPrimaryParentQuery(queryText);
            }
            if (field.equals(FIELD_QNAME)) {
                return this.createQNameQuery(queryText);
            }
            if (field.equals(FIELD_PRIMARYASSOCQNAME)) {
                return this.createPrimaryAssocQNameQuery(queryText);
            }
            if (field.equals(FIELD_PRIMARYASSOCTYPEQNAME)) {
                return this.createPrimaryAssocTypeQNameQuery(queryText);
            }
            if (field.equals(FIELD_ASSOCTYPEQNAME)) {
                return this.createAssocTypeQNameQuery(queryText);
            }
            if (field.equals(FIELD_CLASS)) {
                ClassDefinition target = this.matchClassDefinition(queryText);
                if (target == null) {
                    throw new LuceneQueryParserException("Invalid type: " + queryText);
                }
                return this.getFieldQuery(target.isAspect() ? FIELD_ASPECT : FIELD_TYPE, queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_TYPE)) {
                return this.createTypeQuery(queryText, false);
            }
            if (field.equals(FIELD_EXACTTYPE)) {
                return this.createTypeQuery(queryText, true);
            }
            if (field.equals(FIELD_ASPECT)) {
                return this.createAspectQuery(queryText, false);
            }
            if (field.equals(FIELD_EXACTASPECT)) {
                return this.createAspectQuery(queryText, true);
            }
            if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
                Query query = this.attributeQueryBuilder(field, queryText, new FieldQuery(), analysisMode, luceneFunction);
                return query;
            }
            if (field.equals(FIELD_ALL)) {
                return this.createAllQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_ISUNSET)) {
                return this.createIsUnsetQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_ISNULL)) {
                return this.createIsNullQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_ISNOTNULL)) {
                return this.createIsNotNull(queryText, analysisMode, luceneFunction);
            }
            if (this.matchDataTypeDefinition(field) != null) {
                return this.createDataTypeDefinitionQuery(field, queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_FTSSTATUS)) {
                return this.createTermQuery(field, queryText);
            }
            if (field.equals(FIELD_TXID)) {
                return this.createTxIdQuery(queryText);
            }
            if (field.equals(FIELD_ACLTXID)) {
                return this.createAclTxIdQuery(queryText);
            }
            if (field.equals(FIELD_TXCOMMITTIME)) {
                return this.createTxCommitTimeQuery(queryText);
            }
            if (field.equals(FIELD_ACLTXCOMMITTIME)) {
                return this.createAclTxCommitTimeQuery(queryText);
            }
            if (field.equals(FIELD_TAG)) {
                return this.createTagQuery(queryText);
            }
            if (field.equals(FIELD_TENANT)) {
                return this.createTenantQuery(queryText);
            }
            if (field.equals(FIELD_ANCESTOR)) {
                return this.createAncestorQuery(queryText);
            }
            return this.getFieldQueryImpl(field, queryText, analysisMode, luceneFunction);
        }
        catch (SAXPathException e) {
            throw new ParseException("Failed to parse XPath...\n" + e.getMessage());
        }
    }

    protected Query createTenantQuery(String queryText) throws ParseException {
        if (queryText.length() > 0) {
            return this.getFieldQueryImpl(FIELD_TENANT, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
        }
        return this.getFieldQueryImpl(FIELD_TENANT, "_DEFAULT_", AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createAncestorQuery(String queryText) throws ParseException {
        return this.createNodeRefQuery(FIELD_ANCESTOR, queryText);
    }

    protected Query createTagQuery(String tag) throws ParseException {
        return this.getFieldQuery(FIELD_PATH, "/cm:taggable/cm:" + ISO9075.encode(tag.toLowerCase()) + "/member");
    }

    protected abstract Query createAclIdQuery(String var1) throws ParseException;

    protected abstract Query createOwnerQuery(String var1) throws ParseException;

    protected abstract Query createReaderQuery(String var1) throws ParseException;

    protected abstract Query createAuthorityQuery(String var1) throws ParseException;

    protected abstract Query createOwnerSetQuery(String var1) throws ParseException;

    protected abstract Query createReaderSetQuery(String var1) throws ParseException;

    protected abstract Query createAuthoritySetQuery(String var1) throws ParseException;

    protected Query createDbidQuery(String queryText) throws ParseException {
        return this.getFieldQueryImpl(FIELD_DBID, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createTxIdQuery(String queryText) throws ParseException {
        return this.getFieldQueryImpl(FIELD_TXID, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createAclTxIdQuery(String queryText) throws ParseException {
        return this.getFieldQueryImpl(FIELD_ACLTXID, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createTxCommitTimeQuery(String queryText) throws ParseException {
        return this.getFieldQueryImpl(FIELD_TXCOMMITTIME, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createAclTxCommitTimeQuery(String queryText) throws ParseException {
        return this.getFieldQueryImpl(FIELD_ACLTXCOMMITTIME, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createDataTypeDefinitionQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(this.matchDataTypeDefinition(field).getName());
        BooleanQuery query = new BooleanQuery();
        for (QName qname : contentAttributes) {
            Query part = this.getFieldQuery(PROPERTY_FIELD_PREFIX + qname.toString(), queryText, analysisMode, luceneFunction);
            if (part != null) {
                query.add(part, BooleanClause.Occur.SHOULD);
                continue;
            }
            query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    protected Query createIsNotNull(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        PropertyDefinition pd = this.matchPropertyDefinition(queryText);
        if (pd != null) {
            ClassDefinition containerClass = pd.getContainerClass();
            QName container = containerClass.getName();
            BooleanQuery query = new BooleanQuery();
            String classType = containerClass.isAspect() ? FIELD_ASPECT : FIELD_TYPE;
            Query typeQuery = this.getFieldQuery(classType, container.toString(), analysisMode, luceneFunction);
            Query presenceQuery = this.getWildcardQuery(PROPERTY_FIELD_PREFIX + pd.getName().toString(), "*");
            if (typeQuery != null && presenceQuery != null) {
                query.add(presenceQuery, BooleanClause.Occur.MUST);
            }
            return query;
        }
        return this.getFieldQueryImpl(FIELD_ISNOTNULL, queryText, analysisMode, luceneFunction);
    }

    protected Query createIsNullQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        PropertyDefinition pd = this.matchPropertyDefinition(queryText);
        if (pd != null) {
            BooleanQuery query = new BooleanQuery();
            Query presenceQuery = this.getWildcardQuery(PROPERTY_FIELD_PREFIX + pd.getName().toString(), "*");
            if (presenceQuery != null) {
                query.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                query.add(presenceQuery, BooleanClause.Occur.MUST_NOT);
            }
            return query;
        }
        return this.getFieldQueryImpl(FIELD_ISNULL, queryText, analysisMode, luceneFunction);
    }

    protected Query createIsUnsetQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        PropertyDefinition pd = this.matchPropertyDefinition(queryText);
        if (pd != null) {
            ClassDefinition containerClass = pd.getContainerClass();
            QName container = containerClass.getName();
            BooleanQuery query = new BooleanQuery();
            String classType = containerClass.isAspect() ? FIELD_ASPECT : FIELD_TYPE;
            Query typeQuery = this.getFieldQuery(classType, container.toString(), analysisMode, luceneFunction);
            Query presenceQuery = this.getWildcardQuery(PROPERTY_FIELD_PREFIX + pd.getName().toString(), "*");
            if (typeQuery != null && presenceQuery != null) {
                query.add(typeQuery, BooleanClause.Occur.MUST);
                query.add(presenceQuery, BooleanClause.Occur.MUST_NOT);
            }
            return query;
        }
        return this.getFieldQueryImpl(FIELD_ISUNSET, queryText, analysisMode, luceneFunction);
    }

    protected Query createAllQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        Set<String> all = this.searchParameters.getAllAttributes();
        if (all == null || all.size() == 0) {
            Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(null);
            BooleanQuery query = new BooleanQuery();
            for (QName qname : contentAttributes) {
                Query part = this.getFieldQuery(PROPERTY_FIELD_PREFIX + qname.toString(), queryText, analysisMode, luceneFunction);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        BooleanQuery query = new BooleanQuery();
        for (String fieldName : all) {
            Query part = this.getFieldQuery(fieldName, queryText, analysisMode, luceneFunction);
            if (part != null) {
                query.add(part, BooleanClause.Occur.SHOULD);
                continue;
            }
            query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    protected Query createAspectQuery(String queryText, boolean exactOnly) {
        AspectDefinition target = this.matchAspectDefinition(queryText);
        if (target == null) {
            throw new AlfrescoRuntimeException("Unknown aspect specified in query: " + queryText);
        }
        if (exactOnly) {
            QName targetQName = target.getName();
            TermQuery termQuery = new TermQuery(new Term(FIELD_ASPECT, targetQName.toString()));
            return termQuery;
        }
        Collection<QName> subclasses = this.dictionaryService.getSubAspects(target.getName(), true);
        BooleanQuery booleanQuery = new BooleanQuery();
        for (QName qname : subclasses) {
            TermQuery termQuery;
            AspectDefinition current = this.dictionaryService.getAspect(qname);
            if (!target.getName().equals(current.getName()) && !current.getIncludedInSuperTypeQuery().booleanValue() || (termQuery = new TermQuery(new Term(FIELD_ASPECT, qname.toString()))) == null) continue;
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    protected Query createTypeQuery(String queryText, boolean exactOnly) {
        TypeDefinition target = this.matchTypeDefinition(queryText);
        if (target == null) {
            throw new LuceneQueryParserException("Invalid type: " + queryText);
        }
        if (exactOnly) {
            QName targetQName = target.getName();
            TermQuery termQuery = new TermQuery(new Term(FIELD_TYPE, targetQName.toString()));
            return termQuery;
        }
        Collection<QName> subclasses = this.dictionaryService.getSubTypes(target.getName(), true);
        BooleanQuery booleanQuery = new BooleanQuery();
        for (QName qname : subclasses) {
            TermQuery termQuery;
            TypeDefinition current = this.dictionaryService.getType(qname);
            if (!target.getName().equals(current.getName()) && !current.getIncludedInSuperTypeQuery().booleanValue() || (termQuery = new TermQuery(new Term(FIELD_TYPE, qname.toString()))) == null) continue;
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    protected abstract Query createAssocTypeQNameQuery(String var1) throws SAXPathException;

    protected abstract Query createPrimaryAssocTypeQNameQuery(String var1) throws SAXPathException;

    protected abstract Query createPrimaryAssocQNameQuery(String var1) throws SAXPathException;

    protected abstract Query createQNameQuery(String var1) throws SAXPathException;

    protected Query createInTxIdQuery(String queryText) throws ParseException {
        return this.getFieldQueryImpl(FIELD_INTXID, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createInAclTxIdQuery(String queryText) throws ParseException {
        return this.getFieldQueryImpl(FIELD_INACLTXID, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createTransactionQuery(String queryText) {
        return this.createTermQuery(FIELD_TX, queryText);
    }

    protected Query createIsNodeQuery(String queryText) {
        return this.createTermQuery(FIELD_ISNODE, queryText);
    }

    protected Query createIsContainerQuery(String queryText) {
        return this.createTermQuery(FIELD_ISCONTAINER, queryText);
    }

    protected Query createIsRootQuery(String queryText) {
        return this.createTermQuery(FIELD_ISROOT, queryText);
    }

    protected Query createTermQuery(String field, String queryText) {
        TermQuery termQuery = new TermQuery(new Term(field, queryText));
        return termQuery;
    }

    protected Query createPrimaryParentQuery(String queryText) {
        return this.createNodeRefQuery(FIELD_PRIMARYPARENT, queryText);
    }

    protected Query createParentQuery(String queryText) {
        return this.createNodeRefQuery(FIELD_PARENT, queryText);
    }

    protected Query createIdQuery(String queryText) {
        return this.createNodeRefQuery(FIELD_ID, queryText);
    }

    protected Query createNodeRefQuery(String field, String queryText) {
        if (this.tenantService.isTenantUser() && queryText.contains("://")) {
            queryText = this.tenantService.getName(new NodeRef(queryText)).toString();
        }
        return this.createTermQuery(field, queryText);
    }

    protected abstract Query createPathQuery(String var1, boolean var2) throws SAXPathException;

    protected Query createTextQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        Set<String> text = this.searchParameters.getTextAttributes();
        if (text == null || text.size() == 0) {
            Query query = this.getFieldQuery(PROPERTY_FIELD_PREFIX + ContentModel.PROP_CONTENT.toString(), queryText, analysisMode, luceneFunction);
            if (query == null) {
                return this.createNoMatchQuery();
            }
            return query;
        }
        BooleanQuery query = new BooleanQuery();
        for (String fieldName : text) {
            Query part = this.getFieldQuery(fieldName, queryText, analysisMode, luceneFunction);
            if (part != null) {
                query.add(part, BooleanClause.Occur.SHOULD);
                continue;
            }
            query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    /*
     * Could not resolve type clashes
     */
    protected Query getFieldQueryImpl(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        String termText;
        Token nextToken;
        TokenStream source;
        if (luceneFunction != LuceneFunction.FIELD) {
            throw new UnsupportedOperationException("Field queries are not supported on lucene functions (UPPER, LOWER, etc)");
        }
        String localePrefix = "";
        String toTokenise = queryText;
        if (queryText.startsWith("{")) {
            int position = queryText.indexOf("}");
            String language = queryText.substring(0, position + 1);
            Locale locale = new Locale(queryText.substring(1, position));
            String token = queryText.substring(position + 1);
            HashSet locales = new HashSet();
            boolean found = false;
            for (Locale current : Locale.getAvailableLocales()) {
                if (!current.toString().equalsIgnoreCase(locale.toString())) continue;
                found = true;
                break;
            }
            if (found) {
                localePrefix = language;
                toTokenise = token;
            } else {
                toTokenise = token;
            }
        }
        String testText = toTokenise;
        boolean requiresMLTokenDuplication = false;
        String localeString = null;
        if (field.startsWith(PROPERTY_FIELD_PREFIX) && localePrefix.length() == 0 && queryText.length() > 0 && queryText.charAt(0) == '\u0000') {
            int position = queryText.indexOf("\u0000", 1);
            testText = queryText.substring(position + 1);
            requiresMLTokenDuplication = true;
            localeString = queryText.substring(1, position);
        }
        Set<Integer> wildcardPoistions = this.getWildcardPositions(testText);
        if (localePrefix.length() == 0 || wildcardPoistions.size() > 0 || analysisMode == AnalysisMode.IDENTIFIER) {
            source = this.getAnalyzer().tokenStream(field, new StringReader(toTokenise), analysisMode);
        } else {
            source = this.getAnalyzer().tokenStream(field, new StringReader("\u0000" + localePrefix.substring(1, localePrefix.length() - 1) + "\u0000" + toTokenise), analysisMode);
            localePrefix = "";
        }
        ArrayList<Token> list = new ArrayList<Token>();
        Token reusableToken = new Token();
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        while (true) {
            try {
                nextToken = source.next(reusableToken);
            }
            catch (IOException e) {
                nextToken = null;
            }
            if (nextToken == null) break;
            list.add((Token)nextToken.clone());
            if (nextToken.getPositionIncrement() != 0) {
                positionCount += nextToken.getPositionIncrement();
                continue;
            }
            severalTokensAtSamePosition = true;
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int index = 0; index < testText.length(); ++index) {
            char c;
            Token test;
            int count;
            Iterator<Token> it;
            char current = testText.charAt(index);
            if (current != '*' && current != '?' || !wildcardPoistions.contains(index)) continue;
            StringBuilder pre = new StringBuilder(10);
            if (index == 0) {
                boolean found = false;
                for (int j = 0; j < list.size(); ++j) {
                    Token test2 = (Token)list.get(j);
                    if (test2.startOffset() > 0 || 0 >= test2.endOffset()) continue;
                    found = true;
                    break;
                }
                if (!found && testText.length() == 1) {
                    Token newToken = new Token(0, 0);
                    newToken.setTermBuffer("");
                    newToken.setType("ALPHANUM");
                    if (requiresMLTokenDuplication) {
                        MLAnalysisMode mlAnalysisMode;
                        Locale locale = I18NUtil.parseLocale((String)localeString);
                        MLTokenDuplicator duplicator = new MLTokenDuplicator(locale, mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode());
                        it = duplicator.buildIterator(newToken);
                        if (it != null) {
                            count = 0;
                            while (it.hasNext()) {
                                list.add(it.next());
                                if (++count <= 1) continue;
                                severalTokensAtSamePosition = true;
                            }
                        }
                    } else {
                        list.add(newToken);
                    }
                }
            } else if (index > 0) {
                boolean tokenFound = false;
                for (int j = 0; j < list.size(); ++j) {
                    Token test3 = (Token)list.get(j);
                    if (test3.startOffset() > index || index >= test3.endOffset()) continue;
                    if (requiresMLTokenDuplication) {
                        String termText2 = new String(test3.termBuffer(), 0, test3.termLength());
                        int position = termText2.indexOf("}");
                        String language = termText2.substring(0, position + 1);
                        String token = termText2.substring(position + 1);
                        if (index >= test3.startOffset() + token.length()) {
                            test3.setTermBuffer(language + token + current);
                        }
                    } else if (index >= test3.startOffset() + test3.termLength()) {
                        test3.setTermBuffer(test3.term() + current);
                    }
                    tokenFound = true;
                    break;
                }
                if (!tokenFound) {
                    char c2;
                    for (int i = index - 1; i >= 0 && Character.isLetterOrDigit(c2 = testText.charAt(i)); --i) {
                        boolean found = false;
                        for (int j = 0; j < list.size(); ++j) {
                            test = (Token)list.get(j);
                            if (test.startOffset() > i || i >= test.endOffset()) continue;
                            found = true;
                            break;
                        }
                        if (found) break;
                        pre.insert(0, c2);
                    }
                    if (pre.length() > 0) {
                        Token newToken = new Token(index - pre.length(), index);
                        newToken.setTermBuffer(pre.toString());
                        newToken.setType("ALPHANUM");
                        if (requiresMLTokenDuplication) {
                            MLAnalysisMode mlAnalysisMode;
                            Locale locale = I18NUtil.parseLocale((String)localeString);
                            MLTokenDuplicator duplicator = new MLTokenDuplicator(locale, mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode());
                            it = duplicator.buildIterator(newToken);
                            if (it != null) {
                                int count2 = 0;
                                while (it.hasNext()) {
                                    list.add(it.next());
                                    if (++count2 <= 1) continue;
                                    severalTokensAtSamePosition = true;
                                }
                            }
                        } else {
                            list.add(newToken);
                        }
                    }
                }
            }
            StringBuilder post = new StringBuilder(10);
            if (index <= 0) continue;
            for (int i = index + 1; i < testText.length() && Character.isLetterOrDigit(c = testText.charAt(i)); ++i) {
                boolean found = false;
                for (int j = 0; j < list.size(); ++j) {
                    test = (Token)list.get(j);
                    if (test.startOffset() > i || i >= test.endOffset()) continue;
                    found = true;
                    break;
                }
                if (found) break;
                post.append(c);
            }
            if (post.length() <= 0) continue;
            Token newToken = new Token(index + 1, index + 1 + post.length());
            newToken.setTermBuffer(post.toString());
            newToken.setType("ALPHANUM");
            if (requiresMLTokenDuplication) {
                MLAnalysisMode mlAnalysisMode;
                Locale locale = I18NUtil.parseLocale((String)localeString);
                MLTokenDuplicator duplicator = new MLTokenDuplicator(locale, mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode());
                it = duplicator.buildIterator(newToken);
                if (it == null) continue;
                count = 0;
                while (it.hasNext()) {
                    list.add(it.next());
                    if (++count <= 1) continue;
                    severalTokensAtSamePosition = true;
                }
                continue;
            }
            list.add(newToken);
        }
        Collections.sort(list, new Comparator<Token>(){

            @Override
            public int compare(Token o1, Token o2) {
                int dif = o1.startOffset() - o2.startOffset();
                if (dif != 0) {
                    return dif;
                }
                return o2.getPositionIncrement() - o1.getPositionIncrement();
            }
        });
        LinkedList tokensByPosition = new LinkedList();
        LinkedList<Token> currentList = null;
        for (Token c : list) {
            if (c.getPositionIncrement() == 0) {
                if (currentList == null) {
                    currentList = new LinkedList();
                    tokensByPosition.add(currentList);
                }
                currentList.add(c);
                continue;
            }
            currentList = new LinkedList<Token>();
            tokensByPosition.add(currentList);
            currentList.add(c);
        }
        LinkedList allTokenSequences = new LinkedList();
        for (LinkedList tokensAtPosition : tokensByPosition) {
            if (allTokenSequences.size() == 0) {
                for (Token t : tokensAtPosition) {
                    LinkedList<Token> newEntry = new LinkedList<Token>();
                    newEntry.add(t);
                    allTokenSequences.add(newEntry);
                }
                continue;
            }
            LinkedList newAllTokeSequences = new LinkedList();
            for (Token t : tokensAtPosition) {
                boolean tokenFoundSequence = false;
                for (LinkedList tokenSequence : allTokenSequences) {
                    LinkedList<Token> newEntry = new LinkedList<Token>();
                    newEntry.addAll(tokenSequence);
                    if (((Token)newEntry.getLast()).endOffset() <= t.startOffset()) {
                        newEntry.add(t);
                        tokenFoundSequence = true;
                    }
                    newAllTokeSequences.add(newEntry);
                }
                if (!tokenFoundSequence) {
                    LinkedList<Token> newEntry = new LinkedList<Token>();
                    newEntry.add(t);
                    newAllTokeSequences.add(newEntry);
                }
                if (newAllTokeSequences.size() <= 64) continue;
                break;
            }
            allTokenSequences = newAllTokeSequences;
        }
        LinkedList<LinkedList<Token>> fixedTokenSequences = new LinkedList<LinkedList<Token>>();
        for (LinkedList tokenSequence : allTokenSequences) {
            LinkedList<Token> fixedTokenSequence = new LinkedList<Token>();
            fixedTokenSequences.add(fixedTokenSequence);
            Token replace = null;
            for (Token c : tokenSequence) {
                String token;
                String language;
                String termText3;
                StringBuilder prefix;
                if (replace == null) {
                    char test;
                    prefix = new StringBuilder();
                    for (int i = c.startOffset() - 1; i >= 0 && ((test = testText.charAt(i)) == '*' || test == '?') && wildcardPoistions.contains(i); --i) {
                        prefix.insert(0, test);
                    }
                    String pre = prefix.toString();
                    if (requiresMLTokenDuplication) {
                        termText = new String(c.termBuffer(), 0, c.termLength());
                        int position = termText.indexOf("}");
                        String language2 = termText.substring(0, position + 1);
                        String token2 = termText.substring(position + 1);
                        replace = new Token(c.startOffset() - pre.length(), c.endOffset());
                        replace.setTermBuffer(language2 + pre + token2);
                        replace.setType(c.type());
                        replace.setPositionIncrement(c.getPositionIncrement());
                        continue;
                    }
                    termText = new String(c.termBuffer(), 0, c.termLength());
                    replace = new Token(c.startOffset() - pre.length(), c.endOffset());
                    replace.setTermBuffer(pre + termText);
                    replace.setType(c.type());
                    replace.setPositionIncrement(c.getPositionIncrement());
                    continue;
                }
                prefix = new StringBuilder();
                StringBuilder postfix = new StringBuilder();
                StringBuilder builder = prefix;
                for (int i = c.startOffset() - 1; i >= replace.endOffset(); --i) {
                    char test = testText.charAt(i);
                    if ((test == '*' || test == '?') && wildcardPoistions.contains(i)) {
                        builder.insert(0, test);
                        continue;
                    }
                    builder = postfix;
                    postfix.setLength(0);
                }
                String pre = prefix.toString();
                String post = postfix.toString();
                if (pre.length() > 0 && replace.endOffset() + pre.length() == c.startOffset()) {
                    termText3 = new String(c.termBuffer(), 0, c.termLength());
                    if (requiresMLTokenDuplication) {
                        int position = termText3.indexOf("}");
                        language = termText3.substring(0, position + 1);
                        token = termText3.substring(position + 1);
                        int oldPositionIncrement = replace.getPositionIncrement();
                        String replaceTermText = new String(replace.termBuffer(), 0, replace.termLength());
                        replace = new Token(replace.startOffset(), c.endOffset());
                        replace.setTermBuffer(replaceTermText + pre + token);
                        replace.setType(replace.type());
                        replace.setPositionIncrement(oldPositionIncrement);
                        continue;
                    }
                    int oldPositionIncrement = replace.getPositionIncrement();
                    String replaceTermText = new String(replace.termBuffer(), 0, replace.termLength());
                    replace = new Token(replace.startOffset(), c.endOffset());
                    replace.setTermBuffer(replaceTermText + pre + termText3);
                    replace.setType(replace.type());
                    replace.setPositionIncrement(oldPositionIncrement);
                    continue;
                }
                termText3 = new String(c.termBuffer(), 0, c.termLength());
                if (requiresMLTokenDuplication) {
                    int position = termText3.indexOf("}");
                    language = termText3.substring(0, position + 1);
                    token = termText3.substring(position + 1);
                    String replaceTermText = new String(replace.termBuffer(), 0, replace.termLength());
                    Token last = new Token(replace.startOffset(), replace.endOffset() + post.length());
                    last.setTermBuffer(replaceTermText + post);
                    last.setType(replace.type());
                    last.setPositionIncrement(replace.getPositionIncrement());
                    fixedTokenSequence.add(last);
                    replace = new Token(c.startOffset() - pre.length(), c.endOffset());
                    replace.setTermBuffer(language + pre + token);
                    replace.setType(c.type());
                    replace.setPositionIncrement(c.getPositionIncrement());
                    continue;
                }
                String replaceTermText = new String(replace.termBuffer(), 0, replace.termLength());
                Token last = new Token(replace.startOffset(), replace.endOffset() + post.length());
                last.setTermBuffer(replaceTermText + post);
                last.setType(replace.type());
                last.setPositionIncrement(replace.getPositionIncrement());
                fixedTokenSequence.add(last);
                replace = new Token(c.startOffset() - pre.length(), c.endOffset());
                replace.setTermBuffer(pre + termText3);
                replace.setType(c.type());
                replace.setPositionIncrement(c.getPositionIncrement());
            }
            if (replace == null) continue;
            StringBuilder postfix = new StringBuilder();
            if (replace.endOffset() >= 0 && replace.endOffset() < testText.length()) {
                char test;
                for (int i = replace.endOffset(); i < testText.length() && ((test = testText.charAt(i)) == '*' || test == '?') && wildcardPoistions.contains(i); ++i) {
                    postfix.append(test);
                }
            }
            String post = postfix.toString();
            int oldPositionIncrement = replace.getPositionIncrement();
            String replaceTermText = new String(replace.termBuffer(), 0, replace.termLength());
            replace = new Token(replace.startOffset(), replace.endOffset() + post.length());
            replace.setTermBuffer(replaceTermText + post);
            replace.setType(replace.type());
            replace.setPositionIncrement(oldPositionIncrement);
            fixedTokenSequence.add(replace);
        }
        ArrayList<Token> fixed = new ArrayList<Token>();
        for (LinkedList tokenSequence : fixedTokenSequences) {
            for (Token token : tokenSequence) {
                fixed.add(token);
            }
        }
        Collections.sort(fixed, new Comparator<Token>(){

            @Override
            public int compare(Token o1, Token o2) {
                int dif = o1.startOffset() - o2.startOffset();
                if (dif != 0) {
                    return dif;
                }
                return o1.getPositionIncrement() - o2.getPositionIncrement();
            }
        });
        OrderedHashSet unique = new OrderedHashSet();
        unique.addAll(fixed);
        fixed = new ArrayList(unique);
        list = fixed;
        if (localePrefix.length() > 0) {
            for (int j = 0; j < list.size(); ++j) {
                Token currentToken = (Token)list.get(j);
                String termText4 = new String(currentToken.termBuffer(), 0, currentToken.termLength());
                currentToken.setTermBuffer(localePrefix + termText4);
            }
        }
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            nextToken = (Token)list.get(0);
            String termText5 = new String(nextToken.termBuffer(), 0, nextToken.termLength());
            if (termText5.contains("*") || termText5.contains("?")) {
                return this.newWildcardQuery(new Term(field, this.getLowercaseExpandedTerms() ? termText5.toLowerCase() : termText5));
            }
            return this.newTermQuery(new Term(field, termText5));
        }
        if (severalTokensAtSamePosition) {
            if (positionCount == 1) {
                BooleanQuery q = this.newBooleanQuery(true);
                for (int i = 0; i < list.size(); ++i) {
                    nextToken = (Token)list.get(i);
                    String termText6 = new String(nextToken.termBuffer(), 0, nextToken.termLength());
                    Query currentQuery = termText6.contains("*") || termText6.contains("?") ? this.newWildcardQuery(new Term(field, this.getLowercaseExpandedTerms() ? termText6.toLowerCase() : termText6)) : this.newTermQuery(new Term(field, termText6));
                    q.add(currentQuery, BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            if (this.canUseMultiPhraseQuery(fixedTokenSequences)) {
                MultiPhraseQuery mpq = this.newMultiPhraseQuery();
                mpq.setSlop(this.internalSlop);
                ArrayList<Term> multiTerms = new ArrayList<Term>();
                int position = 0;
                for (int i = 0; i < list.size(); ++i) {
                    nextToken = (Token)list.get(i);
                    String termText7 = new String(nextToken.termBuffer(), 0, nextToken.termLength());
                    Term term = new Term(field, termText7);
                    if (termText7 != null && (termText7.contains("*") || termText7.contains("?"))) {
                        this.addWildcardTerms(multiTerms, term);
                    } else {
                        multiTerms.add(term);
                    }
                    if (nextToken.getPositionIncrement() > 0 && multiTerms.size() > 0) {
                        if (this.getEnablePositionIncrements()) {
                            mpq.add(multiTerms.toArray(new Term[0]), position);
                        } else {
                            mpq.add(multiTerms.toArray(new Term[0]));
                        }
                        this.checkTermCount(field, queryText, mpq);
                        multiTerms.clear();
                    }
                    position += nextToken.getPositionIncrement();
                }
                if (this.getEnablePositionIncrements()) {
                    if (multiTerms.size() > 0) {
                        mpq.add(multiTerms.toArray(new Term[0]), position);
                    }
                } else if (multiTerms.size() > 0) {
                    mpq.add(multiTerms.toArray(new Term[0]));
                }
                this.checkTermCount(field, queryText, mpq);
                return mpq;
            }
            BooleanQuery q = this.newBooleanQuery(true);
            for (LinkedList tokenSequence : fixedTokenSequences) {
                MultiPhraseQuery mpq = this.newMultiPhraseQuery();
                mpq.setSlop(this.internalSlop);
                int position = 0;
                for (int i = 0; i < tokenSequence.size(); ++i) {
                    nextToken = (Token)tokenSequence.get(i);
                    termText = new String(nextToken.termBuffer(), 0, nextToken.termLength());
                    Term term = new Term(field, termText);
                    if (this.getEnablePositionIncrements()) {
                        if (termText != null && (termText.contains("*") || termText.contains("?"))) {
                            mpq.add(this.getMatchingTerms(field, term), position);
                        } else {
                            mpq.add(new Term[]{term}, position);
                        }
                        this.checkTermCount(field, queryText, mpq);
                        if (nextToken.getPositionIncrement() > 0) {
                            position += nextToken.getPositionIncrement();
                            continue;
                        }
                        ++position;
                        continue;
                    }
                    if (termText != null && (termText.contains("*") || termText.contains("?"))) {
                        mpq.add(this.getMatchingTerms(field, term));
                    } else {
                        mpq.add(term);
                    }
                    this.checkTermCount(field, queryText, mpq);
                }
                q.add((Query)mpq, BooleanClause.Occur.SHOULD);
            }
            return q;
        }
        MultiPhraseQuery q = new MultiPhraseQuery();
        q.setSlop(this.internalSlop);
        int position = 0;
        for (int i = 0; i < list.size(); ++i) {
            nextToken = (Token)list.get(i);
            String termText8 = new String(nextToken.termBuffer(), 0, nextToken.termLength());
            Term term = new Term(field, termText8);
            if (this.getEnablePositionIncrements()) {
                if (termText8 != null && (termText8.contains("*") || termText8.contains("?"))) {
                    q.add(this.getMatchingTerms(field, term), position);
                } else {
                    q.add(new Term[]{term}, position);
                }
                this.checkTermCount(field, queryText, q);
                if (nextToken.getPositionIncrement() > 0) {
                    position += nextToken.getPositionIncrement();
                    continue;
                }
                ++position;
                continue;
            }
            if (termText8 != null && (termText8.contains("*") || termText8.contains("?"))) {
                q.add(this.getMatchingTerms(field, term));
            } else {
                q.add(term);
            }
            this.checkTermCount(field, queryText, q);
        }
        return q;
    }

    private void checkTermCount(String field, String queryText, MultiPhraseQuery mpq) {
        int termCount = 0;
        for (Term[] arr : mpq.getTermArrays()) {
            if ((termCount += arr.length) <= BooleanQuery.getMaxClauseCount()) continue;
            throw new LuceneQueryParserException("Wildcard has generated too many clauses: " + field + " " + queryText);
        }
    }

    private boolean canUseMultiPhraseQuery(LinkedList<LinkedList<Token>> fixedTokenSequences) {
        if (fixedTokenSequences.size() <= 1) {
            return true;
        }
        LinkedList<Token> first = fixedTokenSequences.get(0);
        for (int i = 1; i < fixedTokenSequences.size(); ++i) {
            LinkedList<Token> current = fixedTokenSequences.get(i);
            if (first.size() != current.size()) {
                return false;
            }
            for (int j = 0; j < first.size(); ++j) {
                Token fromFirst = first.get(j);
                Token fromCurrent = current.get(j);
                if (fromFirst.startOffset() == fromCurrent.startOffset()) continue;
                return false;
            }
        }
        return true;
    }

    private Set<Integer> getWildcardPositions(String string) {
        HashSet<Integer> wildcardPositions = new HashSet<Integer>();
        boolean lastWasEscape = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (lastWasEscape) {
                lastWasEscape = false;
                continue;
            }
            if (c == '\\') {
                lastWasEscape = true;
                continue;
            }
            if (c == '*') {
                wildcardPositions.add(i);
                continue;
            }
            if (c != '?') continue;
            wildcardPositions.add(i);
        }
        return wildcardPositions;
    }

    private Term[] getMatchingTerms(String field, Term term) throws ParseException {
        ArrayList<Term> terms = new ArrayList<Term>();
        this.addWildcardTerms(terms, term);
        if (terms.size() == 0) {
            return new Term[]{new Term(field, "\u0000")};
        }
        return terms.toArray(new Term[0]);
    }

    private void addWildcardTerms(ArrayList<Term> terms, Term term) throws ParseException {
        try {
            Term searchTerm = term;
            if (this.getLowercaseExpandedTerms()) {
                searchTerm = new Term(term.field(), term.text().toLowerCase());
            }
            WildcardTermEnum wcte = new WildcardTermEnum(this.indexReader, searchTerm);
            do {
                Term current;
                if ((current = wcte.term()) == null) continue;
                if (current.text() != null && current.text().length() > 0 && current.text().charAt(0) == '{') {
                    if (searchTerm == null || searchTerm.text().length() <= 0 || searchTerm.text().charAt(0) != '{') continue;
                    terms.add(current);
                    continue;
                }
                terms.add(current);
            } while (wcte.next());
        }
        catch (IOException e) {
            throw new ParseException("IO error generating phares wildcards " + e.getMessage());
        }
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        return this.getRangeQuery(field, part1, part2, inclusive, inclusive, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    public Query getRangeQuery(String field, String part1, String part2, boolean includeLower, boolean includeUpper, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        if (field.equals(FIELD_PATH)) {
            throw new UnsupportedOperationException("Range Queries are not support for PATH");
        }
        if (field.equals(FIELD_PATHWITHREPEATS)) {
            throw new UnsupportedOperationException("Range Queries are not support for PATHWITHREPEATS");
        }
        if (field.equals(FIELD_TEXT)) {
            Set<String> text = this.searchParameters.getTextAttributes();
            if (text == null || text.size() == 0) {
                Query query = this.getRangeQuery(PROPERTY_FIELD_PREFIX + ContentModel.PROP_CONTENT.toString(), part1, part2, includeLower, includeUpper, analysisMode, luceneFunction);
                if (query == null) {
                    return this.createNoMatchQuery();
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : text) {
                Query part = this.getRangeQuery(fieldName, part1, part2, includeLower, includeUpper, analysisMode, luceneFunction);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
            PropertyDefinition propertyDef = this.matchPropertyDefinition(field.substring(1));
            String fieldName = propertyDef != null ? PROPERTY_FIELD_PREFIX + propertyDef.getName() : this.expandAttributeFieldName(field);
            IndexTokenisationMode tokenisationMode = IndexTokenisationMode.TRUE;
            if (propertyDef != null && (tokenisationMode = propertyDef.getIndexTokenisationMode()) == null) {
                tokenisationMode = IndexTokenisationMode.TRUE;
            }
            if (propertyDef != null) {
                if (luceneFunction != LuceneFunction.FIELD) {
                    if (!(luceneFunction != LuceneFunction.LOWER || part1.toLowerCase().equals(part1) && part2.toLowerCase().equals(part2))) {
                        return this.createNoMatchQuery();
                    }
                    if (!(luceneFunction != LuceneFunction.UPPER || part1.toUpperCase().equals(part1) && part2.toUpperCase().equals(part2))) {
                        return this.createNoMatchQuery();
                    }
                    if (propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
                        BooleanQuery booleanQuery = new BooleanQuery();
                        MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
                        List<Locale> locales = this.searchParameters.getLocales();
                        ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
                        for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                            expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
                        }
                        for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                            this.addLocaleSpecificUntokenisedTextRangeFunction(fieldName, part1, part2, includeLower, includeUpper, luceneFunction, booleanQuery, mlAnalysisMode, locale, tokenisationMode);
                        }
                        return booleanQuery;
                    }
                    throw new UnsupportedOperationException("Lucene Function");
                }
                if (propertyDef.getDataType().getName().equals(DataTypeDefinition.MLTEXT)) {
                    throw new UnsupportedOperationException("Range is not supported against ml-text");
                }
                if (propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                    throw new UnsupportedOperationException("Range is not supported against content");
                }
                if (propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
                    BooleanQuery booleanQuery = new BooleanQuery();
                    MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
                    List<Locale> locales = this.searchParameters.getLocales();
                    ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
                    for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                        expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
                    }
                    for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                        this.addTextRange(field, part1, part2, includeLower, includeUpper, analysisMode, fieldName, propertyDef, tokenisationMode, booleanQuery, mlAnalysisMode, locale);
                    }
                    return booleanQuery;
                }
                if (propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                    String analyserClassName = propertyDef.resolveAnalyserClassName();
                    boolean usesDateTimeAnalyser = analyserClassName.equals(DateTimeAnalyser.class.getCanonicalName());
                    if (usesDateTimeAnalyser) {
                        int endResolution;
                        int startResolution;
                        Calendar end;
                        Calendar start;
                        block46: {
                            Date date;
                            SimpleDateFormat oldDf;
                            Pair result;
                            block45: {
                                start = Calendar.getInstance();
                                end = Calendar.getInstance();
                                try {
                                    result = CachingDateFormat.lenientParse((String)part1, (int)1);
                                    start.setTime((Date)result.getFirst());
                                    startResolution = (Integer)result.getSecond();
                                }
                                catch (java.text.ParseException e) {
                                    oldDf = CachingDateFormat.getDateFormat();
                                    try {
                                        date = oldDf.parse(part1);
                                        start.setTime(date);
                                        start.set(14, 0);
                                        startResolution = 13;
                                    }
                                    catch (java.text.ParseException ee) {
                                        if (part1.equalsIgnoreCase("min")) {
                                            start.set(1, start.getMinimum(1));
                                            start.set(6, start.getMinimum(6));
                                            start.set(11, start.getMinimum(11));
                                            start.set(12, start.getMinimum(12));
                                            start.set(13, start.getMinimum(13));
                                            start.set(14, start.getMinimum(14));
                                            startResolution = 14;
                                            break block45;
                                        }
                                        if (part1.equalsIgnoreCase("now")) {
                                            start.setTime(new Date());
                                            startResolution = 14;
                                            break block45;
                                        }
                                        if (part1.equalsIgnoreCase("today")) {
                                            start.setTime(new Date());
                                            start.set(11, start.getMinimum(11));
                                            start.set(12, start.getMinimum(12));
                                            start.set(13, start.getMinimum(13));
                                            start.set(14, start.getMinimum(14));
                                            startResolution = 5;
                                            break block45;
                                        }
                                        return this.createNoMatchQuery();
                                    }
                                }
                            }
                            try {
                                result = CachingDateFormat.lenientParse((String)part2, (int)1);
                                end.setTime((Date)result.getFirst());
                                endResolution = (Integer)result.getSecond();
                            }
                            catch (java.text.ParseException e) {
                                oldDf = CachingDateFormat.getDateFormat();
                                try {
                                    date = oldDf.parse(part2);
                                    end.setTime(date);
                                    end.set(14, 0);
                                    endResolution = 13;
                                }
                                catch (java.text.ParseException ee) {
                                    if (part2.equalsIgnoreCase("max")) {
                                        end.set(1, end.getMaximum(1));
                                        end.set(6, end.getMaximum(6));
                                        end.set(11, end.getMaximum(11));
                                        end.set(12, end.getMaximum(12));
                                        end.set(13, end.getMaximum(13));
                                        end.set(14, end.getMaximum(14));
                                        endResolution = 14;
                                        break block46;
                                    }
                                    if (part2.equalsIgnoreCase("now")) {
                                        end.setTime(new Date());
                                        endResolution = 14;
                                        break block46;
                                    }
                                    if (part2.equalsIgnoreCase("today")) {
                                        end.setTime(new Date());
                                        end.set(11, end.getMinimum(11));
                                        end.set(12, end.getMinimum(12));
                                        end.set(13, end.getMinimum(13));
                                        end.set(14, end.getMinimum(14));
                                        endResolution = 5;
                                        break block46;
                                    }
                                    return this.createNoMatchQuery();
                                }
                            }
                        }
                        Query rq = this.buildDateTimeRange(fieldName, start, startResolution, end, endResolution, includeLower, includeUpper);
                        return rq;
                    }
                    String first = this.getToken(fieldName, part1, AnalysisMode.DEFAULT);
                    String last = this.getToken(fieldName, part2, AnalysisMode.DEFAULT);
                    return new ConstantScoreRangeQuery(fieldName, first, last, includeLower, includeUpper);
                }
                String first = this.getToken(fieldName, part1, AnalysisMode.DEFAULT);
                String last = this.getToken(fieldName, part2, AnalysisMode.DEFAULT);
                return new ConstantScoreRangeQuery(fieldName, first, last, includeLower, includeUpper);
            }
            String first = this.getToken(fieldName, part1, AnalysisMode.DEFAULT);
            String last = this.getToken(fieldName, part2, AnalysisMode.DEFAULT);
            return new ConstantScoreRangeQuery(fieldName, first, last, includeLower, includeUpper);
        }
        if (field.equals(FIELD_ALL)) {
            Set<String> all = this.searchParameters.getAllAttributes();
            if (all == null || all.size() == 0) {
                Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(null);
                BooleanQuery query = new BooleanQuery();
                for (QName qname : contentAttributes) {
                    Query part = this.getRangeQuery(PROPERTY_FIELD_PREFIX + qname.toString(), part1, part2, includeLower, includeUpper, analysisMode, luceneFunction);
                    query.add(part, BooleanClause.Occur.SHOULD);
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : all) {
                Query part = this.getRangeQuery(fieldName, part1, part2, includeLower, includeUpper, analysisMode, luceneFunction);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (this.matchDataTypeDefinition(field) != null) {
            Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(this.matchDataTypeDefinition(field).getName());
            BooleanQuery query = new BooleanQuery();
            for (QName qname : contentAttributes) {
                Query part = this.getRangeQuery(PROPERTY_FIELD_PREFIX + qname.toString(), part1, part2, includeLower, includeUpper, analysisMode, luceneFunction);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_TAG)) {
            throw new UnsupportedOperationException("Range Queries are not support for TAG");
        }
        if (this.getLowercaseExpandedTerms()) {
            part1 = part1.toLowerCase();
            part2 = part2.toLowerCase();
        }
        return new ConstantScoreRangeQuery(field, part1, part2, includeLower, includeUpper);
    }

    protected abstract void addTextRange(String var1, String var2, String var3, boolean var4, boolean var5, AnalysisMode var6, String var7, PropertyDefinition var8, IndexTokenisationMode var9, BooleanQuery var10, MLAnalysisMode var11, Locale var12) throws ParseException;

    protected abstract void addLocaleSpecificUntokenisedTextRangeFunction(String var1, String var2, String var3, boolean var4, boolean var5, LuceneFunction var6, BooleanQuery var7, MLAnalysisMode var8, Locale var9, IndexTokenisationMode var10) throws ParseException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Query buildDateTimeRange(String field, Calendar startIn, int startResolution, Calendar endIn, int endResolution, boolean includeLower, boolean includeUpper) throws ParseException {
        int minResolution = startResolution <= endResolution ? startResolution : endResolution;
        Calendar start = Calendar.getInstance();
        start.setTime(startIn.getTime());
        if (!includeLower) {
            start.add(startResolution, 1);
        }
        Calendar end = Calendar.getInstance();
        end.setTime(endIn.getTime());
        if (!includeUpper) {
            end.add(endResolution, -1);
        }
        if (start.get(1) > end.get(1)) {
            return this.createNoMatchQuery();
        }
        if (start.get(1) == end.get(1)) {
            if (start.get(2) > end.get(2)) {
                return this.createNoMatchQuery();
            }
            if (start.get(2) == end.get(2)) {
                if (start.get(5) > end.get(5)) {
                    return this.createNoMatchQuery();
                }
                if (start.get(5) == end.get(5)) {
                    if (start.get(11) > end.get(11)) {
                        return this.createNoMatchQuery();
                    }
                    if (start.get(11) == end.get(11)) {
                        if (start.get(12) > end.get(12)) {
                            return this.createNoMatchQuery();
                        }
                        if (start.get(12) == end.get(12)) {
                            if (start.get(13) > end.get(13)) {
                                return this.createNoMatchQuery();
                            }
                            if (start.get(13) == end.get(13)) {
                                if (start.get(14) > end.get(14)) {
                                    return this.createNoMatchQuery();
                                }
                                if (start.get(14) == end.get(14)) {
                                    // empty if block
                                }
                            }
                        }
                    }
                }
            }
        }
        BooleanQuery query = new BooleanQuery();
        if (minResolution > 1 && start.get(1) == end.get(1)) {
            TermQuery part = new TermQuery(new Term(field, "YE" + start.get(1)));
            query.add((Query)part, BooleanClause.Occur.MUST);
            if (minResolution > 2 && start.get(2) == end.get(2)) {
                part = new TermQuery(new Term(field, this.build2SF("MO", start.get(2))));
                query.add((Query)part, BooleanClause.Occur.MUST);
                if (minResolution > 5 && start.get(5) == end.get(5)) {
                    part = new TermQuery(new Term(field, this.build2SF("DA", start.get(5))));
                    query.add((Query)part, BooleanClause.Occur.MUST);
                    if (minResolution > 11 && start.get(11) == end.get(11)) {
                        part = new TermQuery(new Term(field, this.build2SF("HO", start.get(11))));
                        query.add((Query)part, BooleanClause.Occur.MUST);
                        if (minResolution > 12 && start.get(12) == end.get(12)) {
                            part = new TermQuery(new Term(field, this.build2SF("MI", start.get(12))));
                            query.add((Query)part, BooleanClause.Occur.MUST);
                            if (minResolution > 13 && start.get(13) == end.get(13)) {
                                part = new TermQuery(new Term(field, this.build2SF("SE", start.get(13))));
                                query.add((Query)part, BooleanClause.Occur.MUST);
                                if (minResolution < 14) return this.createNoMatchQuery();
                                if (start.get(14) == end.get(14)) {
                                    part = new TermQuery(new Term(field, this.build3SF("MS", start.get(14))));
                                    query.add((Query)part, BooleanClause.Occur.MUST);
                                    return query;
                                } else {
                                    part = new ConstantScoreRangeQuery(field, this.build3SF("MS", start.get(14)), this.build3SF("MS", end.get(14)), true, true);
                                    query.add((Query)part, BooleanClause.Occur.MUST);
                                }
                                return query;
                            } else {
                                Query subPart;
                                BooleanQuery subQuery = new BooleanQuery();
                                for (int i : new int[]{14}) {
                                    subPart = this.buildStart(field, start, 13, i, startResolution);
                                    if (subPart == null) continue;
                                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                                }
                                if (13 < minResolution && end.get(13) - start.get(13) > 1) {
                                    subPart = new ConstantScoreRangeQuery(field, this.build2SF("SE", start.get(13)), this.build2SF("SE", end.get(13)), false, false);
                                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                                }
                                if (13 == minResolution) {
                                    if (start.get(13) == end.get(13)) {
                                        if (!includeLower || !includeUpper) return this.createNoMatchQuery();
                                        part = new TermQuery(new Term(field, this.build2SF("SE", start.get(13))));
                                        query.add((Query)part, BooleanClause.Occur.MUST);
                                    } else {
                                        subPart = new ConstantScoreRangeQuery(field, this.build2SF("SE", start.get(13)), this.build2SF("SE", end.get(13)), includeLower, includeUpper);
                                        subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                                    }
                                }
                                for (int i : new int[]{14}) {
                                    subPart = this.buildEnd(field, end, 13, i, endResolution);
                                    if (subPart == null) continue;
                                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                                }
                                if (subQuery.clauses().size() <= 0) return query;
                                query.add((Query)subQuery, BooleanClause.Occur.MUST);
                            }
                            return query;
                        } else {
                            Query subPart;
                            BooleanQuery subQuery = new BooleanQuery();
                            for (int i : new int[]{14, 13}) {
                                subPart = this.buildStart(field, start, 12, i, startResolution);
                                if (subPart == null) continue;
                                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                            }
                            if (12 < minResolution && end.get(12) - start.get(12) > 1) {
                                subPart = new ConstantScoreRangeQuery(field, this.build2SF("MI", start.get(12)), this.build2SF("MI", end.get(12)), false, false);
                                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                            }
                            if (12 == minResolution) {
                                if (start.get(12) == end.get(12)) {
                                    if (!includeLower || !includeUpper) return this.createNoMatchQuery();
                                    part = new TermQuery(new Term(field, this.build2SF("MI", start.get(12))));
                                    query.add((Query)part, BooleanClause.Occur.MUST);
                                } else {
                                    subPart = new ConstantScoreRangeQuery(field, this.build2SF("MI", start.get(12)), this.build2SF("MI", end.get(12)), includeLower, includeUpper);
                                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                                }
                            }
                            for (int i : new int[]{13, 14}) {
                                subPart = this.buildEnd(field, end, 12, i, endResolution);
                                if (subPart == null) continue;
                                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                            }
                            if (subQuery.clauses().size() <= 0) return query;
                            query.add((Query)subQuery, BooleanClause.Occur.MUST);
                        }
                        return query;
                    } else {
                        Query subPart;
                        BooleanQuery subQuery = new BooleanQuery();
                        for (int i : new int[]{14, 13, 12}) {
                            subPart = this.buildStart(field, start, 11, i, startResolution);
                            if (subPart == null) continue;
                            subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                        }
                        if (11 < minResolution && end.get(11) - start.get(11) > 1) {
                            subPart = new ConstantScoreRangeQuery(field, this.build2SF("HO", start.get(11)), this.build2SF("HO", end.get(11)), false, false);
                            subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                        }
                        if (11 == minResolution) {
                            if (start.get(11) == end.get(11)) {
                                if (!includeLower || !includeUpper) return this.createNoMatchQuery();
                                part = new TermQuery(new Term(field, this.build2SF("HO", start.get(11))));
                                query.add((Query)part, BooleanClause.Occur.MUST);
                            } else {
                                subPart = new ConstantScoreRangeQuery(field, this.build2SF("HO", start.get(11)), this.build2SF("HO", end.get(11)), includeLower, includeUpper);
                                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                            }
                        }
                        for (int i : new int[]{12, 13, 14}) {
                            subPart = this.buildEnd(field, end, 11, i, endResolution);
                            if (subPart == null) continue;
                            subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                        }
                        if (subQuery.clauses().size() <= 0) return query;
                        query.add((Query)subQuery, BooleanClause.Occur.MUST);
                    }
                    return query;
                } else {
                    Query subPart;
                    BooleanQuery subQuery = new BooleanQuery();
                    for (int i : new int[]{14, 13, 12, 11}) {
                        subPart = this.buildStart(field, start, 5, i, startResolution);
                        if (subPart == null) continue;
                        subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                    }
                    if (5 < minResolution && end.get(5) - start.get(5) > 1) {
                        subPart = new ConstantScoreRangeQuery(field, this.build2SF("DA", start.get(5)), this.build2SF("DA", end.get(5)), false, false);
                        subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                    }
                    if (5 == minResolution) {
                        if (start.get(5) == end.get(5)) {
                            if (!includeLower || !includeUpper) return this.createNoMatchQuery();
                            part = new TermQuery(new Term(field, this.build2SF("DA", start.get(5))));
                            query.add((Query)part, BooleanClause.Occur.MUST);
                        } else {
                            subPart = new ConstantScoreRangeQuery(field, this.build2SF("DA", start.get(5)), this.build2SF("DA", end.get(5)), includeLower, includeUpper);
                            subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                        }
                    }
                    for (int i : new int[]{11, 12, 13, 14}) {
                        subPart = this.buildEnd(field, end, 5, i, endResolution);
                        if (subPart == null) continue;
                        subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                    }
                    if (subQuery.clauses().size() <= 0) return query;
                    query.add((Query)subQuery, BooleanClause.Occur.MUST);
                }
                return query;
            } else {
                Query subPart;
                BooleanQuery subQuery = new BooleanQuery();
                for (int i : new int[]{14, 13, 12, 11, 5}) {
                    subPart = this.buildStart(field, start, 2, i, startResolution);
                    if (subPart == null) continue;
                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                }
                if (2 < minResolution && end.get(2) - start.get(2) > 1) {
                    subPart = new ConstantScoreRangeQuery(field, this.build2SF("MO", start.get(2)), this.build2SF("MO", end.get(2)), false, false);
                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                }
                if (2 == minResolution) {
                    if (start.get(2) == end.get(2)) {
                        if (!includeLower || !includeUpper) return this.createNoMatchQuery();
                        part = new TermQuery(new Term(field, this.build2SF("MO", start.get(2))));
                        query.add((Query)part, BooleanClause.Occur.MUST);
                    } else {
                        subPart = new ConstantScoreRangeQuery(field, this.build2SF("MO", start.get(2)), this.build2SF("MO", end.get(2)), includeLower, includeUpper);
                        subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                    }
                }
                for (int i : new int[]{5, 11, 12, 13, 14}) {
                    subPart = this.buildEnd(field, end, 2, i, endResolution);
                    if (subPart == null) continue;
                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                }
                if (subQuery.clauses().size() <= 0) return query;
                query.add((Query)subQuery, BooleanClause.Occur.MUST);
            }
            return query;
        } else {
            Query subPart;
            BooleanQuery subQuery = new BooleanQuery();
            for (int i : new int[]{14, 13, 12, 11, 5, 2}) {
                subPart = this.buildStart(field, start, 1, i, startResolution);
                if (subPart == null) continue;
                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
            }
            if (1 < minResolution && end.get(1) - start.get(1) > 1) {
                subPart = new ConstantScoreRangeQuery(field, "YE" + start.get(1), "YE" + end.get(1), false, false);
                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
            }
            if (1 == minResolution) {
                if (start.get(1) == end.get(1)) {
                    if (!includeLower || !includeUpper) return this.createNoMatchQuery();
                    TermQuery part = new TermQuery(new Term(field, "YE" + start.get(1)));
                    query.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    subPart = new ConstantScoreRangeQuery(field, "YE" + start.get(1), "YE" + end.get(1), includeLower, includeUpper);
                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                }
            }
            for (int i : new int[]{2, 5, 11, 12, 13, 14}) {
                subPart = this.buildEnd(field, end, 1, i, endResolution);
                if (subPart == null) continue;
                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
            }
            if (subQuery.clauses().size() <= 0) return query;
            query.add((Query)subQuery, BooleanClause.Occur.MUST);
        }
        return query;
    }

    private Query buildStart(String field, Calendar cal, int startField, int padField, int resolutionField) {
        BooleanQuery range = new BooleanQuery();
        switch (startField) {
            case 1: {
                TermQuery part;
                if (cal.get(1) == 1 && cal.get(2) == 0 && cal.get(5) == 1 && cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0) {
                    if (padField != 2) break;
                    if (1 <= resolutionField) {
                        TermQuery part2 = new TermQuery(new Term(field, "YE" + cal.get(1)));
                        range.add((Query)part2, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (padField == 1) {
                    return null;
                }
                if (1 <= resolutionField) {
                    part = new TermQuery(new Term(field, "YE" + cal.get(1)));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 2: {
                TermQuery part;
                if (cal.get(2) == 0 && cal.get(5) == 1 && cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0) {
                    if (padField != 5) break;
                    if (2 <= resolutionField) {
                        part = new TermQuery(new Term(field, this.build2SF("MO", cal.get(2))));
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (padField == 2) {
                    if (2 < resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("MO", cal.get(2) + 1), "MO" + cal.getMaximum(2), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    if (2 == resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("MO", cal.get(2)), "MO" + cal.getMaximum(2), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (2 <= resolutionField) {
                    part = new TermQuery(new Term(field, this.build2SF("MO", cal.get(2))));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 5: {
                TermQuery part;
                if (cal.get(5) == 1 && cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0) {
                    if (padField != 11) break;
                    if (5 <= resolutionField) {
                        part = new TermQuery(new Term(field, this.build2SF("DA", cal.get(5))));
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (padField == 5) {
                    if (5 < resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("DA", cal.get(5) + 1), "DA" + cal.getMaximum(5), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    if (5 == resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("DA", cal.get(5)), "DA" + cal.getMaximum(5), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (5 <= resolutionField) {
                    part = new TermQuery(new Term(field, this.build2SF("DA", cal.get(5))));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 11: {
                TermQuery part;
                if (cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0) {
                    if (padField != 12) break;
                    if (11 <= resolutionField) {
                        part = new TermQuery(new Term(field, this.build2SF("HO", cal.get(11))));
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (padField == 11) {
                    if (11 < resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("HO", cal.get(11) + 1), "HO" + cal.getMaximum(11), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    if (11 == resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("HO", cal.get(11)), "HO" + cal.getMaximum(11), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (11 <= resolutionField) {
                    part = new TermQuery(new Term(field, this.build2SF("HO", cal.get(11))));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 12: {
                TermQuery part;
                if (cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0) {
                    if (padField != 13) break;
                    if (12 <= resolutionField) {
                        part = new TermQuery(new Term(field, this.build2SF("MI", cal.get(12))));
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (padField == 12) {
                    if (12 < resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("MI", cal.get(12) + 1), "MI" + cal.getMaximum(12), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    if (12 == resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("MI", cal.get(12)), "MI" + cal.getMaximum(12), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (12 <= resolutionField) {
                    part = new TermQuery(new Term(field, this.build2SF("MI", cal.get(12))));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 13: {
                TermQuery part;
                if (cal.get(13) == 0 && cal.get(14) == 0) {
                    if (padField != 14) break;
                    if (13 <= resolutionField) {
                        part = new TermQuery(new Term(field, this.build2SF("SE", cal.get(13))));
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (padField == 13) {
                    if (13 < resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("SE", cal.get(13) + 1), "SE" + cal.getMaximum(13), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    if (13 == resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("SE", cal.get(13)), "SE" + cal.getMaximum(13), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (13 <= resolutionField) {
                    part = new TermQuery(new Term(field, this.build2SF("SE", cal.get(13))));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 14: {
                if (cal.get(14) <= 0 || cal.get(14) > cal.getMaximum(14) || 14 > resolutionField) break;
                TermQuery part = new ConstantScoreRangeQuery(field, this.build3SF("MS", cal.get(14)), "MS" + cal.getMaximum(14), true, true);
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
        }
        return this.getNonEmptyBooleanQuery(range);
    }

    private Query buildEnd(String field, Calendar cal, int startField, int padField, int resolutionField) {
        BooleanQuery range = new BooleanQuery();
        switch (startField) {
            case 1: {
                TermQuery part;
                if (padField == 1) {
                    if (1 < resolutionField) {
                        if (cal.get(1) > cal.getMinimum(1)) {
                            ConstantScoreRangeQuery part2 = new ConstantScoreRangeQuery(field, "YE" + cal.getMinimum(1), "YE" + (cal.get(1) - 1), true, true);
                            range.add((Query)part2, BooleanClause.Occur.MUST);
                            break;
                        }
                        return null;
                    }
                    if (1 == resolutionField) {
                        ConstantScoreRangeQuery part3 = new ConstantScoreRangeQuery(field, "YE" + cal.getMinimum(1), "YE" + cal.get(1), true, true);
                        range.add((Query)part3, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (1 <= resolutionField) {
                    part = new TermQuery(new Term(field, "YE" + cal.get(1)));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 2: {
                TermQuery part;
                if (padField == 2) {
                    if (2 < resolutionField) {
                        if (cal.get(2) > cal.getMinimum(2)) {
                            part = new ConstantScoreRangeQuery(field, this.build2SF("MO", cal.getMinimum(2)), this.build2SF("MO", cal.get(2) - 1), true, true);
                            range.add((Query)part, BooleanClause.Occur.MUST);
                            break;
                        }
                        return null;
                    }
                    if (2 == resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("MO", cal.getMinimum(2)), this.build2SF("MO", cal.get(2)), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (2 <= resolutionField) {
                    part = new TermQuery(new Term(field, this.build2SF("MO", cal.get(2))));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 5: {
                TermQuery part;
                if (padField == 5) {
                    if (5 < resolutionField) {
                        if (cal.get(5) > cal.getMinimum(5)) {
                            part = new ConstantScoreRangeQuery(field, this.build2SF("DA", cal.getMinimum(5)), this.build2SF("DA", cal.get(5) - 1), true, true);
                            range.add((Query)part, BooleanClause.Occur.MUST);
                            break;
                        }
                        return null;
                    }
                    if (5 == resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("DA", cal.getMinimum(5)), this.build2SF("DA", cal.get(5)), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (5 <= resolutionField) {
                    part = new TermQuery(new Term(field, this.build2SF("DA", cal.get(5))));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 11: {
                TermQuery part;
                if (padField == 11) {
                    if (11 < resolutionField) {
                        if (cal.get(11) > cal.getMinimum(11)) {
                            part = new ConstantScoreRangeQuery(field, this.build2SF("HO", cal.getMinimum(11)), this.build2SF("HO", cal.get(11) - 1), true, true);
                            range.add((Query)part, BooleanClause.Occur.MUST);
                            break;
                        }
                        return null;
                    }
                    if (11 == resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("HO", cal.getMinimum(11)), this.build2SF("HO", cal.get(11)), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (11 <= resolutionField) {
                    part = new TermQuery(new Term(field, this.build2SF("HO", cal.get(11))));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 12: {
                TermQuery part;
                if (padField == 12) {
                    if (12 < resolutionField) {
                        if (cal.get(12) > cal.getMinimum(12)) {
                            part = new ConstantScoreRangeQuery(field, this.build2SF("MI", cal.getMinimum(12)), this.build2SF("MI", cal.get(12) - 1), true, true);
                            range.add((Query)part, BooleanClause.Occur.MUST);
                            break;
                        }
                        return null;
                    }
                    if (12 == resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("MI", cal.getMinimum(12)), this.build2SF("MI", cal.get(12)), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (12 <= resolutionField) {
                    part = new TermQuery(new Term(field, this.build2SF("MI", cal.get(12))));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 13: {
                TermQuery part;
                if (padField == 13) {
                    if (13 < resolutionField) {
                        if (cal.get(13) > cal.getMinimum(13)) {
                            part = new ConstantScoreRangeQuery(field, this.build2SF("SE", cal.getMinimum(13)), this.build2SF("SE", cal.get(13) - 1), true, true);
                            range.add((Query)part, BooleanClause.Occur.MUST);
                            break;
                        }
                        return null;
                    }
                    if (13 == resolutionField) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("SE", cal.getMinimum(13)), this.build2SF("SE", cal.get(13)), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                if (13 <= resolutionField) {
                    part = new TermQuery(new Term(field, this.build2SF("SE", cal.get(13))));
                    range.add((Query)part, BooleanClause.Occur.MUST);
                } else {
                    return null;
                }
            }
            case 14: {
                if (cal.get(14) < cal.getMinimum(14) || cal.get(14) >= cal.getMaximum(14) || 14 > resolutionField) break;
                TermQuery part = new ConstantScoreRangeQuery(field, this.build3SF("MS", cal.getMinimum(14)), this.build3SF("MS", cal.get(14)), true, true);
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
        }
        return this.getNonEmptyBooleanQuery(range);
    }

    private String build2SF(String prefix, int value) {
        if (value < 10) {
            return prefix + "0" + value;
        }
        return prefix + value;
    }

    private String build3SF(String prefix, int value) {
        if (value < 10) {
            return prefix + "00" + value;
        }
        if (value < 100) {
            return prefix + "0" + value;
        }
        return prefix + value;
    }

    private String expandAttributeFieldName(String field) {
        return PROPERTY_FIELD_PREFIX + this.expandQName(field.substring(1));
    }

    private String expandQName(String qnameString) {
        String fieldName = qnameString;
        if (qnameString.charAt(0) != '{') {
            String prefix;
            String uri;
            int colonPosition = qnameString.indexOf(58);
            fieldName = colonPosition == -1 ? "{" + this.searchParameters.getNamespace() + "}" + qnameString : ((uri = this.matchURI(prefix = qnameString.substring(0, colonPosition))) == null ? "{" + this.searchParameters.getNamespace() + "}" + qnameString : "{" + uri + "}" + qnameString.substring(colonPosition + 1));
        }
        return fieldName;
    }

    private String matchURI(String prefix) {
        HashSet<String> prefixes = new HashSet<String>(this.namespacePrefixResolver.getPrefixes());
        if (prefixes.contains(prefix)) {
            return this.namespacePrefixResolver.getNamespaceURI(prefix);
        }
        String match = null;
        for (String candidate : prefixes) {
            if (!candidate.equalsIgnoreCase(prefix)) continue;
            if (match == null) {
                match = candidate;
                continue;
            }
            throw new LuceneQueryParserException("Ambiguous namespace prefix " + prefix);
        }
        if (match == null) {
            return null;
        }
        return this.namespacePrefixResolver.getNamespaceURI(match);
    }

    protected String getToken(String field, String value, AnalysisMode analysisMode) throws ParseException {
        TokenStream source = this.getAnalyzer().tokenStream(field, new StringReader(value), analysisMode);
        Token reusableToken = new Token();
        String tokenised = null;
        while (true) {
            Token nextToken;
            try {
                nextToken = source.next(reusableToken);
            }
            catch (IOException e) {
                nextToken = null;
            }
            if (nextToken == null) break;
            tokenised = new String(nextToken.termBuffer(), 0, nextToken.termLength());
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return tokenised;
    }

    public Query getPrefixQuery(String field, String termStr) throws ParseException {
        return this.getPrefixQuery(field, termStr, AnalysisMode.PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query getPrefixQuery(String field, String termStr, AnalysisMode analysisMode) throws ParseException {
        if (field.equals(FIELD_PATH)) {
            throw new UnsupportedOperationException("Prefix Queries are not support for PATH");
        }
        if (field.equals(FIELD_PATHWITHREPEATS)) {
            throw new UnsupportedOperationException("Prefix Queries are not support for PATHWITHREPEATS");
        }
        if (field.equals(FIELD_TEXT)) {
            Set<String> text = this.searchParameters.getTextAttributes();
            if (text == null || text.size() == 0) {
                Query query = this.getPrefixQuery(PROPERTY_FIELD_PREFIX + ContentModel.PROP_CONTENT.toString(), termStr, analysisMode);
                if (query == null) {
                    return this.createNoMatchQuery();
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : text) {
                Query part = this.getPrefixQuery(fieldName, termStr, analysisMode);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_ID) || field.equals(FIELD_DBID) || field.equals(FIELD_ISROOT) || field.equals(FIELD_ISCONTAINER) || field.equals(FIELD_ISNODE) || field.equals(FIELD_TX) || field.equals(FIELD_PARENT) || field.equals(FIELD_PRIMARYPARENT) || field.equals(FIELD_QNAME) || field.equals(FIELD_PRIMARYASSOCTYPEQNAME) || field.equals(FIELD_ASSOCTYPEQNAME)) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getPrefixQuery(field, termStr);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        if (field.equals(FIELD_CLASS)) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.equals(FIELD_TYPE)) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.equals(FIELD_EXACTTYPE)) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.equals(FIELD_ASPECT)) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.equals(FIELD_EXACTASPECT)) {
            return super.getPrefixQuery(field, termStr);
        }
        if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
            return this.attributeQueryBuilder(field, termStr, new PrefixQuery(), analysisMode, LuceneFunction.FIELD);
        }
        if (field.equals(FIELD_ALL)) {
            Set<String> all = this.searchParameters.getAllAttributes();
            if (all == null || all.size() == 0) {
                Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(null);
                BooleanQuery query = new BooleanQuery();
                for (QName qname : contentAttributes) {
                    Query part = this.getPrefixQuery(PROPERTY_FIELD_PREFIX + qname.toString(), termStr, analysisMode);
                    if (part != null) {
                        query.add(part, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : all) {
                Query part = this.getPrefixQuery(fieldName, termStr, analysisMode);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_ISUNSET)) {
            throw new UnsupportedOperationException("Prefix Queries are not support for ISUNSET");
        }
        if (field.equals(FIELD_ISNULL)) {
            throw new UnsupportedOperationException("Prefix Queries are not support for ISNULL");
        }
        if (field.equals(FIELD_ISNOTNULL)) {
            throw new UnsupportedOperationException("Prefix Queries are not support for ISNOTNULL");
        }
        if (this.matchDataTypeDefinition(field) != null) {
            Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(this.matchDataTypeDefinition(field).getName());
            BooleanQuery query = new BooleanQuery();
            for (QName qname : contentAttributes) {
                Query part = this.getPrefixQuery(PROPERTY_FIELD_PREFIX + qname.toString(), termStr, analysisMode);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_FTSSTATUS)) {
            throw new UnsupportedOperationException("Prefix Queries are not support for FTSSTATUS");
        }
        if (field.equals(FIELD_TAG)) {
            return null;
        }
        return super.getPrefixQuery(field, termStr);
    }

    public Query getWildcardQuery(String field, String termStr) throws ParseException {
        return this.getWildcardQuery(field, termStr, AnalysisMode.WILD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query getWildcardQuery(String field, String termStr, AnalysisMode analysisMode) throws ParseException {
        if (field.equals(FIELD_PATH)) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for PATH");
        }
        if (field.equals(FIELD_PATHWITHREPEATS)) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for PATHWITHREPEATS");
        }
        if (field.equals(FIELD_TEXT)) {
            Set<String> text = this.searchParameters.getTextAttributes();
            if (text == null || text.size() == 0) {
                Query query = this.getWildcardQuery(PROPERTY_FIELD_PREFIX + ContentModel.PROP_CONTENT.toString(), termStr, analysisMode);
                if (query == null) {
                    return this.createNoMatchQuery();
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : text) {
                Query part = this.getWildcardQuery(fieldName, termStr, analysisMode);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_ID) || field.equals(FIELD_DBID) || field.equals(FIELD_ISROOT) || field.equals(FIELD_ISCONTAINER) || field.equals(FIELD_ISNODE) || field.equals(FIELD_TX) || field.equals(FIELD_PARENT) || field.equals(FIELD_PRIMARYPARENT) || field.equals(FIELD_QNAME) || field.equals(FIELD_PRIMARYASSOCTYPEQNAME) || field.equals(FIELD_ASSOCTYPEQNAME)) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getWildcardQuery(field, termStr);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        if (field.equals(FIELD_CLASS)) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.equals(FIELD_TYPE)) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.equals(FIELD_EXACTTYPE)) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.equals(FIELD_ASPECT)) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.equals(FIELD_EXACTASPECT)) {
            return super.getWildcardQuery(field, termStr);
        }
        if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
            return this.attributeQueryBuilder(field, termStr, new WildcardQuery(), analysisMode, LuceneFunction.FIELD);
        }
        if (field.equals(FIELD_ALL)) {
            Set<String> all = this.searchParameters.getAllAttributes();
            if (all == null || all.size() == 0) {
                Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(null);
                BooleanQuery query = new BooleanQuery();
                for (QName qname : contentAttributes) {
                    Query part = this.getWildcardQuery(PROPERTY_FIELD_PREFIX + qname.toString(), termStr, analysisMode);
                    if (part != null) {
                        query.add(part, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : all) {
                Query part = this.getWildcardQuery(fieldName, termStr, analysisMode);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_ISUNSET)) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for ISUNSET");
        }
        if (field.equals(FIELD_ISNULL)) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for ISNULL");
        }
        if (field.equals(FIELD_ISNOTNULL)) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for ISNOTNULL");
        }
        if (this.matchDataTypeDefinition(field) != null) {
            Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(this.matchDataTypeDefinition(field).getName());
            BooleanQuery query = new BooleanQuery();
            for (QName qname : contentAttributes) {
                Query part = this.getWildcardQuery(PROPERTY_FIELD_PREFIX + qname.toString(), termStr, analysisMode);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_FTSSTATUS)) {
            throw new UnsupportedOperationException("Wildcard Queries are not support for FTSSTATUS");
        }
        if (field.equals(FIELD_TAG)) {
            return null;
        }
        return super.getWildcardQuery(field, termStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (field.equals(FIELD_PATH)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for PATH");
        }
        if (field.equals(FIELD_PATHWITHREPEATS)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for PATHWITHREPEATS");
        }
        if (field.equals(FIELD_TEXT)) {
            Set<String> text = this.searchParameters.getTextAttributes();
            if (text == null || text.size() == 0) {
                Query query = this.getFuzzyQuery(PROPERTY_FIELD_PREFIX + ContentModel.PROP_CONTENT.toString(), termStr, minSimilarity);
                if (query == null) {
                    return this.createNoMatchQuery();
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : text) {
                Query part = this.getFuzzyQuery(fieldName, termStr, minSimilarity);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_ID) || field.equals(FIELD_DBID) || field.equals(FIELD_ISROOT) || field.equals(FIELD_ISCONTAINER) || field.equals(FIELD_ISNODE) || field.equals(FIELD_TX) || field.equals(FIELD_PARENT) || field.equals(FIELD_PRIMARYPARENT) || field.equals(FIELD_QNAME) || field.equals(FIELD_PRIMARYASSOCTYPEQNAME) || field.equals(FIELD_ASSOCTYPEQNAME)) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getFuzzyQuery(field, termStr, minSimilarity);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        if (field.equals(FIELD_CLASS)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for CLASS");
        }
        if (field.equals(FIELD_TYPE)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for TYPE");
        }
        if (field.equals(FIELD_EXACTTYPE)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for EXACTTYPE");
        }
        if (field.equals(FIELD_ASPECT)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for ASPECT");
        }
        if (field.equals(FIELD_EXACTASPECT)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for EXACTASPECT");
        }
        if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
            return this.attributeQueryBuilder(field, termStr, new FuzzyQuery(minSimilarity), AnalysisMode.FUZZY, LuceneFunction.FIELD);
        }
        if (field.equals(FIELD_ALL)) {
            Set<String> all = this.searchParameters.getAllAttributes();
            if (all == null || all.size() == 0) {
                Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(null);
                BooleanQuery query = new BooleanQuery();
                for (QName qname : contentAttributes) {
                    Query part = this.getFuzzyQuery(PROPERTY_FIELD_PREFIX + qname.toString(), termStr, minSimilarity);
                    if (part != null) {
                        query.add(part, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : all) {
                Query part = this.getFuzzyQuery(fieldName, termStr, minSimilarity);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_ISUNSET)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for ISUNSET");
        }
        if (field.equals(FIELD_ISNULL)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for ISNULL");
        }
        if (field.equals(FIELD_ISNOTNULL)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for ISNOTNULL");
        }
        if (this.matchDataTypeDefinition(field) != null) {
            Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(this.matchDataTypeDefinition(field).getName());
            BooleanQuery query = new BooleanQuery();
            for (QName qname : contentAttributes) {
                Query part = this.getFuzzyQuery(PROPERTY_FIELD_PREFIX + qname.toString(), termStr, minSimilarity);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_FTSSTATUS)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for FTSSTATUS");
        }
        if (field.equals(FIELD_TAG)) {
            throw new UnsupportedOperationException("Fuzzy Queries are not support for TAG");
        }
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public Query getSuperFieldQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        return this.getFieldQueryImpl(field, queryText, analysisMode, luceneFunction);
    }

    public Query getSuperFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    public Query getSuperPrefixQuery(String field, String termStr) throws ParseException {
        return super.getPrefixQuery(field, termStr);
    }

    public Query getSuperWildcardQuery(String field, String termStr) throws ParseException {
        return super.getWildcardQuery(field, termStr);
    }

    protected Query newWildcardQuery(Term t) {
        if (t.text().contains("\\")) {
            String regexp = SearchLanguageConversion.convert(SearchLanguageConversion.DEF_LUCENE, SearchLanguageConversion.DEF_REGEX, t.text());
            return new RegexQuery(new Term(t.field(), regexp));
        }
        return super.newWildcardQuery(t);
    }

    protected Query newPrefixQuery(Term prefix) {
        if (prefix.text().contains("\\")) {
            String regexp = SearchLanguageConversion.convert(SearchLanguageConversion.DEF_LUCENE, SearchLanguageConversion.DEF_REGEX, prefix.text());
            return new RegexQuery(new Term(prefix.field(), regexp));
        }
        return super.newPrefixQuery(prefix);
    }

    private String translateLocale(String localised) {
        if (localised.startsWith("\u0000")) {
            if (localised.startsWith("\u0000\u0000")) {
                if (localised.length() < 3) {
                    return "";
                }
                return localised.substring(2);
            }
            int end = localised.indexOf(0, 1);
            if (end == -1) {
                return localised;
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("{");
            buffer.append(localised.substring(1, end));
            buffer.append("}");
            buffer.append(localised.substring(end + 1));
            return buffer.toString();
        }
        return localised;
    }

    private Query spanQueryBuilder(String field, String first, String last, int slop, boolean inOrder) {
        QName propertyQName;
        String expandedFieldName;
        String propertyFieldName = field.substring(1);
        PropertyDefinition propertyDef = this.matchPropertyDefinition(propertyFieldName);
        IndexTokenisationMode tokenisationMode = IndexTokenisationMode.TRUE;
        if (propertyDef != null) {
            tokenisationMode = propertyDef.getIndexTokenisationMode();
            if (tokenisationMode == null) {
                tokenisationMode = IndexTokenisationMode.TRUE;
            }
            expandedFieldName = PROPERTY_FIELD_PREFIX + propertyDef.getName();
            propertyQName = propertyDef.getName();
        } else {
            expandedFieldName = this.expandAttributeFieldName(field);
            propertyQName = QName.createQName(propertyFieldName);
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.MLTEXT)) {
            BooleanQuery booleanQuery = new BooleanQuery();
            MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            List<Locale> locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                this.addMLTextSpanQuery(field, first, last, slop, inOrder, expandedFieldName, propertyDef, tokenisationMode, booleanQuery, mlAnalysisMode, locale);
            }
            return booleanQuery;
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
            MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            List<Locale> locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, this.addContentCrossLocaleWildcards()));
            }
            return this.addContentSpanQuery(field, first, last, slop, inOrder, expandedFieldName, expandedLocales, mlAnalysisMode);
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
            BooleanQuery booleanQuery = new BooleanQuery();
            MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            List<Locale> locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                this.addTextSpanQuery(field, first, last, slop, inOrder, expandedFieldName, tokenisationMode, booleanQuery, mlAnalysisMode, locale);
            }
            return booleanQuery;
        }
        throw new UnsupportedOperationException("Span queries are only supported for d:text, d:mltext and d:content data types");
    }

    protected abstract void addTextSpanQuery(String var1, String var2, String var3, int var4, boolean var5, String var6, IndexTokenisationMode var7, BooleanQuery var8, MLAnalysisMode var9, Locale var10);

    protected abstract Query addContentSpanQuery(String var1, String var2, String var3, int var4, boolean var5, String var6, List<Locale> var7, MLAnalysisMode var8);

    protected abstract void addMLTextSpanQuery(String var1, String var2, String var3, int var4, boolean var5, String var6, PropertyDefinition var7, IndexTokenisationMode var8, BooleanQuery var9, MLAnalysisMode var10, Locale var11);

    private Query attributeQueryBuilder(String field, String queryText, SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        Query query;
        QName propertyQName;
        String expandedFieldName;
        String propertyFieldName = null;
        String ending = "";
        if (field.endsWith(FIELD_MIMETYPE_SUFFIX)) {
            propertyFieldName = field.substring(1, field.length() - FIELD_MIMETYPE_SUFFIX.length());
            ending = FIELD_MIMETYPE_SUFFIX;
        } else if (field.endsWith(FIELD_SIZE_SUFFIX)) {
            propertyFieldName = field.substring(1, field.length() - FIELD_SIZE_SUFFIX.length());
            ending = FIELD_SIZE_SUFFIX;
        } else if (field.endsWith(FIELD_LOCALE_SUFFIX)) {
            propertyFieldName = field.substring(1, field.length() - FIELD_LOCALE_SUFFIX.length());
            ending = FIELD_LOCALE_SUFFIX;
        } else if (field.endsWith(FIELD_ENCODING_SUFFIX)) {
            propertyFieldName = field.substring(1, field.length() - FIELD_ENCODING_SUFFIX.length());
            ending = FIELD_ENCODING_SUFFIX;
        } else if (field.endsWith(FIELD_CONTENT_DOC_ID_SUFFIX)) {
            propertyFieldName = field.substring(1, field.length() - FIELD_CONTENT_DOC_ID_SUFFIX.length());
            ending = FIELD_CONTENT_DOC_ID_SUFFIX;
        } else if (field.endsWith(FIELD_TRANSFORMATION_EXCEPTION_SUFFIX)) {
            propertyFieldName = field.substring(1, field.length() - FIELD_TRANSFORMATION_EXCEPTION_SUFFIX.length());
            ending = FIELD_TRANSFORMATION_EXCEPTION_SUFFIX;
        } else if (field.endsWith(FIELD_TRANSFORMATION_TIME_SUFFIX)) {
            propertyFieldName = field.substring(1, field.length() - FIELD_TRANSFORMATION_TIME_SUFFIX.length());
            ending = FIELD_TRANSFORMATION_TIME_SUFFIX;
        } else if (field.endsWith(FIELD_TRANSFORMATION_STATUS_SUFFIX)) {
            propertyFieldName = field.substring(1, field.length() - FIELD_TRANSFORMATION_STATUS_SUFFIX.length());
            ending = FIELD_TRANSFORMATION_STATUS_SUFFIX;
        } else {
            propertyFieldName = field.substring(1);
        }
        PropertyDefinition propertyDef = this.matchPropertyDefinition(propertyFieldName);
        IndexTokenisationMode tokenisationMode = IndexTokenisationMode.TRUE;
        if (propertyDef != null) {
            tokenisationMode = propertyDef.getIndexTokenisationMode();
            if (tokenisationMode == null) {
                tokenisationMode = IndexTokenisationMode.TRUE;
            }
            expandedFieldName = PROPERTY_FIELD_PREFIX + propertyDef.getName() + ending;
            propertyQName = propertyDef.getName();
        } else {
            expandedFieldName = this.expandAttributeFieldName(field);
            propertyQName = QName.createQName(propertyFieldName);
        }
        if (luceneFunction != LuceneFunction.FIELD && (tokenisationMode == IndexTokenisationMode.FALSE || tokenisationMode == IndexTokenisationMode.BOTH)) {
            if (luceneFunction == LuceneFunction.LOWER && !queryText.toLowerCase().equals(queryText)) {
                return this.createNoMatchQuery();
            }
            if (luceneFunction == LuceneFunction.UPPER && !queryText.toUpperCase().equals(queryText)) {
                return this.createNoMatchQuery();
            }
            return this.functionQueryBuilder(expandedFieldName, propertyQName, propertyDef, tokenisationMode, queryText, luceneFunction);
        }
        if (expandedFieldName.endsWith(FIELD_MIMETYPE_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_SIZE_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_LOCALE_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_ENCODING_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_TRANSFORMATION_STATUS_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_TRANSFORMATION_TIME_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : expandedFieldName.endsWith(FIELD_TRANSFORMATION_EXCEPTION_SUFFIX) && propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT))))))) {
            return subQueryBuilder.getQuery(expandedFieldName, queryText, analysisMode, luceneFunction);
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.MLTEXT)) {
            BooleanQuery booleanQuery = new BooleanQuery();
            MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            List<Locale> locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                this.addMLTextAttributeQuery(field, queryText, subQueryBuilder, analysisMode, luceneFunction, expandedFieldName, propertyDef, tokenisationMode, booleanQuery, mlAnalysisMode, locale);
            }
            return this.getNonEmptyBooleanQuery(booleanQuery);
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
            MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            List<Locale> locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, this.addContentCrossLocaleWildcards()));
            }
            return this.addContentAttributeQuery(queryText, subQueryBuilder, analysisMode, luceneFunction, expandedFieldName, expandedLocales, mlAnalysisMode);
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
            if ((propertyQName.equals(ContentModel.PROP_USER_USERNAME) || propertyQName.equals(ContentModel.PROP_USERNAME) || propertyQName.equals(ContentModel.PROP_AUTHORITY_NAME)) && this.isLucene()) {
                return subQueryBuilder.getQuery(expandedFieldName, queryText, analysisMode, luceneFunction);
            }
            boolean withWildCards = propertyQName.equals(ContentModel.PROP_USER_USERNAME) || propertyQName.equals(ContentModel.PROP_USERNAME) || propertyQName.equals(ContentModel.PROP_AUTHORITY_NAME);
            BooleanQuery booleanQuery = new BooleanQuery();
            MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            List<Locale> locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, withWildCards));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                this.addTextAttributeQuery(field, queryText, subQueryBuilder, analysisMode, luceneFunction, expandedFieldName, tokenisationMode, booleanQuery, mlAnalysisMode, locale);
            }
            return this.getNonEmptyBooleanQuery(booleanQuery);
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME) && analysisMode == AnalysisMode.LIKE) {
            throw new UnsupportedOperationException("Wild cards are not supported for the datetime type");
        }
        if (propertyDef != null && this.tenantService.isTenantUser() && propertyDef.getDataType().getName().equals(DataTypeDefinition.NODE_REF) && queryText.contains("://")) {
            queryText = this.tenantService.getName(new NodeRef(queryText)).toString();
        }
        if ((query = subQueryBuilder.getQuery(expandedFieldName, queryText, AnalysisMode.DEFAULT, luceneFunction)) != null) {
            return query;
        }
        return this.createNoMatchQuery();
    }

    protected abstract boolean isLucene();

    protected abstract void addTextAttributeQuery(String var1, String var2, SubQuery var3, AnalysisMode var4, LuceneFunction var5, String var6, IndexTokenisationMode var7, BooleanQuery var8, MLAnalysisMode var9, Locale var10) throws ParseException;

    protected abstract Query addContentAttributeQuery(String var1, SubQuery var2, AnalysisMode var3, LuceneFunction var4, String var5, List<Locale> var6, MLAnalysisMode var7) throws ParseException;

    protected abstract void addMLTextAttributeQuery(String var1, String var2, SubQuery var3, AnalysisMode var4, LuceneFunction var5, String var6, PropertyDefinition var7, IndexTokenisationMode var8, BooleanQuery var9, MLAnalysisMode var10, Locale var11) throws ParseException;

    protected Query functionQueryBuilder(String expandedFieldName, QName propertyQName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, String queryText, LuceneFunction luceneFunction) throws ParseException {
        if (expandedFieldName.endsWith(FIELD_MIMETYPE_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_SIZE_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_LOCALE_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_ENCODING_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_CONTENT_DOC_ID_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_TRANSFORMATION_EXCEPTION_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_TRANSFORMATION_TIME_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : expandedFieldName.endsWith(FIELD_TRANSFORMATION_STATUS_SUFFIX) && propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)))))))) {
            throw new UnsupportedOperationException("Lucene Function");
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.MLTEXT)) {
            BooleanQuery booleanQuery = new BooleanQuery();
            MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            List<Locale> locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                this.addLocaleSpecificUntokenisedMLOrTextFunction(expandedFieldName, queryText, luceneFunction, booleanQuery, mlAnalysisMode, locale, tokenisationMode);
            }
            return booleanQuery;
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
            throw new UnsupportedOperationException("Lucene functions not supported for content");
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
            if (propertyQName.equals(ContentModel.PROP_USER_USERNAME) || propertyQName.equals(ContentModel.PROP_USERNAME) || propertyQName.equals(ContentModel.PROP_AUTHORITY_NAME)) {
                throw new UnsupportedOperationException("Functions are not supported agaisnt special text fields");
            }
            boolean withWildCards = propertyQName.equals(ContentModel.PROP_USER_USERNAME) || propertyQName.equals(ContentModel.PROP_USERNAME) || propertyQName.equals(ContentModel.PROP_AUTHORITY_NAME);
            BooleanQuery booleanQuery = new BooleanQuery();
            MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            List<Locale> locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, withWildCards));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                this.addLocaleSpecificUntokenisedMLOrTextFunction(expandedFieldName, queryText, luceneFunction, booleanQuery, mlAnalysisMode, locale, tokenisationMode);
            }
            return booleanQuery;
        }
        throw new UnsupportedOperationException("Lucene Function");
    }

    protected abstract void addLocaleSpecificUntokenisedMLOrTextFunction(String var1, String var2, LuceneFunction var3, BooleanQuery var4, MLAnalysisMode var5, Locale var6, IndexTokenisationMode var7);

    protected TermQuery createNoMatchQuery() {
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    public static void main(String[] args) throws ParseException, java.text.ParseException {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)false);
        Date date = df.parse("2011-09-31T00:00:00.000");
        System.out.println(date);
        start.setTime(date);
        System.out.println(start);
        date = df.parse("2011-10-28T00:00:00.000");
        System.out.println(date);
        end.setTime(date);
        System.out.println(end);
        LuceneQueryParser lqp = new LuceneQueryParser(null, null);
        Query query = lqp.buildDateTimeRange("WOOF", start, 5, end, 5, true, true);
        System.out.println("Query is " + query);
    }

    public AbstractAnalyzer getAnalyzer() {
        return this.luceneAnalyser;
    }

    protected BooleanQuery getNonEmptyBooleanQuery(BooleanQuery booleanQuery) {
        if (booleanQuery.clauses().size() > 0) {
            return booleanQuery;
        }
        return null;
    }

    class WildcardQuery
    implements SubQuery {
        WildcardQuery() {
        }

        @Override
        public Query getQuery(String field, String termStr, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            return AbstractLuceneQueryParser.this.getSuperFieldQuery(field, termStr, analysisMode, luceneFunction);
        }
    }

    class PrefixQuery
    implements SubQuery {
        PrefixQuery() {
        }

        @Override
        public Query getQuery(String field, String termStr, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            StringBuilder builder = new StringBuilder(termStr.length() + 1);
            builder.append(termStr);
            builder.append("*");
            return AbstractLuceneQueryParser.this.getSuperFieldQuery(field, builder.toString(), analysisMode, luceneFunction);
        }
    }

    class FuzzyQuery
    implements SubQuery {
        float minSimilarity;

        FuzzyQuery(float minSimilarity) {
            this.minSimilarity = minSimilarity;
        }

        @Override
        public Query getQuery(String field, String termStr, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            return AbstractLuceneQueryParser.this.getSuperFuzzyQuery(field, AbstractLuceneQueryParser.this.translateLocale(termStr), this.minSimilarity);
        }
    }

    class FieldQuery
    implements SubQuery {
        FieldQuery() {
        }

        @Override
        public Query getQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            return AbstractLuceneQueryParser.this.getSuperFieldQuery(field, queryText, analysisMode, luceneFunction);
        }
    }

    public static interface SubQuery {
        public Query getQuery(String var1, String var2, AnalysisMode var3, LuceneFunction var4) throws ParseException;
    }
}

