/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchParameters;
import org.springframework.extensions.surf.util.I18NUtil;

public class QueryOptions {
    private String query;
    private List<StoreRef> stores = new ArrayList<StoreRef>(1);
    private int maxItems = -1;
    private int skipCount = 0;
    private Connective defaultFTSConnective = Connective.AND;
    private Connective defaultFTSFieldConnective = Connective.AND;
    private List<Locale> locales = new ArrayList<Locale>(1);
    private MLAnalysisMode mlAnalaysisMode = MLAnalysisMode.EXACT_LANGUAGE_AND_ALL;
    private List<QueryParameterDefinition> queryParameterDefinitions = new ArrayList<QueryParameterDefinition>(4);
    private boolean includeInTransactionData = true;
    private int maxPermissionChecks = -1;
    private long maxPermissionCheckTimeMillis = -1L;
    private String defaultFieldName = "TEXT";
    private Boolean useInMemorySort;
    private Integer maxRawResultSetSizeForInMemorySort;
    private boolean excludeTenantFilter = false;
    private boolean isBulkFetchEnabled = true;
    private QueryConsistency queryConsistency = QueryConsistency.DEFAULT;

    public static QueryOptions create(SearchParameters searchParameters) {
        QueryOptions options = new QueryOptions(searchParameters.getQuery(), null);
        options.setIncludeInTransactionData(!searchParameters.excludeDataInTheCurrentTransaction());
        options.setDefaultFTSConnective(searchParameters.getDefaultOperator() == SearchParameters.Operator.OR ? Connective.OR : Connective.AND);
        options.setDefaultFTSFieldConnective(searchParameters.getDefaultOperator() == SearchParameters.Operator.OR ? Connective.OR : Connective.AND);
        options.setSkipCount(searchParameters.getSkipCount());
        options.setMaxPermissionChecks(searchParameters.getMaxPermissionChecks());
        options.setMaxPermissionCheckTimeMillis(searchParameters.getMaxPermissionCheckTimeMillis());
        options.setDefaultFieldName(searchParameters.getDefaultFieldName());
        if (searchParameters.getLimitBy() == LimitBy.FINAL_SIZE) {
            options.setMaxItems(searchParameters.getLimit());
        } else {
            options.setMaxItems(searchParameters.getMaxItems());
        }
        options.setMlAnalaysisMode(searchParameters.getMlAnalaysisMode());
        options.setLocales(searchParameters.getLocales());
        options.setStores(searchParameters.getStores());
        options.setQueryParameterDefinitions(searchParameters.getQueryParameterDefinitions());
        options.setUseInMemorySort(searchParameters.getUseInMemorySort());
        options.setMaxRawResultSetSizeForInMemorySort(searchParameters.getMaxRawResultSetSizeForInMemorySort());
        options.setBulkFetchEnabled(searchParameters.isBulkFetchEnabled());
        options.setExcludeTenantFilter(searchParameters.getExcludeTenantFilter());
        options.setQueryConsistency(searchParameters.getQueryConsistency());
        return options;
    }

    public QueryOptions(String query, StoreRef storeRef) {
        this(query, storeRef, I18NUtil.getLocale());
    }

    public QueryOptions(String query, StoreRef storeRef, Locale locale) {
        this.query = query;
        this.stores.add(storeRef);
        this.locales.add(locale);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<StoreRef> getStores() {
        return this.stores;
    }

    public void setStores(List<StoreRef> stores) {
        this.stores = stores;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public void setSkipCount(int skipCount) {
        this.skipCount = skipCount;
    }

    public Connective getDefaultFTSConnective() {
        return this.defaultFTSConnective;
    }

    public void setDefaultFTSConnective(Connective defaultFTSConnective) {
        this.defaultFTSConnective = defaultFTSConnective;
    }

    public Connective getDefaultFTSFieldConnective() {
        return this.defaultFTSFieldConnective;
    }

    public void setDefaultFTSFieldConnective(Connective defaultFTSFieldConnective) {
        this.defaultFTSFieldConnective = defaultFTSFieldConnective;
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public void setLocales(List<Locale> locales) {
        this.locales = locales;
    }

    public MLAnalysisMode getMlAnalaysisMode() {
        return this.mlAnalaysisMode;
    }

    public void setMlAnalaysisMode(MLAnalysisMode mlAnalaysisMode) {
        this.mlAnalaysisMode = mlAnalaysisMode;
    }

    public List<QueryParameterDefinition> getQueryParameterDefinitions() {
        return this.queryParameterDefinitions;
    }

    public void setQueryParameterDefinitions(List<QueryParameterDefinition> queryParameterDefinitions) {
        this.queryParameterDefinitions = queryParameterDefinitions;
    }

    public boolean isIncludeInTransactionData() {
        return this.includeInTransactionData;
    }

    public void setIncludeInTransactionData(boolean includeInTransactionData) {
        this.includeInTransactionData = includeInTransactionData;
    }

    public long getMaxPermissionCheckTimeMillis() {
        return this.maxPermissionCheckTimeMillis;
    }

    public void setMaxPermissionCheckTimeMillis(long maxPermissionCheckTimeMillis) {
        this.maxPermissionCheckTimeMillis = maxPermissionCheckTimeMillis;
    }

    public int getMaxPermissionChecks() {
        return this.maxPermissionChecks;
    }

    public void setMaxPermissionChecks(int maxPermissionChecks) {
        this.maxPermissionChecks = maxPermissionChecks;
    }

    public String getDefaultFieldName() {
        return this.defaultFieldName;
    }

    public void setDefaultFieldName(String defaultFieldName) {
        this.defaultFieldName = defaultFieldName;
    }

    public Boolean getUseInMemorySort() {
        return this.useInMemorySort;
    }

    public void setUseInMemorySort(Boolean useInMemorySort) {
        this.useInMemorySort = useInMemorySort;
    }

    public Integer getMaxRawResultSetSizeForInMemorySort() {
        return this.maxRawResultSetSizeForInMemorySort;
    }

    public void setMaxRawResultSetSizeForInMemorySort(Integer maxRawResultSetSizeForInMemorySort) {
        this.maxRawResultSetSizeForInMemorySort = maxRawResultSetSizeForInMemorySort;
    }

    public boolean isBulkFetchEnabled() {
        return this.isBulkFetchEnabled;
    }

    public void setBulkFetchEnabled(boolean isBulkFetchEnabled) {
        this.isBulkFetchEnabled = isBulkFetchEnabled;
    }

    public boolean getExcludeTenantFilter() {
        return this.excludeTenantFilter;
    }

    public void setExcludeTenantFilter(boolean excludeTenantFilter) {
        this.excludeTenantFilter = excludeTenantFilter;
    }

    public QueryConsistency getQueryConsistency() {
        return this.queryConsistency;
    }

    public void setQueryConsistency(QueryConsistency queryConsistency) {
        this.queryConsistency = queryConsistency;
    }

    public SearchParameters getAsSearchParmeters() {
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setDefaultFieldName(this.getDefaultFieldName());
        searchParameters.setDefaultFTSFieldConnective(this.getDefaultFTSFieldConnective() == Connective.OR ? SearchParameters.Operator.OR : SearchParameters.Operator.AND);
        searchParameters.setDefaultFTSOperator(this.getDefaultFTSConnective() == Connective.OR ? SearchParameters.Operator.OR : SearchParameters.Operator.AND);
        searchParameters.setDefaultOperator(this.getDefaultFTSConnective() == Connective.OR ? SearchParameters.Operator.OR : SearchParameters.Operator.AND);
        searchParameters.setLanguage("fts-alfresco");
        if (this.getMaxItems() > 0) {
            searchParameters.setLimit(this.getMaxItems());
            searchParameters.setLimitBy(LimitBy.FINAL_SIZE);
            searchParameters.setMaxItems(this.getMaxItems());
        }
        searchParameters.setMaxPermissionChecks(this.getMaxPermissionChecks());
        searchParameters.setMaxPermissionCheckTimeMillis(this.getMaxPermissionCheckTimeMillis());
        searchParameters.setMlAnalaysisMode(this.getMlAnalaysisMode());
        searchParameters.setQuery(this.getQuery());
        searchParameters.setSkipCount(this.getSkipCount());
        for (Locale locale : this.getLocales()) {
            searchParameters.addLocale(locale);
        }
        for (QueryParameterDefinition queryParameterDefinition : this.getQueryParameterDefinitions()) {
            searchParameters.addQueryParameterDefinition(queryParameterDefinition);
        }
        for (StoreRef storeRef : this.getStores()) {
            searchParameters.addStore(storeRef);
        }
        searchParameters.setQueryConsistency(this.getQueryConsistency());
        return searchParameters;
    }

    public static enum Connective {
        AND,
        OR;

    }
}

