/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.springframework.extensions.surf.util.I18NUtil;

@AlfrescoPublicApi
public class SearchParameters {
    private static int DEFAULT_LIMIT = 500;
    public static final SortDefinition SORT_IN_DOCUMENT_ORDER_ASCENDING = new SortDefinition(SortDefinition.SortType.DOCUMENT, null, true);
    public static final SortDefinition SORT_IN_DOCUMENT_ORDER_DESCENDING = new SortDefinition(SortDefinition.SortType.DOCUMENT, null, false);
    public static final SortDefinition SORT_IN_SCORE_ORDER_ASCENDING = new SortDefinition(SortDefinition.SortType.SCORE, null, true);
    public static final SortDefinition SORT_IN_SCORE_ORDER_DESCENDING = new SortDefinition(SortDefinition.SortType.SCORE, null, false);
    public static final Operator OR = Operator.OR;
    public static final Operator AND = Operator.AND;
    public static final String ALTERNATIVE_DICTIONARY = "alternativeDic";
    private String language;
    private String query;
    private ArrayList<StoreRef> stores = new ArrayList(1);
    private ArrayList<QueryParameterDefinition> queryParameterDefinitions = new ArrayList(1);
    private boolean excludeDataInTheCurrentTransaction = false;
    private ArrayList<SortDefinition> sortDefinitions = new ArrayList(1);
    private ArrayList<Locale> locales = new ArrayList();
    private MLAnalysisMode mlAnalaysisMode = null;
    private LimitBy limitBy = LimitBy.UNLIMITED;
    private PermissionEvaluationMode permissionEvaluation = PermissionEvaluationMode.EAGER;
    private int limit = DEFAULT_LIMIT;
    private HashSet<String> allAttributes = new HashSet();
    private HashSet<String> textAttributes = new HashSet();
    private int maxItems = -1;
    private int skipCount = 0;
    private Operator defaultFTSOperator = Operator.OR;
    private Operator defaultFTSFieldOperator = Operator.OR;
    private Map<String, String> queryTemplates = new HashMap<String, String>();
    private String namespace = "http://www.alfresco.org/model/content/1.0";
    private int maxPermissionChecks = -1;
    private long maxPermissionCheckTimeMillis = -1L;
    private String defaultFieldName = "TEXT";
    private ArrayList<FieldFacet> fieldFacets = new ArrayList();
    private Boolean useInMemorySort;
    private Integer maxRawResultSetSizeForInMemorySort;
    private Map<String, String> extraParameters = new HashMap<String, String>();
    private boolean excludeTenantFilter = false;
    private boolean isBulkFetchEnabled = true;
    private QueryConsistency queryConsistency = QueryConsistency.DEFAULT;

    public SearchParameters() {
    }

    public SearchParameters copy() {
        SearchParameters sp = new SearchParameters();
        sp.allAttributes.addAll(this.allAttributes);
        sp.defaultFieldName = this.defaultFieldName;
        sp.defaultFTSFieldOperator = this.defaultFTSFieldOperator;
        sp.defaultFTSOperator = this.defaultFTSOperator;
        sp.excludeDataInTheCurrentTransaction = this.excludeDataInTheCurrentTransaction;
        sp.fieldFacets.addAll(this.fieldFacets);
        sp.language = this.language;
        sp.limit = this.limit;
        sp.limitBy = this.limitBy;
        sp.locales.addAll(this.locales);
        sp.maxItems = this.maxItems;
        sp.maxPermissionChecks = this.maxPermissionChecks;
        sp.maxPermissionCheckTimeMillis = this.maxPermissionCheckTimeMillis;
        sp.mlAnalaysisMode = this.mlAnalaysisMode;
        sp.namespace = this.namespace;
        sp.permissionEvaluation = this.permissionEvaluation;
        sp.query = this.query;
        sp.queryParameterDefinitions.addAll(this.queryParameterDefinitions);
        sp.queryTemplates.putAll(this.queryTemplates);
        sp.skipCount = this.skipCount;
        sp.sortDefinitions.addAll(this.sortDefinitions);
        sp.stores.addAll(this.stores);
        sp.textAttributes.addAll(this.textAttributes);
        sp.useInMemorySort = this.useInMemorySort;
        sp.maxRawResultSetSizeForInMemorySort = this.maxRawResultSetSizeForInMemorySort;
        sp.isBulkFetchEnabled = this.isBulkFetchEnabled;
        sp.excludeTenantFilter = this.excludeTenantFilter;
        sp.queryConsistency = this.queryConsistency;
        return sp;
    }

    public SearchParameters(QueryOptions options) {
        this.setSkipCount(options.getSkipCount());
        this.setMaxPermissionChecks(options.getMaxPermissionChecks());
        this.setMaxPermissionCheckTimeMillis(options.getMaxPermissionCheckTimeMillis());
        this.setBulkFetchEnabled(options.isBulkFetchEnabled());
        if (options.getMaxItems() >= 0) {
            this.setLimitBy(LimitBy.FINAL_SIZE);
            this.setLimit(options.getMaxItems());
            this.setMaxItems(options.getMaxItems());
        } else {
            this.setLimitBy(LimitBy.UNLIMITED);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public String getQuery() {
        return this.query;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void addExtraParameter(String name, String value) {
        this.extraParameters.put(name, value);
    }

    public Map<String, String> getExtraParameters() {
        return this.extraParameters;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void addStore(StoreRef store) {
        if (this.stores.size() != 0) {
            throw new IllegalStateException("At the moment, there can only be one store set for the search");
        }
        this.stores.add(store);
    }

    public void addQueryParameterDefinition(QueryParameterDefinition queryParameterDefinition) {
        this.queryParameterDefinitions.add(queryParameterDefinition);
    }

    public void excludeDataInTheCurrentTransaction(boolean excludeDataInTheCurrentTransaction) {
        this.excludeDataInTheCurrentTransaction = excludeDataInTheCurrentTransaction;
    }

    public void addSort(String field, boolean ascending) {
        this.addSort(new SortDefinition(SortDefinition.SortType.FIELD, field, ascending));
    }

    public void addSort(SortDefinition sortDefinition) {
        this.sortDefinitions.add(sortDefinition);
    }

    public boolean excludeDataInTheCurrentTransaction() {
        return this.excludeDataInTheCurrentTransaction;
    }

    public ArrayList<QueryParameterDefinition> getQueryParameterDefinitions() {
        return this.queryParameterDefinitions;
    }

    public ArrayList<SortDefinition> getSortDefinitions() {
        return this.sortDefinitions;
    }

    public ArrayList<StoreRef> getStores() {
        return this.stores;
    }

    public void setDefaultOperator(Operator defaultOperator) {
        this.defaultFTSOperator = defaultOperator;
        this.defaultFTSFieldOperator = defaultOperator;
    }

    public Operator getDefaultOperator() {
        return this.getDefaultFTSOperator();
    }

    public LimitBy getLimitBy() {
        return this.limitBy;
    }

    public void setLimitBy(LimitBy limitBy) {
        this.limitBy = limitBy;
    }

    public PermissionEvaluationMode getPermissionEvaluation() {
        return this.permissionEvaluation;
    }

    public void setPermissionEvaluation(PermissionEvaluationMode permissionEvaluation) {
        this.permissionEvaluation = permissionEvaluation;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public MLAnalysisMode getMlAnalaysisMode() {
        return this.mlAnalaysisMode;
    }

    public void setMlAnalaysisMode(MLAnalysisMode mlAnalaysisMode) {
        this.mlAnalaysisMode = mlAnalaysisMode;
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public List<Locale> getLocales() {
        return Collections.unmodifiableList(this.locales);
    }

    public void addTextAttribute(String attribute) {
        this.textAttributes.add(attribute);
    }

    public Set<String> getTextAttributes() {
        return Collections.unmodifiableSet(this.textAttributes);
    }

    public void addAllAttribute(String attribute) {
        this.allAttributes.add(attribute);
    }

    public Set<String> getAllAttributes() {
        return Collections.unmodifiableSet(this.allAttributes);
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public void setSkipCount(int skipCount) {
        this.skipCount = skipCount;
    }

    public Operator getDefaultFTSOperator() {
        return this.defaultFTSOperator;
    }

    public void setDefaultFTSOperator(Operator defaultFTSOperator) {
        this.defaultFTSOperator = defaultFTSOperator;
    }

    public Operator getDefaultFTSFieldOperator() {
        return this.defaultFTSFieldOperator;
    }

    public void setDefaultFTSFieldConnective(Operator defaultFTSFieldOperator) {
        this.defaultFTSFieldOperator = defaultFTSFieldOperator;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Map<String, String> getQueryTemplates() {
        return this.queryTemplates;
    }

    public String addQueryTemplate(String name, String template) {
        return this.queryTemplates.put(name, template);
    }

    public long getMaxPermissionCheckTimeMillis() {
        return this.maxPermissionCheckTimeMillis;
    }

    public void setMaxPermissionCheckTimeMillis(long maxPermissionCheckTimeMillis) {
        this.maxPermissionCheckTimeMillis = maxPermissionCheckTimeMillis;
    }

    public int getMaxPermissionChecks() {
        return this.maxPermissionChecks;
    }

    public void setMaxPermissionChecks(int maxPermissionChecks) {
        this.maxPermissionChecks = maxPermissionChecks;
    }

    public Boolean getUseInMemorySort() {
        return this.useInMemorySort;
    }

    public void setUseInMemorySort(Boolean useInMemorySort) {
        this.useInMemorySort = useInMemorySort;
    }

    public Integer getMaxRawResultSetSizeForInMemorySort() {
        return this.maxRawResultSetSizeForInMemorySort;
    }

    public void setMaxRawResultSetSizeForInMemorySort(Integer maxRawResultSetSizeForInMemorySort) {
        this.maxRawResultSetSizeForInMemorySort = maxRawResultSetSizeForInMemorySort;
    }

    public boolean isBulkFetchEnabled() {
        return this.isBulkFetchEnabled;
    }

    public void setBulkFetchEnabled(boolean isBulkFetchEnabled) {
        this.isBulkFetchEnabled = isBulkFetchEnabled;
    }

    public String getDefaultFieldName() {
        return this.defaultFieldName;
    }

    public void setDefaultFieldName(String defaultFieldName) {
        this.defaultFieldName = defaultFieldName;
    }

    public List<FieldFacet> getFieldFacets() {
        return this.fieldFacets;
    }

    public void addFieldFacet(FieldFacet fieldFacet) {
        this.fieldFacets.add(fieldFacet);
    }

    public Locale getSortLocale() {
        List<Locale> locales = this.getLocales();
        if (locales == null || locales.size() == 0) {
            locales = Collections.singletonList(I18NUtil.getLocale());
        }
        if (locales.size() > 1) {
            throw new AlfrescoRuntimeException("Order on text/mltext properties with more than one locale is not curently supported");
        }
        Locale sortLocale = locales.get(0);
        return sortLocale;
    }

    public void setExcludeTenantFilter(boolean excludeTenantFilter) {
        this.excludeTenantFilter = excludeTenantFilter;
    }

    public boolean getExcludeTenantFilter() {
        return this.excludeTenantFilter;
    }

    public void setQueryConsistency(QueryConsistency queryConsistency) {
        this.queryConsistency = queryConsistency;
    }

    public QueryConsistency getQueryConsistency() {
        return this.queryConsistency;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allAttributes == null ? 0 : this.allAttributes.hashCode());
        result = 31 * result + (this.defaultFTSFieldOperator == null ? 0 : this.defaultFTSFieldOperator.hashCode());
        result = 31 * result + (this.defaultFTSOperator == null ? 0 : this.defaultFTSOperator.hashCode());
        result = 31 * result + (this.defaultFieldName == null ? 0 : this.defaultFieldName.hashCode());
        result = 31 * result + (this.excludeDataInTheCurrentTransaction ? 1231 : 1237);
        result = 31 * result + (this.excludeTenantFilter ? 1231 : 1237);
        result = 31 * result + (this.fieldFacets == null ? 0 : this.fieldFacets.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + this.limit;
        result = 31 * result + (this.limitBy == null ? 0 : this.limitBy.hashCode());
        result = 31 * result + (this.locales == null ? 0 : this.locales.hashCode());
        result = 31 * result + this.maxItems;
        result = 31 * result + (int)(this.maxPermissionCheckTimeMillis ^ this.maxPermissionCheckTimeMillis >>> 32);
        result = 31 * result + this.maxPermissionChecks;
        result = 31 * result + (this.maxRawResultSetSizeForInMemorySort == null ? 0 : this.maxRawResultSetSizeForInMemorySort.hashCode());
        result = 31 * result + (this.mlAnalaysisMode == null ? 0 : this.mlAnalaysisMode.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.permissionEvaluation == null ? 0 : this.permissionEvaluation.hashCode());
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        result = 31 * result + (this.queryConsistency == null ? 0 : this.queryConsistency.hashCode());
        result = 31 * result + (this.queryParameterDefinitions == null ? 0 : this.queryParameterDefinitions.hashCode());
        result = 31 * result + (this.queryTemplates == null ? 0 : this.queryTemplates.hashCode());
        result = 31 * result + this.skipCount;
        result = 31 * result + (this.sortDefinitions == null ? 0 : this.sortDefinitions.hashCode());
        result = 31 * result + (this.stores == null ? 0 : this.stores.hashCode());
        result = 31 * result + (this.textAttributes == null ? 0 : this.textAttributes.hashCode());
        result = 31 * result + (this.useInMemorySort == null ? 0 : this.useInMemorySort.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchParameters other = (SearchParameters)obj;
        if (this.allAttributes == null ? other.allAttributes != null : !this.allAttributes.equals(other.allAttributes)) {
            return false;
        }
        if (this.defaultFTSFieldOperator != other.defaultFTSFieldOperator) {
            return false;
        }
        if (this.defaultFTSOperator != other.defaultFTSOperator) {
            return false;
        }
        if (this.defaultFieldName == null ? other.defaultFieldName != null : !this.defaultFieldName.equals(other.defaultFieldName)) {
            return false;
        }
        if (this.excludeDataInTheCurrentTransaction != other.excludeDataInTheCurrentTransaction) {
            return false;
        }
        if (this.excludeTenantFilter != other.excludeTenantFilter) {
            return false;
        }
        if (this.fieldFacets == null ? other.fieldFacets != null : !this.fieldFacets.equals(other.fieldFacets)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        if (this.limitBy != other.limitBy) {
            return false;
        }
        if (this.locales == null ? other.locales != null : !this.locales.equals(other.locales)) {
            return false;
        }
        if (this.maxItems != other.maxItems) {
            return false;
        }
        if (this.maxPermissionCheckTimeMillis != other.maxPermissionCheckTimeMillis) {
            return false;
        }
        if (this.maxPermissionChecks != other.maxPermissionChecks) {
            return false;
        }
        if (this.maxRawResultSetSizeForInMemorySort == null ? other.maxRawResultSetSizeForInMemorySort != null : !this.maxRawResultSetSizeForInMemorySort.equals(other.maxRawResultSetSizeForInMemorySort)) {
            return false;
        }
        if (this.mlAnalaysisMode != other.mlAnalaysisMode) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.permissionEvaluation != other.permissionEvaluation) {
            return false;
        }
        if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
            return false;
        }
        if (this.queryConsistency != other.queryConsistency) {
            return false;
        }
        if (this.queryParameterDefinitions == null ? other.queryParameterDefinitions != null : !this.queryParameterDefinitions.equals(other.queryParameterDefinitions)) {
            return false;
        }
        if (this.queryTemplates == null ? other.queryTemplates != null : !this.queryTemplates.equals(other.queryTemplates)) {
            return false;
        }
        if (this.skipCount != other.skipCount) {
            return false;
        }
        if (this.sortDefinitions == null ? other.sortDefinitions != null : !this.sortDefinitions.equals(other.sortDefinitions)) {
            return false;
        }
        if (this.stores == null ? other.stores != null : !this.stores.equals(other.stores)) {
            return false;
        }
        if (this.textAttributes == null ? other.textAttributes != null : !this.textAttributes.equals(other.textAttributes)) {
            return false;
        }
        return !(this.useInMemorySort == null ? other.useInMemorySort != null : !this.useInMemorySort.equals(other.useInMemorySort));
    }

    public String toString() {
        return "SearchParameters [language=" + this.language + ", query=" + this.query + ", stores=" + this.stores + ", queryParameterDefinitions=" + this.queryParameterDefinitions + ", excludeDataInTheCurrentTransaction=" + this.excludeDataInTheCurrentTransaction + ", sortDefinitions=" + this.sortDefinitions + ", locales=" + this.locales + ", mlAnalaysisMode=" + (Object)((Object)this.mlAnalaysisMode) + ", limitBy=" + (Object)((Object)this.limitBy) + ", permissionEvaluation=" + (Object)((Object)this.permissionEvaluation) + ", limit=" + this.limit + ", allAttributes=" + this.allAttributes + ", textAttributes=" + this.textAttributes + ", maxItems=" + this.maxItems + ", skipCount=" + this.skipCount + ", defaultFTSOperator=" + (Object)((Object)this.defaultFTSOperator) + ", defaultFTSFieldOperator=" + (Object)((Object)this.defaultFTSFieldOperator) + ", queryTemplates=" + this.queryTemplates + ", namespace=" + this.namespace + ", maxPermissionChecks=" + this.maxPermissionChecks + ", maxPermissionCheckTimeMillis=" + this.maxPermissionCheckTimeMillis + ", defaultFieldName=" + this.defaultFieldName + ", fieldFacets=" + this.fieldFacets + ", useInMemorySort=" + this.useInMemorySort + ", maxRawResultSetSizeForInMemorySort=" + this.maxRawResultSetSizeForInMemorySort + ", excludeTenantFilter=" + this.excludeTenantFilter + ", queryConsistency=" + (Object)((Object)this.queryConsistency) + "]";
    }

    public boolean usePostSort(int length, boolean useInMemorySortDefault, int maxRawResultSetSizeForInMemorySortDefault) {
        boolean use = this.useInMemorySort == null ? useInMemorySortDefault : this.useInMemorySort;
        int max = this.maxRawResultSetSizeForInMemorySort == null ? maxRawResultSetSizeForInMemorySortDefault : this.maxRawResultSetSizeForInMemorySort;
        return use && length <= max;
    }

    public static class FieldFacet {
        String field;
        String prefix = null;
        FieldFacetSort sort = null;
        int limit = 100;
        int offset = 0;
        int minCount = 0;
        boolean countDocsMissingFacetField = false;
        FieldFacetMethod method = null;
        int enumMethodCacheMinDF = 0;

        public FieldFacet(String field) {
            this.field = field;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public FieldFacetSort getSort() {
            return this.sort;
        }

        public void setSort(FieldFacetSort sort) {
            this.sort = sort;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public void setMinCount(int minCount) {
            this.minCount = minCount;
        }

        public boolean isCountDocsMissingFacetField() {
            return this.countDocsMissingFacetField;
        }

        public void setCountDocsMissingFacetField(boolean countDocsMissingFacetField) {
            this.countDocsMissingFacetField = countDocsMissingFacetField;
        }

        public FieldFacetMethod getMethod() {
            return this.method;
        }

        public void setMethod(FieldFacetMethod method) {
            this.method = method;
        }

        public int getEnumMethodCacheMinDF() {
            return this.enumMethodCacheMinDF;
        }

        public void setEnumMethodCacheMinDF(int enumMethodCacheMinDF) {
            this.enumMethodCacheMinDF = enumMethodCacheMinDF;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.countDocsMissingFacetField ? 1231 : 1237);
            result = 31 * result + this.enumMethodCacheMinDF;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            result = 31 * result + this.limit;
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            result = 31 * result + this.minCount;
            result = 31 * result + this.offset;
            result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
            result = 31 * result + (this.sort == null ? 0 : this.sort.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldFacet other = (FieldFacet)obj;
            if (this.countDocsMissingFacetField != other.countDocsMissingFacetField) {
                return false;
            }
            if (this.enumMethodCacheMinDF != other.enumMethodCacheMinDF) {
                return false;
            }
            if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
                return false;
            }
            if (this.limit != other.limit) {
                return false;
            }
            if (this.method != other.method) {
                return false;
            }
            if (this.minCount != other.minCount) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
                return false;
            }
            return this.sort == other.sort;
        }
    }

    public static enum FieldFacetMethod {
        ENUM,
        FC;

    }

    public static enum FieldFacetSort {
        COUNT,
        INDEX;

    }

    public static class SortDefinition {
        SortType sortType;
        String field;
        boolean ascending;

        public SortDefinition(SortType sortType, String field, boolean ascending) {
            this.sortType = sortType;
            this.field = field;
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public String getField() {
            return this.field;
        }

        public SortType getSortType() {
            return this.sortType;
        }

        public static enum SortType {
            FIELD,
            DOCUMENT,
            SCORE;

        }
    }

    public static enum Operator {
        OR,
        AND;

    }
}

