/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.namespace;

import java.io.Serializable;
import java.util.Collection;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QNamePattern;

@AlfrescoPublicApi
public final class QName
implements QNamePattern,
Serializable,
Cloneable,
Comparable<QName> {
    public static final String EMPTY_URI_SUBSTITUTE = ".empty";
    private static final long serialVersionUID = 3977016258204348976L;
    private final String namespaceURI;
    private final String localName;
    private int hashCode;
    private final String prefix;
    public static final char NAMESPACE_PREFIX = ':';
    public static final char NAMESPACE_BEGIN = '{';
    public static final char NAMESPACE_END = '}';
    public static final int MAX_LENGTH = 255;

    public static QName createQName(String namespaceURI, String localName) throws InvalidQNameException {
        if (localName == null || localName.length() == 0) {
            throw new InvalidQNameException("A QName must consist of a local name");
        }
        return new QName(namespaceURI, localName, null);
    }

    public static QName createQName(String prefix, String localName, NamespacePrefixResolver prefixResolver) throws InvalidQNameException, NamespaceException {
        String uri;
        if (localName == null || localName.length() == 0) {
            throw new InvalidQNameException("A QName must consist of a local name");
        }
        if (prefixResolver == null) {
            throw new IllegalArgumentException("A Prefix Resolver must be specified");
        }
        if (prefix == null) {
            prefix = "";
        }
        if ((uri = prefixResolver.getNamespaceURI(prefix)) == null) {
            throw new NamespaceException("Namespace prefix " + prefix + " is not mapped to a namespace URI");
        }
        return new QName(uri, localName, prefix);
    }

    public static QName createQName(String qname, NamespacePrefixResolver prefixResolver) throws InvalidQNameException, NamespaceException {
        QName name = null;
        if (qname != null) {
            int colonIndex = qname.indexOf(58);
            String prefix = colonIndex == -1 ? "" : qname.substring(0, colonIndex);
            String localName = colonIndex == -1 ? qname : qname.substring(colonIndex + 1);
            name = QName.createQName(prefix, localName, prefixResolver);
        }
        return name;
    }

    public static QName createQName(String qname) throws InvalidQNameException {
        if (qname == null || qname.length() == 0) {
            throw new InvalidQNameException("Argument qname is mandatory");
        }
        String namespaceURI = null;
        String localName = null;
        int namespaceBegin = qname.indexOf(123);
        int namespaceEnd = -1;
        if (namespaceBegin != -1) {
            if (namespaceBegin != 0) {
                throw new InvalidQNameException("QName '" + qname + "' must start with a namespaceURI");
            }
            namespaceEnd = qname.indexOf(125, namespaceBegin + 1);
            if (namespaceEnd == -1) {
                throw new InvalidQNameException("QName '" + qname + "' is missing the closing namespace " + '}' + " token");
            }
            namespaceURI = qname.substring(namespaceBegin + 1, namespaceEnd);
        }
        if ((localName = qname.substring(namespaceEnd + 1)) == null || localName.length() == 0) {
            throw new InvalidQNameException("QName '" + qname + "' must consist of a local name");
        }
        return new QName(namespaceURI, localName, null);
    }

    public static QName createQNameWithValidLocalName(String namespaceURI, String localName) {
        return new QName(namespaceURI, QName.createValidLocalName(localName), null);
    }

    public static String createValidLocalName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Local name cannot be null or empty.");
        }
        if (name.length() > 255) {
            name = name.substring(0, 255);
        }
        return name;
    }

    public static String[] splitPrefixedQName(String qname) throws InvalidQNameException, NamespaceException {
        if (qname != null) {
            int colonIndex = qname.indexOf(58);
            String prefix = colonIndex == -1 ? "" : qname.substring(0, colonIndex);
            String localName = colonIndex == -1 ? qname : qname.substring(colonIndex + 1);
            return new String[]{prefix, localName};
        }
        return null;
    }

    private QName(String namespace, String name, String prefix) {
        this.namespaceURI = namespace == null || namespace.equals(EMPTY_URI_SUBSTITUTE) ? "" : namespace;
        this.prefix = prefix;
        this.localName = name;
        this.hashCode = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public QName getPrefixedQName(NamespacePrefixResolver resolver) {
        Collection<String> prefixes = resolver.getPrefixes(this.namespaceURI);
        if (prefixes.size() == 0) {
            throw new NamespaceException("A namespace prefix is not registered for uri " + this.namespaceURI);
        }
        String resolvedPrefix = prefixes.iterator().next();
        if (this.prefix != null && this.prefix.equals(resolvedPrefix)) {
            return this;
        }
        return new QName(this.namespaceURI, this.localName, resolvedPrefix);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof QName) {
            QName other = (QName)object;
            return this.localName.equals(other.localName) && this.namespaceURI.equals(other.namespaceURI);
        }
        return false;
    }

    @Override
    public boolean isMatch(QName qname) {
        return this.equals(qname);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * this.localName.hashCode() + this.namespaceURI.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return new StringBuilder(80).append('{').append(this.namespaceURI).append('}').append(this.localName).toString();
    }

    @Override
    public int compareTo(QName qname) {
        int namespaceComparison = this.namespaceURI.compareTo(qname.namespaceURI);
        if (namespaceComparison != 0) {
            return namespaceComparison;
        }
        return this.localName.compareTo(qname.localName);
    }

    public String toPrefixString() {
        return this.prefix == null ? this.localName : this.prefix + ':' + this.localName;
    }

    public String getPrefixString() {
        return this.toPrefixString();
    }

    public String toPrefixString(NamespacePrefixResolver prefixResolver) {
        Collection<String> prefixes = prefixResolver.getPrefixes(this.namespaceURI);
        if (prefixes.size() == 0) {
            throw new NamespaceException("A namespace prefix is not registered for uri " + this.namespaceURI);
        }
        String pref = prefixes.iterator().next();
        if (pref.equals("")) {
            return this.localName;
        }
        return pref + ':' + this.localName;
    }

    public static QName resolveToQName(NamespacePrefixResolver prefixResolver, String str) {
        QName qname = null;
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("str parameter is mandatory");
        }
        if (str.charAt(0) == '{') {
            qname = QName.createQName(str);
        } else if (str.indexOf(58) != -1) {
            int end = str.indexOf(58);
            String prefix = str.substring(0, end);
            String localName = str.substring(end + 1);
            String uri = prefixResolver.getNamespaceURI(prefix);
            if (uri != null) {
                qname = QName.createQName(uri, localName);
            }
        } else {
            qname = QName.createQName("http://www.alfresco.org/model/content/1.0", str);
        }
        return qname;
    }

    public static String resolveToQNameString(NamespacePrefixResolver prefixResolver, String str) {
        String result = str;
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("str parameter is mandatory");
        }
        if (str.charAt(0) != '{') {
            if (str.indexOf(58) != -1) {
                int end = str.indexOf(58);
                String prefix = str.substring(0, end);
                String localName = str.substring(end + 1);
                String uri = prefixResolver.getNamespaceURI(prefix);
                if (uri != null) {
                    result = new StringBuilder(64).append('{').append(uri).append('}').append(localName).toString();
                }
            } else {
                result = new StringBuilder(64).append('{').append("http://www.alfresco.org/model/content/1.0").append('}').append(str).toString();
            }
        }
        return result;
    }
}

