/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.Constants;
import org.springframework.core.io.Resource;
import org.springframework.extensions.config.BaseConfigService;
import org.springframework.extensions.config.ConfigDeployer;
import org.springframework.extensions.config.ConfigDeployment;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.ConfigSection;
import org.springframework.extensions.config.ConfigSectionImpl;
import org.springframework.extensions.config.ConfigSource;
import org.springframework.extensions.config.evaluator.Evaluator;
import org.springframework.extensions.config.xml.XMLConfigConstants;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;
import org.springframework.extensions.config.xml.elementreader.GenericElementReader;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfigService
extends BaseConfigService
implements XMLConfigConstants {
    private static final Log logger = LogFactory.getLog(XMLConfigService.class);
    private static final Constants constants = new Constants(PropertyPlaceholderConfigurer.class);
    private Resource[] propertyLocations;
    private int systemPropertiesMode = 2;
    private PropertyConfigurer propertyConfigurer;
    private Map<String, ConfigElementReader> elementReaders;

    public XMLConfigService(ConfigSource configSource) {
        super(configSource);
    }

    public void setProperties(Resource[] locations) {
        this.propertyLocations = locations;
    }

    public void setSystemPropertiesModeName(String constantName) throws IllegalArgumentException {
        this.systemPropertiesMode = constants.asNumber(constantName).intValue();
    }

    @Override
    public List<ConfigDeployment> initConfig() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Commencing initialisation");
        }
        List<ConfigDeployment> configDeployments = super.initConfig();
        this.propertyConfigurer = null;
        if (this.propertyLocations != null) {
            PropertyConfigurer configurer = new PropertyConfigurer();
            configurer.setLocations(this.propertyLocations);
            configurer.setIgnoreUnresolvablePlaceholders(true);
            configurer.setSystemPropertiesMode(this.systemPropertiesMode);
            configurer.init();
            this.propertyConfigurer = configurer;
        }
        this.putElementReaders(new HashMap<String, ConfigElementReader>());
        List<ConfigDeployment> deployments = this.parse();
        configDeployments.addAll(deployments);
        for (ConfigDeployer configDeployer : this.configDeployers.values()) {
            deployments = configDeployer.initConfig();
            configDeployments.addAll(deployments);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Completed initialisation");
        }
        return configDeployments;
    }

    @Override
    public void destroy() {
        this.removeElementReaders();
        super.destroy();
    }

    public String parseFragment(Element rootElement, Map<String, ConfigElementReader> parsedElementReaders, Map<String, Evaluator> parsedEvaluators, List<ConfigSection> parsedConfigSections) {
        String currentArea = rootElement.attributeValue("area");
        Element pluginsElement = rootElement.element("plug-ins");
        if (pluginsElement != null) {
            Map<String, ConfigElementReader> elementReaders;
            Map<String, Evaluator> evaluators = this.parseEvaluatorsElement(pluginsElement.element("evaluators"));
            if (evaluators != null) {
                parsedEvaluators.putAll(evaluators);
            }
            if ((elementReaders = this.parseElementReadersElement(pluginsElement.element("element-readers"))) != null) {
                parsedElementReaders.putAll(elementReaders);
            }
        }
        Iterator configElements = rootElement.elementIterator("config");
        while (configElements.hasNext()) {
            Element configElement = (Element)configElements.next();
            parsedConfigSections.add(this.parseConfigElement(parsedElementReaders, configElement, currentArea));
        }
        return currentArea;
    }

    @Override
    protected void parse(InputStream stream) {
        HashMap<String, ConfigElementReader> parsedElementReaders = new HashMap<String, ConfigElementReader>();
        HashMap<String, Evaluator> parsedEvaluators = new HashMap<String, Evaluator>();
        ArrayList<ConfigSection> parsedConfigSections = new ArrayList<ConfigSection>();
        String currentArea = null;
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(stream);
            Element rootElement = document.getRootElement();
            currentArea = this.parseFragment(rootElement, parsedElementReaders, parsedEvaluators, parsedConfigSections);
        }
        catch (Throwable e) {
            if (e instanceof ConfigException) {
                throw (ConfigException)((Object)e);
            }
            throw new ConfigException("Failed to parse config stream", e);
        }
        try {
            if (parsedEvaluators != null) {
                for (Map.Entry entry : parsedEvaluators.entrySet()) {
                    this.addEvaluator((String)entry.getKey(), (Evaluator)entry.getValue());
                }
            }
            if (parsedElementReaders != null) {
                for (Map.Entry entry : parsedElementReaders.entrySet()) {
                    this.addConfigElementReader((String)entry.getKey(), (ConfigElementReader)entry.getValue());
                }
            }
            if (parsedConfigSections != null) {
                for (ConfigSection section : parsedConfigSections) {
                    this.addConfigSection(section, currentArea);
                }
            }
        }
        catch (Throwable e) {
            throw new ConfigException("Failed to add config to config service", e);
        }
    }

    private Map<String, Evaluator> parseEvaluatorsElement(Element evaluatorsElement) {
        if (evaluatorsElement != null) {
            HashMap<String, Evaluator> parsedEvaluators = new HashMap<String, Evaluator>();
            Iterator evaluators = evaluatorsElement.elementIterator();
            while (evaluators.hasNext()) {
                Element evaluatorElement = (Element)evaluators.next();
                String evaluatorName = evaluatorElement.attributeValue("id");
                String evaluatorClass = evaluatorElement.attributeValue("class");
                if (evaluatorName == null || evaluatorName.length() == 0) {
                    throw new ConfigException("All evaluator elements must define an id attribute");
                }
                if (evaluatorClass == null || evaluatorClass.length() == 0) {
                    throw new ConfigException("Evaluator '" + evaluatorName + "' must define a class attribute");
                }
                parsedEvaluators.put(evaluatorName, this.createEvaluator(evaluatorName, evaluatorClass));
            }
            return parsedEvaluators;
        }
        return null;
    }

    private Map<String, ConfigElementReader> parseElementReadersElement(Element readersElement) {
        if (readersElement != null) {
            HashMap<String, ConfigElementReader> parsedElementReaders = new HashMap<String, ConfigElementReader>();
            Iterator readers = readersElement.elementIterator();
            while (readers.hasNext()) {
                Element readerElement = (Element)readers.next();
                String readerElementName = readerElement.attributeValue("element-name");
                String readerElementClass = readerElement.attributeValue("class");
                if (readerElementName == null || readerElementName.length() == 0) {
                    throw new ConfigException("All element-reader elements must define an element-name attribute");
                }
                if (readerElementClass == null || readerElementClass.length() == 0) {
                    throw new ConfigException("Element-reader '" + readerElementName + "' must define a class attribute");
                }
                parsedElementReaders.put(readerElementName, this.createConfigElementReader(readerElementName, readerElementClass));
            }
            return parsedElementReaders;
        }
        return null;
    }

    private ConfigSection parseConfigElement(Map<String, ConfigElementReader> parsedElementReaders, Element configElement, String currentArea) {
        if (configElement != null) {
            boolean replace = false;
            String evaluatorName = configElement.attributeValue("evaluator");
            String condition = configElement.attributeValue("condition");
            String replaceValue = configElement.attributeValue("replace");
            if (replaceValue != null && replaceValue.equalsIgnoreCase("true")) {
                replace = true;
            }
            ConfigSectionImpl section = new ConfigSectionImpl(evaluatorName, condition, replace);
            Iterator children = configElement.elementIterator();
            while (children.hasNext()) {
                Element child = (Element)children.next();
                String elementName = child.getName();
                ConfigElementReader elementReader = null;
                if (parsedElementReaders != null) {
                    elementReader = parsedElementReaders.get(elementName);
                }
                if (elementReader == null) {
                    elementReader = this.getConfigElementReader(elementName);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Retrieved element reader " + elementReader + " for element named '" + elementName + "'"));
                }
                if (elementReader == null) {
                    elementReader = new GenericElementReader(this.propertyConfigurer);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Defaulting to " + elementReader + " as there wasn't an element " + "reader registered for element '" + elementName + "'"));
                    }
                }
                ConfigElement cfgElement = elementReader.parse(child);
                section.addConfigElement(cfgElement);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Added " + cfgElement + " to " + section));
            }
            return section;
        }
        return null;
    }

    private void addConfigElementReader(String elementName, ConfigElementReader elementReader) {
        this.putConfigElementReader(elementName, elementReader);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added element reader '" + elementName + "': " + elementReader.getClass().getName()));
        }
    }

    private ConfigElementReader createConfigElementReader(String elementName, String className) {
        ConfigElementReader elementReader = null;
        try {
            Class<?> clazz = Class.forName(className);
            elementReader = (ConfigElementReader)clazz.newInstance();
        }
        catch (Throwable e) {
            throw new ConfigException("Could not instantiate element reader for '" + elementName + "' with class: " + className, e);
        }
        return elementReader;
    }

    private ConfigElementReader getConfigElementReader(String elementName) {
        return this.getElementReaders().get(elementName);
    }

    private void putConfigElementReader(String elementName, ConfigElementReader elementReader) {
        this.getElementReaders().put(elementName, elementReader);
    }

    protected Map<String, ConfigElementReader> getElementReaders() {
        return this.elementReaders;
    }

    protected void putElementReaders(Map<String, ConfigElementReader> elementReaders) {
        this.elementReaders = elementReaders;
    }

    protected void removeElementReaders() {
        this.elementReaders.clear();
        this.elementReaders = null;
    }

    public static class PlaceholderResolvingStringValueResolver
    implements StringValueResolver {
        private final PropertyPlaceholderHelper helper;
        private final Properties props;

        public PlaceholderResolvingStringValueResolver(Properties props, String placeholderPrefix, String placeholderSuffix, String valueSeparator, boolean ignoreUnresolvablePlaceholders) {
            this.helper = new PropertyPlaceholderHelper(placeholderPrefix, placeholderSuffix, valueSeparator, ignoreUnresolvablePlaceholders);
            this.props = props;
        }

        public String resolveStringValue(String strVal) throws BeansException {
            String value = this.helper.replacePlaceholders(strVal, this.props);
            return value;
        }
    }

    public static class PropertyConfigurer
    extends PropertyPlaceholderConfigurer {
        private PlaceholderResolvingStringValueResolver resolver;

        void init() {
            try {
                Properties properties = this.mergeProperties();
                this.resolver = new PlaceholderResolvingStringValueResolver(properties, "${", "}", ":", true);
            }
            catch (IOException e) {
                throw new ConfigException("Failed to retrieve properties", e);
            }
        }

        public String resolveValue(String val) {
            return this.resolver.resolveStringValue(val);
        }
    }
}

