/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.WebFrameworkConfigProperties;
import org.springframework.extensions.config.element.ConfigElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebFrameworkConfigElement
extends ConfigElementAdapter
implements WebFrameworkConfigProperties {
    private static final long serialVersionUID = 1L;
    public static final String MODE_DEVELOPMENT = "development";
    public static final String MODE_PREVIEW = "preview";
    public static final String MODE_PRODUCTION = "production";
    public static final String DEFAULT_WEBFRAMEWORK_USER_FACTORY_ID = "webframework.factory.user.default";
    public static final String DEFAULT_WEBFRAMEWORK_MODEL_OBJECT_SEARCH_PATH_ID = "webframework.modelobject.searchpath";
    public static final String DEFAULT_WEBFRAMEWORK_MODEL_OBJECT_STORE_ID = "webframework.model.store.classpath";
    public static final String CONFIG_ELEMENT_ID = "web-framework";
    protected HashMap<String, FormatDescriptor> formats = null;
    protected HashMap<String, ErrorHandlerDescriptor> errorHandlers = null;
    protected HashMap<String, SystemPageDescriptor> systemPages = null;
    protected HashMap<String, TagLibraryDescriptor> tagLibraries = null;
    protected HashMap<String, String> pageTypes = null;
    protected HashMap<String, TypeDescriptor> types = null;
    protected HashMap<String, ResourceLoaderDescriptor> resourceLoaders = null;
    protected HashMap<String, ResourceResolverDescriptor> resourceResolvers = null;
    protected HashMap<String, RuntimeConfigDescriptor> runtimeConfigs = null;
    protected boolean isTimerEnabled = false;
    protected String defaultLinkBuilderFactoryId = null;
    protected String defaultRequestContextFactoryId = null;
    protected String defaultUserFactoryId = null;
    protected String defaultFormatId = null;
    protected String defaultRegionChrome = null;
    protected String defaultComponentChrome = null;
    protected String defaultSubComponentChrome = null;
    protected String defaultTheme = null;
    protected String defaultSiteConfiguration = null;
    private boolean surfBugEnabled = false;
    protected String surfBug = null;
    protected String defaultPersisterId = null;
    protected PersisterConfigDescriptor persisterConfigDescriptor = null;
    protected String autowireModeId;
    protected String autowireRuntimeId;
    protected String moduleDeploymentMode;
    protected Boolean enableAutoDeployModules;
    protected Boolean useChecksumDependencies;
    protected Boolean generateCssDataImages;
    protected Boolean aggregateDependencies;
    protected Boolean calculateWebScriptDependencies;
    protected Boolean enableRemoteResourceHandling;
    protected Boolean enableExtensionModulesOnGuestPages;
    protected Boolean enableDynamicExtensions;
    public static final String DOJO_CONFIG = "dojo-pages";
    public static final String DOJO_ENABLED = "enabled";
    public static final String DOJO_LOADER_TRACE_ENABLED = "loader-trace-enabled";
    public static final String DOJO_BOOTSTRAP_FILE = "bootstrap-file";
    public static final String DOJO_PAGE_WIDGETS = "page-widget";
    public static final String DOJO_BASE_URL = "base-url";
    public static final String DOJO_PACKAGES = "packages";
    public static final String DOJO_PACKAGE = "package";
    public static final String DOJO_PACKAGE_NAME = "name";
    public static final String DOJO_PACKAGE_LOCATION = "location";
    public static final String DOJO_MESSAGES_OBJECT = "messages-object";
    public static final String DOJO_MESSAGES_DEFAULT_SCOPE = "default-messages-scope";
    protected Boolean dojoEnabled = null;
    protected Boolean dojoLoaderTraceEnabled = null;
    protected String dojoBootstrapFile = null;
    protected String dojoPageWidget = null;
    protected String dojoBaseUrl = null;
    protected String dojoMessagesObject = null;
    protected String dojoMessagesDefaultScope = null;
    protected Map<String, String> dojoPackages = new HashMap<String, String>();

    public boolean isSurfBugEnabled() {
        return this.surfBugEnabled;
    }

    public void setSurfBugEnabled(boolean surfBugEnabled) {
        this.surfBugEnabled = surfBugEnabled;
    }

    public String getSurfBug() {
        return this.surfBug;
    }

    public WebFrameworkConfigElement() {
        super(CONFIG_ELEMENT_ID);
        this.formats = new HashMap();
        this.errorHandlers = new HashMap();
        this.systemPages = new HashMap();
        this.tagLibraries = new HashMap();
        this.pageTypes = new HashMap();
        this.types = new HashMap();
        this.resourceLoaders = new HashMap();
        this.resourceResolvers = new HashMap();
        this.runtimeConfigs = new HashMap();
    }

    public ConfigElement combine(ConfigElement element) {
        WebFrameworkConfigElement configElement = (WebFrameworkConfigElement)element;
        WebFrameworkConfigElement combinedElement = new WebFrameworkConfigElement();
        combinedElement.formats.putAll(this.formats);
        combinedElement.errorHandlers.putAll(this.errorHandlers);
        combinedElement.systemPages.putAll(this.systemPages);
        combinedElement.tagLibraries.putAll(this.tagLibraries);
        combinedElement.types.putAll(this.types);
        combinedElement.pageTypes.putAll(this.pageTypes);
        combinedElement.resourceLoaders.putAll(this.resourceLoaders);
        combinedElement.resourceResolvers.putAll(this.resourceResolvers);
        combinedElement.runtimeConfigs.putAll(this.runtimeConfigs);
        combinedElement.formats.putAll(configElement.formats);
        combinedElement.errorHandlers.putAll(configElement.errorHandlers);
        combinedElement.systemPages.putAll(configElement.systemPages);
        combinedElement.tagLibraries.putAll(configElement.tagLibraries);
        combinedElement.types.putAll(configElement.types);
        combinedElement.pageTypes.putAll(configElement.pageTypes);
        combinedElement.resourceLoaders.putAll(configElement.resourceLoaders);
        combinedElement.resourceResolvers.putAll(configElement.resourceResolvers);
        combinedElement.runtimeConfigs.putAll(configElement.runtimeConfigs);
        combinedElement.isTimerEnabled = this.isTimerEnabled;
        if (configElement.isTimerEnabled) {
            combinedElement.isTimerEnabled = configElement.isTimerEnabled;
        }
        combinedElement.defaultLinkBuilderFactoryId = this.defaultLinkBuilderFactoryId;
        if (configElement.defaultLinkBuilderFactoryId != null) {
            combinedElement.defaultLinkBuilderFactoryId = configElement.defaultLinkBuilderFactoryId;
        }
        combinedElement.defaultRequestContextFactoryId = this.defaultRequestContextFactoryId;
        if (configElement.defaultRequestContextFactoryId != null) {
            combinedElement.defaultRequestContextFactoryId = configElement.defaultRequestContextFactoryId;
        }
        combinedElement.defaultUserFactoryId = this.defaultUserFactoryId;
        if (configElement.defaultUserFactoryId != null) {
            combinedElement.defaultUserFactoryId = configElement.defaultUserFactoryId;
        }
        combinedElement.defaultFormatId = this.defaultFormatId;
        if (configElement.defaultFormatId != null) {
            combinedElement.defaultFormatId = configElement.defaultFormatId;
        }
        combinedElement.defaultRegionChrome = this.defaultRegionChrome;
        if (configElement.defaultRegionChrome != null) {
            combinedElement.defaultRegionChrome = configElement.defaultRegionChrome;
        }
        combinedElement.defaultComponentChrome = this.defaultComponentChrome;
        if (configElement.defaultComponentChrome != null) {
            combinedElement.defaultComponentChrome = configElement.defaultComponentChrome;
        }
        combinedElement.defaultSubComponentChrome = this.defaultSubComponentChrome;
        if (configElement.defaultSubComponentChrome != null) {
            combinedElement.defaultSubComponentChrome = configElement.defaultSubComponentChrome;
        }
        combinedElement.defaultTheme = this.defaultTheme;
        if (configElement.defaultTheme != null) {
            combinedElement.defaultTheme = configElement.defaultTheme;
        }
        combinedElement.surfBug = this.surfBug;
        if (configElement.surfBug != null) {
            combinedElement.surfBug = configElement.surfBug;
        }
        combinedElement.surfBug = this.surfBug;
        if (configElement.surfBug != null) {
            combinedElement.surfBug = configElement.surfBug;
        }
        combinedElement.defaultSiteConfiguration = this.defaultSiteConfiguration;
        if (configElement.defaultSiteConfiguration != null) {
            combinedElement.defaultSiteConfiguration = configElement.defaultSiteConfiguration;
        }
        combinedElement.defaultPersisterId = this.defaultPersisterId;
        if (configElement.defaultPersisterId != null) {
            combinedElement.defaultPersisterId = configElement.defaultPersisterId;
        }
        for (TypeDescriptor type : combinedElement.getTypes()) {
            if (!type.useDefaultPerister()) continue;
            type.setPersisterId(combinedElement.defaultPersisterId);
        }
        combinedElement.autowireModeId = this.autowireModeId;
        if (configElement.autowireModeId != null) {
            combinedElement.autowireModeId = configElement.autowireModeId;
        }
        combinedElement.autowireRuntimeId = this.autowireRuntimeId;
        if (configElement.autowireRuntimeId != null) {
            combinedElement.autowireRuntimeId = configElement.autowireRuntimeId;
        }
        combinedElement.persisterConfigDescriptor = this.persisterConfigDescriptor;
        if (configElement.persisterConfigDescriptor != null) {
            combinedElement.persisterConfigDescriptor = configElement.persisterConfigDescriptor;
        }
        combinedElement.moduleDeploymentMode = this.moduleDeploymentMode;
        if (configElement.moduleDeploymentMode != null) {
            combinedElement.moduleDeploymentMode = configElement.moduleDeploymentMode;
        }
        combinedElement.enableAutoDeployModules = this.enableAutoDeployModules;
        if (configElement.enableAutoDeployModules != null) {
            combinedElement.enableAutoDeployModules = configElement.enableAutoDeployModules;
        }
        combinedElement.useChecksumDependencies = this.useChecksumDependencies;
        if (configElement.useChecksumDependencies != null) {
            combinedElement.useChecksumDependencies = configElement.useChecksumDependencies;
        }
        combinedElement.generateCssDataImages = this.generateCssDataImages;
        if (configElement.generateCssDataImages != null) {
            combinedElement.generateCssDataImages = configElement.generateCssDataImages;
        }
        combinedElement.aggregateDependencies = this.aggregateDependencies;
        if (configElement.aggregateDependencies != null) {
            combinedElement.aggregateDependencies = configElement.aggregateDependencies;
        }
        combinedElement.calculateWebScriptDependencies = this.calculateWebScriptDependencies;
        if (configElement.calculateWebScriptDependencies != null) {
            combinedElement.calculateWebScriptDependencies = configElement.calculateWebScriptDependencies;
        }
        combinedElement.enableRemoteResourceHandling = this.enableRemoteResourceHandling;
        if (configElement.enableRemoteResourceHandling != null) {
            combinedElement.enableRemoteResourceHandling = configElement.enableRemoteResourceHandling;
        }
        combinedElement.enableExtensionModulesOnGuestPages = this.enableExtensionModulesOnGuestPages;
        if (configElement.enableExtensionModulesOnGuestPages != null) {
            combinedElement.enableExtensionModulesOnGuestPages = configElement.enableExtensionModulesOnGuestPages;
        }
        combinedElement.enableDynamicExtensions = this.enableDynamicExtensions;
        if (configElement.enableDynamicExtensions != null) {
            combinedElement.enableDynamicExtensions = configElement.enableDynamicExtensions;
        }
        this.combineDojoConfiguration(configElement, combinedElement);
        return combinedElement;
    }

    @Override
    public String[] getFormatIds() {
        return this.formats.keySet().toArray(new String[this.formats.size()]);
    }

    @Override
    public FormatDescriptor getFormatDescriptor(String id) {
        return this.formats.get(id);
    }

    @Override
    public String[] getErrorHandlerIds() {
        return this.errorHandlers.keySet().toArray(new String[this.errorHandlers.size()]);
    }

    @Override
    public ErrorHandlerDescriptor getErrorHandlerDescriptor(String id) {
        return this.errorHandlers.get(id);
    }

    @Override
    public String[] getSystemPageIds() {
        return this.systemPages.keySet().toArray(new String[this.systemPages.size()]);
    }

    @Override
    public SystemPageDescriptor getSystemPageDescriptor(String id) {
        return this.systemPages.get(id);
    }

    @Override
    public String[] getTagLibraryIds() {
        return this.tagLibraries.keySet().toArray(new String[this.tagLibraries.size()]);
    }

    @Override
    public TagLibraryDescriptor getTagLibraryDescriptor(String id) {
        return this.tagLibraries.get(id);
    }

    public Collection<TypeDescriptor> getTypes() {
        return this.types.values();
    }

    @Override
    public String[] getTypeIds() {
        return this.types.keySet().toArray(new String[this.types.size()]);
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String id) {
        return this.types.get(id);
    }

    @Override
    public String[] getResourceLoaderIds() {
        return this.resourceLoaders.keySet().toArray(new String[this.resourceLoaders.size()]);
    }

    @Override
    public ResourceLoaderDescriptor getResourceLoaderDescriptor(String id) {
        return this.resourceLoaders.get(id);
    }

    @Override
    public String[] getResourceResolverIds() {
        return this.resourceResolvers.keySet().toArray(new String[this.resourceResolvers.size()]);
    }

    @Override
    public ResourceResolverDescriptor getResourceResolverDescriptor(String id) {
        return this.resourceResolvers.get(id);
    }

    @Override
    public boolean isTimerEnabled() {
        return this.isTimerEnabled;
    }

    @Override
    public String getDefaultRegionChrome() {
        return this.defaultRegionChrome;
    }

    @Override
    public String getDefaultComponentChrome() {
        return this.defaultComponentChrome;
    }

    public String getDefaultSubComponentChrome() {
        return this.defaultSubComponentChrome;
    }

    @Override
    public String[] getDefaultPageTypeIds() {
        return this.pageTypes.keySet().toArray(new String[this.pageTypes.size()]);
    }

    @Override
    public String getDefaultPageTypeInstanceId(String id) {
        return this.pageTypes.get(id);
    }

    @Override
    public String getDefaultThemeId() {
        if (this.defaultTheme == null) {
            return "default";
        }
        return this.defaultTheme;
    }

    @Override
    public String getDefaultSiteConfigurationId() {
        if (this.defaultSiteConfiguration == null) {
            return "default.site.configuration";
        }
        return this.defaultSiteConfiguration;
    }

    @Override
    public String getDefaultFormatId() {
        if (this.defaultFormatId == null) {
            return "default";
        }
        return this.defaultFormatId;
    }

    @Override
    public String getDefaultUserFactoryId() {
        if (this.defaultUserFactoryId == null) {
            return DEFAULT_WEBFRAMEWORK_USER_FACTORY_ID;
        }
        return this.defaultUserFactoryId;
    }

    @Override
    public String getDefaultPersisterId() {
        return this.defaultPersisterId;
    }

    @Override
    public boolean isAutowireModeDevelopment() {
        return MODE_DEVELOPMENT.equals(this.autowireModeId);
    }

    @Override
    public boolean isAutowireModeProduction() {
        return MODE_PRODUCTION.equals(this.autowireModeId);
    }

    @Override
    public boolean isAutowireModePreview() {
        return MODE_PREVIEW.equals(this.autowireModeId);
    }

    @Override
    public String getAutowireModeId() {
        return this.autowireModeId;
    }

    @Override
    public String getAutowireRuntimeId() {
        return this.autowireRuntimeId;
    }

    @Override
    public boolean isPreviewEnabled() {
        return this.isAutowireModePreview();
    }

    @Override
    public RuntimeConfigDescriptor getRuntimeConfigDescriptor(String id) {
        return this.runtimeConfigs.get(id);
    }

    @Override
    public PersisterConfigDescriptor getPersisterConfigDescriptor() {
        return this.persisterConfigDescriptor;
    }

    @Override
    public String getModuleDeploymentMode() {
        return this.moduleDeploymentMode;
    }

    public boolean isModuleAutoDeployEnabled() {
        return this.enableAutoDeployModules != null ? this.enableAutoDeployModules.booleanValue() : Boolean.FALSE.booleanValue();
    }

    public boolean useChecksumDependencies() {
        return this.useChecksumDependencies != null ? this.useChecksumDependencies.booleanValue() : Boolean.FALSE.booleanValue();
    }

    public boolean isGenerateCssDataImagesEnabled() {
        return this.generateCssDataImages != null ? this.generateCssDataImages.booleanValue() : Boolean.FALSE.booleanValue();
    }

    public boolean isAggregateDependenciesEnabled() {
        return this.aggregateDependencies != null ? this.aggregateDependencies.booleanValue() : Boolean.FALSE.booleanValue();
    }

    public boolean isCalculateWebScriptDependenciesEnabled() {
        return this.calculateWebScriptDependencies != null ? this.calculateWebScriptDependencies.booleanValue() : Boolean.TRUE.booleanValue();
    }

    public boolean isRemoteResourceResolvingEnabled() {
        return this.enableRemoteResourceHandling != null ? this.enableRemoteResourceHandling.booleanValue() : Boolean.FALSE.booleanValue();
    }

    public boolean isGuestPageExtensionModulesEnabled() {
        return this.enableExtensionModulesOnGuestPages != null ? this.enableExtensionModulesOnGuestPages.booleanValue() : Boolean.TRUE.booleanValue();
    }

    public boolean isDynamicExtensionModulesEnabled() {
        return this.enableDynamicExtensions != null ? this.enableDynamicExtensions.booleanValue() : Boolean.TRUE.booleanValue();
    }

    protected static WebFrameworkConfigElement newInstance(Element elem) {
        String enableDynamicExtensionModules;
        String enableGuestPageExtensionModules;
        String enableRemoteResources;
        String calculateWebScriptDependencies;
        String aggregateDependencies;
        String generateCssDataImages;
        String useChecksumDependencies;
        Element moduleDeploymentElement;
        Element persisterConfigElement;
        String _isTimerEnabled;
        Element debugElement;
        WebFrameworkConfigElement configElement = new WebFrameworkConfigElement();
        List formats = elem.elements("format");
        for (Element el : formats) {
            FormatDescriptor descriptor = new FormatDescriptor(el);
            configElement.formats.put(descriptor.getId(), descriptor);
        }
        List errorHandlers = elem.elements("error-handler");
        for (Element el : errorHandlers) {
            ErrorHandlerDescriptor descriptor = new ErrorHandlerDescriptor(el);
            configElement.errorHandlers.put(descriptor.getId(), descriptor);
        }
        List systemPages = elem.elements("system-page");
        for (Element el : systemPages) {
            SystemPageDescriptor descriptor = new SystemPageDescriptor(el);
            configElement.systemPages.put(descriptor.getId(), descriptor);
        }
        List tagLibraries = elem.elements("tag-library");
        for (Element el : tagLibraries) {
            TagLibraryDescriptor descriptor = new TagLibraryDescriptor(el);
            configElement.tagLibraries.put(descriptor.getId(), descriptor);
        }
        Element defaults = elem.element("defaults");
        if (defaults != null) {
            String _defaultPersisterId;
            String _theme;
            String _surfBug;
            String _subComponentChrome;
            String _componentChrome;
            String _regionChrome;
            String _format;
            String _userFactoryId;
            String _linkBuilderFactoryId;
            String _requestContextFactoryId = defaults.elementTextTrim("request-context-factory");
            if (_requestContextFactoryId != null) {
                configElement.defaultRequestContextFactoryId = _requestContextFactoryId;
            }
            if ((_linkBuilderFactoryId = defaults.elementTextTrim("link-builder-factory")) != null) {
                configElement.defaultLinkBuilderFactoryId = _linkBuilderFactoryId;
            }
            if ((_userFactoryId = defaults.elementTextTrim("user-factory")) != null) {
                configElement.defaultUserFactoryId = _userFactoryId;
            }
            if ((_format = defaults.elementTextTrim("format")) != null) {
                configElement.defaultFormatId = _format;
            }
            if ((_regionChrome = defaults.elementTextTrim("region-chrome")) != null) {
                configElement.defaultRegionChrome = _regionChrome;
            }
            if ((_componentChrome = defaults.elementTextTrim("component-chrome")) != null) {
                configElement.defaultComponentChrome = _componentChrome;
            }
            if ((_subComponentChrome = defaults.elementTextTrim("sub-component-chrome")) != null) {
                configElement.defaultSubComponentChrome = _subComponentChrome;
            }
            if ((_surfBug = defaults.elementTextTrim("surfbug")) != null) {
                configElement.surfBug = _surfBug;
            }
            if ((_theme = defaults.elementTextTrim("theme")) != null && _theme.length() != 0) {
                configElement.defaultTheme = _theme;
            }
            List pageTypes = defaults.elements("page-type");
            for (Element pageType : pageTypes) {
                String pageTypeId = pageType.elementTextTrim("id");
                String pageTypeInstanceId = pageType.elementTextTrim("page-instance-id");
                configElement.pageTypes.put(pageTypeId, pageTypeInstanceId);
            }
            String _siteConfiguration = defaults.elementTextTrim("site-configuration");
            if (_siteConfiguration != null) {
                configElement.defaultSiteConfiguration = _siteConfiguration;
            }
            if ((_defaultPersisterId = defaults.elementText("persister")) != null) {
                configElement.defaultPersisterId = _defaultPersisterId;
            }
        }
        if ((debugElement = elem.element("debug")) != null && (_isTimerEnabled = debugElement.elementTextTrim("timer")) != null) {
            configElement.isTimerEnabled = Boolean.parseBoolean(_isTimerEnabled);
        }
        List objectTypes = elem.elements("object-type");
        for (Element el : objectTypes) {
            TypeDescriptor descriptor = new TypeDescriptor(el);
            if (descriptor.useDefaultPerister() && configElement.getDefaultPersisterId() != null) {
                descriptor.setPersisterId(configElement.getDefaultPersisterId());
            }
            configElement.types.put(descriptor.getId(), descriptor);
        }
        List loaders = elem.elements("resource-loader");
        for (Element el : loaders) {
            ResourceLoaderDescriptor descriptor = new ResourceLoaderDescriptor(el);
            configElement.resourceLoaders.put(descriptor.getId(), descriptor);
        }
        List resolvers = elem.elements("resource-resolver");
        for (Element el : resolvers) {
            ResourceResolverDescriptor descriptor = new ResourceResolverDescriptor(el);
            configElement.resourceResolvers.put(descriptor.getId(), descriptor);
        }
        List runtimeConfigElements = elem.elements("runtime-config");
        for (Element el : runtimeConfigElements) {
            RuntimeConfigDescriptor descriptor = new RuntimeConfigDescriptor(el);
            configElement.runtimeConfigs.put(descriptor.getId(), descriptor);
        }
        Element autowireConfigElement = elem.element("autowire");
        if (autowireConfigElement != null) {
            String _autowireRuntimeId;
            String _autowireModeId = autowireConfigElement.elementTextTrim("mode");
            if (_autowireModeId != null) {
                configElement.autowireModeId = _autowireModeId;
            }
            if ((_autowireRuntimeId = autowireConfigElement.elementTextTrim("runtime")) != null) {
                configElement.autowireRuntimeId = _autowireRuntimeId;
            }
        }
        if ((persisterConfigElement = elem.element("persisters")) != null) {
            configElement.persisterConfigDescriptor = new PersisterConfigDescriptor(persisterConfigElement);
        }
        if ((moduleDeploymentElement = elem.element("module-deployment")) != null) {
            String _enableAutoDeployModules;
            String _moduleDeploymentMode = moduleDeploymentElement.elementTextTrim("mode");
            if (_moduleDeploymentMode != null) {
                configElement.moduleDeploymentMode = _moduleDeploymentMode;
            }
            if ((_enableAutoDeployModules = moduleDeploymentElement.elementTextTrim("enable-auto-deploy-modules")) != null) {
                configElement.enableAutoDeployModules = Boolean.valueOf(_enableAutoDeployModules);
            }
        }
        if ((useChecksumDependencies = elem.elementTextTrim("use-checksum-dependencies")) != null) {
            configElement.useChecksumDependencies = Boolean.valueOf(useChecksumDependencies);
        }
        if ((generateCssDataImages = elem.elementTextTrim("generate-css-data-images")) != null) {
            configElement.generateCssDataImages = Boolean.valueOf(generateCssDataImages);
        }
        if ((aggregateDependencies = elem.elementTextTrim("aggregate-dependencies")) != null) {
            configElement.aggregateDependencies = Boolean.valueOf(aggregateDependencies);
        }
        if ((calculateWebScriptDependencies = elem.elementTextTrim("calculate-webscript-dependencies")) != null) {
            configElement.calculateWebScriptDependencies = Boolean.valueOf(calculateWebScriptDependencies);
        }
        if ((enableRemoteResources = elem.elementTextTrim("enable-remote-resource-resolving")) != null) {
            configElement.enableRemoteResourceHandling = Boolean.valueOf(enableRemoteResources);
        }
        if ((enableGuestPageExtensionModules = elem.elementTextTrim("enable-guest-page-extension-modules")) != null) {
            configElement.enableExtensionModulesOnGuestPages = Boolean.valueOf(enableGuestPageExtensionModules);
        }
        if ((enableDynamicExtensionModules = elem.elementTextTrim("enable-dynamic-extension-modules")) != null) {
            configElement.enableDynamicExtensions = Boolean.valueOf(enableDynamicExtensionModules);
        }
        WebFrameworkConfigElement.processDojoConfiguration(configElement, elem);
        return configElement;
    }

    public boolean isDojoEnabled() {
        return this.dojoEnabled != null ? this.dojoEnabled : false;
    }

    public boolean isDojoLoaderTraceEnabled() {
        return this.dojoLoaderTraceEnabled != null ? this.dojoLoaderTraceEnabled : false;
    }

    public String getDojoBootstrapFile() {
        return this.dojoBootstrapFile;
    }

    public String getDojoPageWidget() {
        return this.dojoPageWidget;
    }

    public String getDojoBaseUrl() {
        return this.dojoBaseUrl;
    }

    public Map<String, String> getDojoPackages() {
        return this.dojoPackages;
    }

    public String getDojoMessagesObject() {
        return this.dojoMessagesObject;
    }

    public String getDojoMessagesDefaultScope() {
        return this.dojoMessagesDefaultScope;
    }

    public static void processDojoConfiguration(WebFrameworkConfigElement configElement, Element elem) {
        Element dojoConfig = elem.element(DOJO_CONFIG);
        if (dojoConfig != null) {
            List packageList;
            Element packages;
            String messagesDefaultScope;
            String messagesObject;
            String baseUrl;
            String pageWidget;
            String bootstrapFile;
            String loaderTraceEnabled;
            String dojoEnabled = dojoConfig.elementTextTrim(DOJO_ENABLED);
            if (dojoEnabled != null) {
                configElement.dojoEnabled = Boolean.valueOf(dojoEnabled);
            }
            if ((loaderTraceEnabled = dojoConfig.elementTextTrim(DOJO_LOADER_TRACE_ENABLED)) != null) {
                configElement.dojoLoaderTraceEnabled = Boolean.valueOf(loaderTraceEnabled);
            }
            if ((bootstrapFile = dojoConfig.elementTextTrim(DOJO_BOOTSTRAP_FILE)) != null) {
                configElement.dojoBootstrapFile = bootstrapFile;
            }
            if ((pageWidget = dojoConfig.elementTextTrim(DOJO_PAGE_WIDGETS)) != null) {
                configElement.dojoPageWidget = pageWidget;
            }
            if ((baseUrl = dojoConfig.elementTextTrim(DOJO_BASE_URL)) != null) {
                configElement.dojoBaseUrl = baseUrl;
            }
            if ((messagesObject = dojoConfig.elementTextTrim(DOJO_MESSAGES_OBJECT)) != null) {
                configElement.dojoMessagesObject = messagesObject;
            }
            if ((messagesDefaultScope = dojoConfig.elementTextTrim(DOJO_MESSAGES_DEFAULT_SCOPE)) != null) {
                configElement.dojoMessagesDefaultScope = messagesDefaultScope;
            }
            if ((packages = dojoConfig.element(DOJO_PACKAGES)) != null && (packageList = packages.elements(DOJO_PACKAGE)) != null) {
                for (Element packageEntry : packageList) {
                    String name = packageEntry.attributeValue(DOJO_PACKAGE_NAME);
                    String location = packageEntry.attributeValue(DOJO_PACKAGE_LOCATION);
                    if (name == null || location == null) continue;
                    configElement.dojoPackages.put(name, location);
                }
            }
        }
    }

    public void combineDojoConfiguration(WebFrameworkConfigElement configElement, WebFrameworkConfigElement combinedElement) {
        combinedElement.dojoEnabled = this.dojoEnabled;
        if (configElement.dojoEnabled != null) {
            combinedElement.dojoEnabled = configElement.dojoEnabled;
        }
        combinedElement.dojoLoaderTraceEnabled = this.dojoLoaderTraceEnabled;
        if (configElement.dojoLoaderTraceEnabled != null) {
            combinedElement.dojoLoaderTraceEnabled = configElement.dojoLoaderTraceEnabled;
        }
        combinedElement.dojoBootstrapFile = this.dojoBootstrapFile;
        if (configElement.dojoBootstrapFile != null) {
            combinedElement.dojoBootstrapFile = configElement.dojoBootstrapFile;
        }
        combinedElement.dojoPageWidget = this.dojoPageWidget;
        if (configElement.dojoPageWidget != null) {
            combinedElement.dojoPageWidget = configElement.dojoPageWidget;
        }
        combinedElement.dojoBaseUrl = this.dojoBaseUrl;
        if (configElement.dojoBaseUrl != null) {
            combinedElement.dojoBaseUrl = configElement.dojoBaseUrl;
        }
        combinedElement.dojoMessagesObject = this.dojoMessagesObject;
        if (configElement.dojoMessagesObject != null) {
            combinedElement.dojoMessagesObject = configElement.dojoMessagesObject;
        }
        combinedElement.dojoMessagesDefaultScope = this.dojoMessagesDefaultScope;
        if (configElement.dojoMessagesDefaultScope != null) {
            combinedElement.dojoMessagesDefaultScope = configElement.dojoMessagesDefaultScope;
        }
        combinedElement.dojoPackages = this.dojoPackages;
        if (configElement.dojoPackages != null) {
            combinedElement.dojoPackages.putAll(configElement.dojoPackages);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RuntimeConfigDescriptor
    extends Descriptor {
        private static final String ENDPOINT_ID = "endpoint";
        private static final String STORE_ID = "store";
        private static final String WEBAPP_ID = "webapp";
        private List<String> persisterIds = new ArrayList<String>(4);

        RuntimeConfigDescriptor(Element el) {
            super(el);
            Element persistersElement = el.element("persisters");
            if (persistersElement != null) {
                List persisterElements = persistersElement.elements("persister");
                for (Element persisterElement : persisterElements) {
                    String value = persisterElement.getTextTrim();
                    this.persisterIds.add(value);
                }
            }
        }

        public String getEndpointId() {
            return this.getStringProperty(ENDPOINT_ID);
        }

        public String getStoreId() {
            return this.getStringProperty(STORE_ID);
        }

        public String getWebappId() {
            return this.getStringProperty(WEBAPP_ID);
        }

        public List<String> getPersisterIds() {
            return this.persisterIds;
        }
    }

    public static class ResourceResolverDescriptor
    extends Descriptor {
        private static final String TYPE = "type";
        private static final String ENDPOINT = "endpoint";

        ResourceResolverDescriptor(Element el) {
            super(el);
        }

        public String getType() {
            return this.getStringProperty(TYPE);
        }

        public String getEndpoint() {
            return this.getStringProperty(ENDPOINT);
        }
    }

    public static class ResourceLoaderDescriptor
    extends Descriptor {
        private static final String ENDPOINT = "endpoint";
        private static final String TYPE = "type";

        ResourceLoaderDescriptor(Element el) {
            super(el);
        }

        public String getType() {
            return this.getStringProperty(TYPE);
        }

        public String getEndpoint() {
            return this.getStringProperty(ENDPOINT);
        }
    }

    public static class PersisterConfigDescriptor
    extends Descriptor {
        private static final String CACHE_ENABLED = "cache-enabled";
        private static final String CACHE_CHECK_DELAY = "cache-check-delay";

        PersisterConfigDescriptor(Element el) {
            super(el);
        }

        public Boolean getCacheEnabled() {
            Boolean enabled = null;
            String value = this.getStringProperty(CACHE_ENABLED);
            if (value != null && value.length() != 0) {
                enabled = Boolean.parseBoolean(value);
            }
            return enabled;
        }

        public Integer getCacheCheckDelay() {
            Integer value = null;
            String v = this.getStringProperty(CACHE_CHECK_DELAY);
            if (v != null && v.length() != 0) {
                value = Integer.valueOf(v);
            }
            return value;
        }

        public void setCacheEnabled(boolean cacheEnabled) {
            this.propertiesMap.put(CACHE_ENABLED, Boolean.toString(cacheEnabled));
        }

        public void setCacheCheckDelay(int cacheCheckDelay) {
            this.propertiesMap.put(CACHE_CHECK_DELAY, Integer.toString(cacheCheckDelay));
        }
    }

    public static class TypeDescriptor
    extends Descriptor {
        private static final String CLAZZ = "class";
        private static final String NAMESPACE = "namespace";
        private static final String DESCRIPTION = "description";
        private static final String NAME = "name";
        private static final String VERSION = "version";
        private static final String PERSISTER_ID = "persister-id";
        private boolean _useDefaultPersister = this.getPersisterId() == null;

        TypeDescriptor(Element el) {
            super(el);
        }

        public String getImplementationClass() {
            return this.getStringProperty(CLAZZ);
        }

        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }

        public String getName() {
            return this.getStringProperty("name");
        }

        public String getNamespace() {
            return this.getStringProperty(NAMESPACE);
        }

        public String getVersion() {
            return this.getStringProperty(VERSION);
        }

        public String getPersisterId() {
            return this.getStringProperty(PERSISTER_ID);
        }

        public void setPersisterId(String persisterId) {
            this.propertiesMap.put(PERSISTER_ID, persisterId);
        }

        public boolean useDefaultPerister() {
            return this._useDefaultPersister;
        }
    }

    public static class TagLibraryDescriptor
    extends Descriptor {
        private static final String NAMESPACE = "namespace";
        private static final String URI = "uri";

        TagLibraryDescriptor(Element el) {
            super(el);
        }

        public String getUri() {
            return this.getStringProperty(URI);
        }

        public String getNamespace() {
            return this.getStringProperty(NAMESPACE);
        }
    }

    public static class SystemPageDescriptor
    extends Descriptor {
        private static final String PROCESSOR_ID = "processor-id";
        private static final String JSP_PATH = "jsp-path";

        SystemPageDescriptor(Element el) {
            super(el);
        }

        public String getJspPath() {
            return this.getStringProperty(JSP_PATH);
        }

        public String getProcessorId() {
            return this.getStringProperty(PROCESSOR_ID);
        }
    }

    public static class ErrorHandlerDescriptor
    extends Descriptor {
        private static final String PROCESSOR_ID = "processor-id";
        private static final String JSP_PATH = "jsp-path";

        ErrorHandlerDescriptor(Element el) {
            super(el);
        }

        public String getJspPath() {
            return this.getStringProperty(JSP_PATH);
        }

        public String getProcessorId() {
            return this.getStringProperty(PROCESSOR_ID);
        }
    }

    public static class FormatDescriptor
    extends Descriptor {
        private static final String DESCRIPTION = "description";
        private static final String NAME = "name";

        FormatDescriptor(Element el) {
            super(el);
        }

        public String getName() {
            return this.getStringProperty("name");
        }

        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Descriptor {
        private static final String ID = "id";
        HashMap<String, String> propertiesMap;
        HashMap<String, String> attributesMap;

        Descriptor(Element el) {
            List elements = el.elements();
            for (Element element : elements) {
                this.put(element);
            }
            for (int i = 0; i < el.attributeCount(); ++i) {
                Attribute attribute;
                String value;
                if (this.attributesMap == null) {
                    this.attributesMap = new HashMap();
                }
                if ((value = (attribute = el.attribute(i)).getValue()) == null) continue;
                this.attributesMap.put(attribute.getName(), value);
            }
        }

        public void put(Element el) {
            if (this.propertiesMap == null) {
                this.propertiesMap = new HashMap();
            }
            String key = el.getName();
            String value = el.getTextTrim();
            if (value != null) {
                this.propertiesMap.put(key, value);
            }
        }

        public Object get(String key) {
            if (this.propertiesMap == null) {
                this.propertiesMap = new HashMap();
            }
            return this.propertiesMap.get(key);
        }

        public String getId() {
            return (String)this.get(ID);
        }

        public Object getProperty(String key) {
            return this.get(key);
        }

        public String getStringProperty(String key) {
            return (String)this.get(key);
        }

        public Map<String, String> map() {
            return this.propertiesMap;
        }

        public Object getAttribute(String key) {
            return this.attributesMap.get(key);
        }

        public String getStringAttribute(String key) {
            return (String)this.getAttribute(key);
        }

        public Map<String, String> attributes() {
            return this.attributesMap;
        }
    }
}

