/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.Map;
import org.springframework.extensions.surf.ModelObjectService;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.extensibility.impl.AbstractFreeMarkerDirective;
import org.springframework.extensions.surf.types.Component;

public class CreateComponentDirective
extends AbstractFreeMarkerDirective {
    public static final String DIRECTIVE_NAME = "createComponent";
    private ModelObjectService modelObjectService = null;

    public CreateComponentDirective(String directiveName) {
        super(directiveName);
    }

    public void setModelObjectService(ModelObjectService modelObjectService) {
        this.modelObjectService = modelObjectService;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String scope = this.getStringProperty(params, "scope", true);
        String regionId = this.getStringProperty(params, "regionId", true);
        String sourceId = this.getStringProperty(params, "sourceId", true);
        String uri = this.getStringProperty(params, "uri", true);
        if (this.modelObjectService.getComponent(scope, regionId, sourceId) == null) {
            Component component = this.modelObjectService.newComponent(scope, regionId, sourceId);
            component.setURI(uri);
            component.setURL(uri);
            try {
                this.modelObjectService.saveObject(component);
            }
            catch (ModelObjectPersisterException e) {
                // empty catch block
            }
        }
    }
}

