/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.directives;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.extensions.directives.CssDependencyContentModelElement;
import org.springframework.extensions.directives.DependencyDeferredContentTargetModelElement;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.surf.extensibility.DeferredContentSourceModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputCSSContentModelElement
extends DependencyDeferredContentTargetModelElement {
    private static final String TYPE = "DependencyContent";
    private DependencyAggregator dependencyAggregator;
    private String resourceControllerMapping;
    private LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> cssGroupToDependencyMap = new LinkedHashMap();
    private LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> aggCssGroupToDependencyMap = new LinkedHashMap();
    private LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> dojoCssGroupToDependencyMap = new LinkedHashMap();

    public OutputCSSContentModelElement(String id, String directiveName, DependencyAggregator dependencyAggregator) {
        super(id, directiveName);
        this.dependencyAggregator = dependencyAggregator;
        this.resourceControllerMapping = this.dependencyAggregator.getServletContext().getContextPath() + this.dependencyAggregator.getDependencyHandler().getResourceControllerMapping() + "/";
    }

    @Override
    protected String getResourceControllerMapping() {
        return this.resourceControllerMapping;
    }

    public String getType() {
        return TYPE;
    }

    public LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> getCssGroupToDependencyMap() {
        return this.cssGroupToDependencyMap;
    }

    public LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> getAggCssGroupToDependencyMap() {
        return this.aggCssGroupToDependencyMap;
    }

    public LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> getDojoCssGroupToDependencyMap() {
        return this.dojoCssGroupToDependencyMap;
    }

    public void addCssDependency(String fileName, String mediaType, String group, boolean forAggregation) {
        if (!this.dependencyAlreadyRequested(fileName = this.normaliseDependency(fileName))) {
            this.markDependencyAsRequested(fileName);
            if (forAggregation) {
                this.addCssDependency(fileName, mediaType, group, this.aggCssGroupToDependencyMap);
            } else {
                String checksumPath = this.dependencyAggregator.getDependencyHandler().getChecksumPath(fileName);
                this.addCssDependency(this.resourceControllerMapping + checksumPath, mediaType, group, this.cssGroupToDependencyMap);
            }
        }
    }

    public void addCssDependency(String fileName, String mediaType, String group, LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> cssGroupToDependencyMap) {
        LinkedHashSet<String> cssDependencies;
        HashMap<String, LinkedHashSet<String>> mediaToDependencyMap = cssGroupToDependencyMap.get(group);
        if (mediaToDependencyMap == null) {
            mediaToDependencyMap = new HashMap();
            cssGroupToDependencyMap.put(group, mediaToDependencyMap);
        }
        if ((cssDependencies = mediaToDependencyMap.get(mediaType)) == null) {
            cssDependencies = new LinkedHashSet();
            mediaToDependencyMap.put(mediaType, cssDependencies);
        }
        cssDependencies.add(fileName);
    }

    public void addDojoCssDependency(String fileName, String mediaType, String group) {
        fileName = this.normaliseDependency(fileName);
        this.addCssDependency(fileName, mediaType, group, this.dojoCssGroupToDependencyMap);
    }

    protected LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> filterCssDependencies(LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> dependencies) {
        LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> filteredMap = new LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>>();
        for (Map.Entry<String, HashMap<String, LinkedHashSet<String>>> groupEntry : dependencies.entrySet()) {
            HashMap filteredInnerMap = new HashMap();
            filteredMap.put(groupEntry.getKey(), filteredInnerMap);
            for (Map.Entry<String, LinkedHashSet<String>> mediaToCssResource : groupEntry.getValue().entrySet()) {
                LinkedHashSet<String> filteredResources = new LinkedHashSet<String>();
                filteredInnerMap.put(mediaToCssResource.getKey(), filteredResources);
                for (String cssResource : mediaToCssResource.getValue()) {
                    if (this.dependencyAlreadyRequested(cssResource)) continue;
                    filteredResources.add(cssResource);
                    this.markDependencyAsRequested(cssResource);
                }
            }
        }
        return filteredMap;
    }

    public String flushContent() {
        StringBuilder content = new StringBuilder();
        for (DeferredContentSourceModelElement sourceElement : this.getSourceElements()) {
            if (!(sourceElement instanceof CssDependencyContentModelElement)) continue;
            CssDependencyContentModelElement dependency = (CssDependencyContentModelElement)sourceElement;
            this.addCssDependency(dependency.getDependency(), dependency.getMedia(), dependency.getGroup(), ((CssDependencyContentModelElement)sourceElement).isAggregate());
        }
        content.append((CharSequence)this.generateCSSDependencies(this.cssGroupToDependencyMap, false));
        content.append((CharSequence)this.generateCSSDependencies(this.aggCssGroupToDependencyMap, true));
        LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> filteredDojoCssDependencyMap = this.filterCssDependencies(this.dojoCssGroupToDependencyMap);
        content.append((CharSequence)this.generateCSSDependencies(filteredDojoCssDependencyMap, true));
        return content.toString();
    }

    private StringBuilder generateCSSDependencies(LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> cssMap, boolean aggregate) {
        StringBuilder cssDeps = new StringBuilder();
        for (HashMap<String, LinkedHashSet<String>> group : cssMap.values()) {
            for (Map.Entry<String, LinkedHashSet<String>> mediaToCssResource : group.entrySet()) {
                if (aggregate) {
                    String checksum = this.dependencyAggregator.generateCSSDependencies(mediaToCssResource.getValue());
                    this.appendCSSLink(cssDeps, this.resourceControllerMapping + checksum, mediaToCssResource.getKey());
                    continue;
                }
                cssDeps.append("   <style type=\"text/css\" media=\"");
                cssDeps.append(mediaToCssResource.getKey());
                cssDeps.append("\">\n");
                int count = 0;
                for (String cssResource : mediaToCssResource.getValue()) {
                    ++count;
                    cssDeps.append("      @import url(\"");
                    cssDeps.append(cssResource);
                    cssDeps.append("\");\n");
                    if (count != 31) continue;
                    cssDeps.append("   </style>\n\n");
                    cssDeps.append("   <style type=\"text/css\" media=\"");
                    cssDeps.append(mediaToCssResource.getKey());
                    cssDeps.append("\">\n");
                    count = 0;
                }
                cssDeps.append("   </style>\n\n");
            }
        }
        return cssDeps;
    }

    private void appendCSSLink(StringBuilder cssDeps, String file, String media) {
        cssDeps.append("   <link rel=\"stylesheet\" type=\"text/css\" href=\"");
        cssDeps.append(file);
        cssDeps.append("\" media=\"");
        cssDeps.append(media);
        cssDeps.append("\">\n");
    }
}

