/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.ModelObjectPersister;
import org.springframework.extensions.surf.persister.MultiObjectPersister;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Store;
import org.springframework.extensions.webscripts.processor.FTLTemplateProcessor;
import org.springframework.extensions.webscripts.processor.JSScriptProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutowireService {
    private static final Log logger = LogFactory.getLog(AutowireService.class);
    private SearchPath webScriptsSearchPath;
    private SearchPath templatesSearchPath;
    private List<Store> commonWebScriptPaths;
    private List<Store> alfrescoWebScriptPaths;
    private List<Store> webInfWebScriptPaths;
    private List<Store> localWebScriptPaths;
    private List<Store> commonTemplatePaths;
    private List<Store> alfrescoTemplatePaths;
    private List<Store> webInfTemplatePaths;
    private List<Store> localTemplatePaths;
    private List<ModelObjectPersister> commonPersisterPaths;
    private List<ModelObjectPersister> alfrescoPersisterPaths;
    private List<ModelObjectPersister> webInfPersisterPaths;
    private List<ModelObjectPersister> localPersisterPaths;
    private FTLTemplateProcessor webscriptsTemplateProcessor;
    private JSScriptProcessor webscriptsScriptProcessor;
    private FTLTemplateProcessor templatesTemplateProcessor;
    private JSScriptProcessor templatesScriptProcessor;

    public void configureMode(WebFrameworkConfigElement webFrameworkConfig) throws Exception {
        String autowireModeId = webFrameworkConfig.getAutowireModeId();
        if (autowireModeId != null) {
            if ("developer".equalsIgnoreCase(autowireModeId) || "development".equalsIgnoreCase(autowireModeId)) {
                webFrameworkConfig.getPersisterConfigDescriptor().setCacheEnabled(false);
                webFrameworkConfig.getPersisterConfigDescriptor().setCacheCheckDelay(0);
                this.webscriptsTemplateProcessor.setUpdateDelay(0);
                this.webscriptsScriptProcessor.setCompile(false);
                this.templatesTemplateProcessor.setUpdateDelay(0);
                this.templatesScriptProcessor.setCompile(false);
            }
            if ("production".equalsIgnoreCase(autowireModeId)) {
                webFrameworkConfig.getPersisterConfigDescriptor().setCacheEnabled(true);
                webFrameworkConfig.getPersisterConfigDescriptor().setCacheCheckDelay(-1);
                this.webscriptsTemplateProcessor.setUpdateDelay(86400);
                this.webscriptsScriptProcessor.setCompile(true);
                this.templatesTemplateProcessor.setUpdateDelay(86400);
                this.templatesScriptProcessor.setCompile(true);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Autowire Mode - " + autowireModeId));
            }
        }
    }

    public void configureRuntime(WebFrameworkConfigElement webFrameworkConfig, MultiObjectPersister multiObjectPersister) throws Exception {
        String autowireRuntimeId = webFrameworkConfig.getAutowireRuntimeId();
        if (autowireRuntimeId != null && !autowireRuntimeId.equals("alfresco")) {
            if ("classpath".equalsIgnoreCase(autowireRuntimeId) || "webapp".equalsIgnoreCase(autowireRuntimeId) || "local".equalsIgnoreCase(autowireRuntimeId)) {
                this.commonWebScriptPaths.addAll(this.alfrescoWebScriptPaths);
                this.commonTemplatePaths.addAll(this.alfrescoTemplatePaths);
                this.commonPersisterPaths.addAll(this.alfrescoPersisterPaths);
            }
            if ("webapp".equalsIgnoreCase(autowireRuntimeId) || "local".equalsIgnoreCase(autowireRuntimeId)) {
                this.commonWebScriptPaths.addAll(this.webInfWebScriptPaths);
                this.commonTemplatePaths.addAll(this.webInfTemplatePaths);
                this.commonPersisterPaths.addAll(this.webInfPersisterPaths);
            }
            if ("local".equalsIgnoreCase(autowireRuntimeId)) {
                this.commonWebScriptPaths.addAll(this.localWebScriptPaths);
                this.commonTemplatePaths.addAll(this.localTemplatePaths);
                this.commonPersisterPaths.addAll(this.localPersisterPaths);
            }
            if (this.webScriptsSearchPath == null) {
                throw new Exception("Autowire service has not been configured with a \"webScriptsSearchPath\" property");
            }
            this.webScriptsSearchPath.setSearchPath(this.commonWebScriptPaths);
            if (this.templatesSearchPath == null) {
                throw new Exception("Autowire service has not been configured with a \"templatesSearchPath\" property");
            }
            this.templatesSearchPath.setSearchPath(this.commonTemplatePaths);
            if (multiObjectPersister != null) {
                multiObjectPersister.setPersisters(this.commonPersisterPaths);
            } else {
                throw new Exception("Autowire service has not been configured with a \"multiObjectPersister\" property");
            }
        }
        if (logger.isInfoEnabled()) {
            if (autowireRuntimeId != null) {
                logger.info((Object)("Autowire Runtime - " + autowireRuntimeId));
            }
            this.reportSearchPath(this.templatesSearchPath);
            this.reportSearchPath(this.webScriptsSearchPath);
            this.reportPersister(multiObjectPersister);
        }
    }

    protected void reportSearchPath(SearchPath searchPath) {
        if (logger.isInfoEnabled()) {
            StringBuilder s = new StringBuilder();
            s.append("[");
            if (searchPath != null) {
                Iterator it = searchPath.getStores().iterator();
                while (it.hasNext()) {
                    Store store = (Store)it.next();
                    s.append("'");
                    s.append(store.toString());
                    s.append("'");
                    if (!it.hasNext()) continue;
                    s.append(",");
                }
            }
            s.append("]");
            logger.info((Object)("Search Path: " + searchPath + " = " + s.toString()));
        }
    }

    protected void reportPersister(ModelObjectPersister persister) {
        if (logger.isInfoEnabled()) {
            StringBuilder s = new StringBuilder();
            s.append("[");
            if (persister != null && persister instanceof MultiObjectPersister) {
                MultiObjectPersister mop = (MultiObjectPersister)persister;
                List<ModelObjectPersister> persisters = mop.getPersisters();
                for (int i = 0; i < persisters.size(); ++i) {
                    ModelObjectPersister p = persisters.get(i);
                    s.append("'");
                    s.append(p.getId());
                    s.append("'");
                    if (i + 1 < persisters.size()) {
                        // empty if block
                    }
                    s.append(",");
                }
            }
            s.append("]");
            logger.info((Object)("Persister: " + persister + " = " + s.toString()));
        }
    }

    public void setCommonWebScriptPaths(List<Store> commonWebScriptPaths) {
        this.commonWebScriptPaths = commonWebScriptPaths;
    }

    public void setAlfrescoWebScriptPaths(List<Store> alfrescoWebScriptPaths) {
        this.alfrescoWebScriptPaths = alfrescoWebScriptPaths;
    }

    public void setWebInfWebScriptPaths(List<Store> webInfWebScriptPaths) {
        this.webInfWebScriptPaths = webInfWebScriptPaths;
    }

    public void setLocalWebScriptPaths(List<Store> localWebScriptPaths) {
        this.localWebScriptPaths = localWebScriptPaths;
    }

    public void setCommonTemplatePaths(List<Store> commonTemplatePaths) {
        this.commonTemplatePaths = commonTemplatePaths;
    }

    public void setAlfrescoTemplatePaths(List<Store> alfrescoTemplatePaths) {
        this.alfrescoTemplatePaths = alfrescoTemplatePaths;
    }

    public void setWebInfTemplatePaths(List<Store> webInfTemplatePaths) {
        this.webInfTemplatePaths = webInfTemplatePaths;
    }

    public void setLocalTemplatePaths(List<Store> localTemplatePaths) {
        this.localTemplatePaths = localTemplatePaths;
    }

    public void setCommonPersisterPaths(List<ModelObjectPersister> commonPersisterPaths) {
        this.commonPersisterPaths = commonPersisterPaths;
    }

    public void setAlfrescoPersisterPaths(List<ModelObjectPersister> alfrescoPersisterPaths) {
        this.alfrescoPersisterPaths = alfrescoPersisterPaths;
    }

    public void setWebInfPersisterPaths(List<ModelObjectPersister> webInfPersisterPaths) {
        this.webInfPersisterPaths = webInfPersisterPaths;
    }

    public void setLocalPersisterPaths(List<ModelObjectPersister> localPersisterPaths) {
        this.localPersisterPaths = localPersisterPaths;
    }

    public void setWebscriptsTemplateProcessor(FTLTemplateProcessor webscriptsTemplateProcessor) {
        this.webscriptsTemplateProcessor = webscriptsTemplateProcessor;
    }

    public void setWebscriptsScriptProcessor(JSScriptProcessor webscriptsScriptProcessor) {
        this.webscriptsScriptProcessor = webscriptsScriptProcessor;
    }

    public void setTemplatesTemplateProcessor(FTLTemplateProcessor templatesTemplateProcessor) {
        this.templatesTemplateProcessor = templatesTemplateProcessor;
    }

    public void setTemplatesScriptProcessor(JSScriptProcessor templatesScriptProcessor) {
        this.templatesScriptProcessor = templatesScriptProcessor;
    }

    public void setWebScriptsSearchPath(SearchPath webScriptsSearchPath) {
        this.webScriptsSearchPath = webScriptsSearchPath;
    }

    public void setTemplatesSearchPath(SearchPath templatesSearchPath) {
        this.templatesSearchPath = templatesSearchPath;
    }

    public SearchPath getWebScriptsSearchPath() {
        return this.webScriptsSearchPath;
    }

    public SearchPath getTemplatesSearchPath() {
        return this.templatesSearchPath;
    }

    public List<Store> getCommonWebScriptPaths() {
        return this.commonWebScriptPaths;
    }

    public List<Store> getAlfrescoWebScriptPaths() {
        return this.alfrescoWebScriptPaths;
    }

    public List<Store> getWebInfWebScriptPaths() {
        return this.webInfWebScriptPaths;
    }

    public List<Store> getLocalWebScriptPaths() {
        return this.localWebScriptPaths;
    }

    public List<Store> getCommonTemplatePaths() {
        return this.commonTemplatePaths;
    }

    public List<Store> getAlfrescoTemplatePaths() {
        return this.alfrescoTemplatePaths;
    }

    public List<Store> getWebInfTemplatePaths() {
        return this.webInfTemplatePaths;
    }

    public List<Store> getLocalTemplatePaths() {
        return this.localTemplatePaths;
    }

    public List<ModelObjectPersister> getCommonPersisterPaths() {
        return this.commonPersisterPaths;
    }

    public List<ModelObjectPersister> getAlfrescoPersisterPaths() {
        return this.alfrescoPersisterPaths;
    }

    public List<ModelObjectPersister> getWebInfPersisterPaths() {
        return this.webInfPersisterPaths;
    }

    public List<ModelObjectPersister> getLocalPersisterPaths() {
        return this.localPersisterPaths;
    }

    public FTLTemplateProcessor getWebscriptsTemplateProcessor() {
        return this.webscriptsTemplateProcessor;
    }

    public JSScriptProcessor getWebscriptsScriptProcessor() {
        return this.webscriptsScriptProcessor;
    }

    public FTLTemplateProcessor getTemplatesTemplateProcessor() {
        return this.templatesTemplateProcessor;
    }

    public JSScriptProcessor getTemplatesScriptProcessor() {
        return this.templatesScriptProcessor;
    }
}

